<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LaborCostRate StructType
 * @subpackage Structs
 */
class LaborCostRate extends Entity
{
    /**
     * The AnnualRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AnnualRate;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $EffectiveDate;
    /**
     * The EmployeeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $EmployeeID;
    /**
     * The EmployeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $EmployeeName;
    /**
     * The ExternalRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ExternalRefNbr;
    /**
     * The HourlyRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $HourlyRate;
    /**
     * The LaborItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LaborItem;
    /**
     * The LaborRateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LaborRateType;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The RecordID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $RecordID;
    /**
     * The RegularHoursPerWeek
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $RegularHoursPerWeek;
    /**
     * The TypeOfEmployment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TypeOfEmployment;
    /**
     * The UnionLocalID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UnionLocalID;
    /**
     * Constructor method for LaborCostRate
     * @uses LaborCostRate::setAnnualRate()
     * @uses LaborCostRate::setCurrencyID()
     * @uses LaborCostRate::setDescription()
     * @uses LaborCostRate::setEffectiveDate()
     * @uses LaborCostRate::setEmployeeID()
     * @uses LaborCostRate::setEmployeeName()
     * @uses LaborCostRate::setExternalRefNbr()
     * @uses LaborCostRate::setHourlyRate()
     * @uses LaborCostRate::setLaborItem()
     * @uses LaborCostRate::setLaborRateType()
     * @uses LaborCostRate::setProjectID()
     * @uses LaborCostRate::setProjectTaskID()
     * @uses LaborCostRate::setRecordID()
     * @uses LaborCostRate::setRegularHoursPerWeek()
     * @uses LaborCostRate::setTypeOfEmployment()
     * @uses LaborCostRate::setUnionLocalID()
     * @param \App\API\SOAP\StructType\DecimalValue $annualRate
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DateTimeValue $effectiveDate
     * @param \App\API\SOAP\StructType\StringValue $employeeID
     * @param \App\API\SOAP\StructType\StringValue $employeeName
     * @param \App\API\SOAP\StructType\StringValue $externalRefNbr
     * @param \App\API\SOAP\StructType\DecimalValue $hourlyRate
     * @param \App\API\SOAP\StructType\StringValue $laborItem
     * @param \App\API\SOAP\StructType\StringValue $laborRateType
     * @param \App\API\SOAP\StructType\StringValue $projectID
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @param \App\API\SOAP\StructType\IntValue $recordID
     * @param \App\API\SOAP\StructType\DecimalValue $regularHoursPerWeek
     * @param \App\API\SOAP\StructType\StringValue $typeOfEmployment
     * @param \App\API\SOAP\StructType\StringValue $unionLocalID
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $annualRate = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DateTimeValue $effectiveDate = null, \App\API\SOAP\StructType\StringValue $employeeID = null, \App\API\SOAP\StructType\StringValue $employeeName = null, \App\API\SOAP\StructType\StringValue $externalRefNbr = null, \App\API\SOAP\StructType\DecimalValue $hourlyRate = null, \App\API\SOAP\StructType\StringValue $laborItem = null, \App\API\SOAP\StructType\StringValue $laborRateType = null, \App\API\SOAP\StructType\StringValue $projectID = null, \App\API\SOAP\StructType\StringValue $projectTaskID = null, \App\API\SOAP\StructType\IntValue $recordID = null, \App\API\SOAP\StructType\DecimalValue $regularHoursPerWeek = null, \App\API\SOAP\StructType\StringValue $typeOfEmployment = null, \App\API\SOAP\StructType\StringValue $unionLocalID = null)
    {
        $this
            ->setAnnualRate($annualRate)
            ->setCurrencyID($currencyID)
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setEmployeeID($employeeID)
            ->setEmployeeName($employeeName)
            ->setExternalRefNbr($externalRefNbr)
            ->setHourlyRate($hourlyRate)
            ->setLaborItem($laborItem)
            ->setLaborRateType($laborRateType)
            ->setProjectID($projectID)
            ->setProjectTaskID($projectTaskID)
            ->setRecordID($recordID)
            ->setRegularHoursPerWeek($regularHoursPerWeek)
            ->setTypeOfEmployment($typeOfEmployment)
            ->setUnionLocalID($unionLocalID);
    }
    /**
     * Get AnnualRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAnnualRate()
    {
        return isset($this->AnnualRate) ? $this->AnnualRate : null;
    }
    /**
     * Set AnnualRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $annualRate
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setAnnualRate(\App\API\SOAP\StructType\DecimalValue $annualRate = null)
    {
        if (is_null($annualRate) || (is_array($annualRate) && empty($annualRate))) {
            unset($this->AnnualRate);
        } else {
            $this->AnnualRate = $annualRate;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getEffectiveDate()
    {
        return isset($this->EffectiveDate) ? $this->EffectiveDate : null;
    }
    /**
     * Set EffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $effectiveDate
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setEffectiveDate(\App\API\SOAP\StructType\DateTimeValue $effectiveDate = null)
    {
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->EffectiveDate);
        } else {
            $this->EffectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get EmployeeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEmployeeID()
    {
        return isset($this->EmployeeID) ? $this->EmployeeID : null;
    }
    /**
     * Set EmployeeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $employeeID
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setEmployeeID(\App\API\SOAP\StructType\StringValue $employeeID = null)
    {
        if (is_null($employeeID) || (is_array($employeeID) && empty($employeeID))) {
            unset($this->EmployeeID);
        } else {
            $this->EmployeeID = $employeeID;
        }
        return $this;
    }
    /**
     * Get EmployeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEmployeeName()
    {
        return isset($this->EmployeeName) ? $this->EmployeeName : null;
    }
    /**
     * Set EmployeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $employeeName
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setEmployeeName(\App\API\SOAP\StructType\StringValue $employeeName = null)
    {
        if (is_null($employeeName) || (is_array($employeeName) && empty($employeeName))) {
            unset($this->EmployeeName);
        } else {
            $this->EmployeeName = $employeeName;
        }
        return $this;
    }
    /**
     * Get ExternalRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getExternalRefNbr()
    {
        return isset($this->ExternalRefNbr) ? $this->ExternalRefNbr : null;
    }
    /**
     * Set ExternalRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $externalRefNbr
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setExternalRefNbr(\App\API\SOAP\StructType\StringValue $externalRefNbr = null)
    {
        if (is_null($externalRefNbr) || (is_array($externalRefNbr) && empty($externalRefNbr))) {
            unset($this->ExternalRefNbr);
        } else {
            $this->ExternalRefNbr = $externalRefNbr;
        }
        return $this;
    }
    /**
     * Get HourlyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getHourlyRate()
    {
        return isset($this->HourlyRate) ? $this->HourlyRate : null;
    }
    /**
     * Set HourlyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $hourlyRate
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setHourlyRate(\App\API\SOAP\StructType\DecimalValue $hourlyRate = null)
    {
        if (is_null($hourlyRate) || (is_array($hourlyRate) && empty($hourlyRate))) {
            unset($this->HourlyRate);
        } else {
            $this->HourlyRate = $hourlyRate;
        }
        return $this;
    }
    /**
     * Get LaborItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLaborItem()
    {
        return isset($this->LaborItem) ? $this->LaborItem : null;
    }
    /**
     * Set LaborItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $laborItem
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setLaborItem(\App\API\SOAP\StructType\StringValue $laborItem = null)
    {
        if (is_null($laborItem) || (is_array($laborItem) && empty($laborItem))) {
            unset($this->LaborItem);
        } else {
            $this->LaborItem = $laborItem;
        }
        return $this;
    }
    /**
     * Get LaborRateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLaborRateType()
    {
        return isset($this->LaborRateType) ? $this->LaborRateType : null;
    }
    /**
     * Set LaborRateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $laborRateType
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setLaborRateType(\App\API\SOAP\StructType\StringValue $laborRateType = null)
    {
        if (is_null($laborRateType) || (is_array($laborRateType) && empty($laborRateType))) {
            unset($this->LaborRateType);
        } else {
            $this->LaborRateType = $laborRateType;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectID
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setProjectID(\App\API\SOAP\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setProjectTaskID(\App\API\SOAP\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get RecordID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getRecordID()
    {
        return isset($this->RecordID) ? $this->RecordID : null;
    }
    /**
     * Set RecordID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $recordID
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setRecordID(\App\API\SOAP\StructType\IntValue $recordID = null)
    {
        if (is_null($recordID) || (is_array($recordID) && empty($recordID))) {
            unset($this->RecordID);
        } else {
            $this->RecordID = $recordID;
        }
        return $this;
    }
    /**
     * Get RegularHoursPerWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getRegularHoursPerWeek()
    {
        return isset($this->RegularHoursPerWeek) ? $this->RegularHoursPerWeek : null;
    }
    /**
     * Set RegularHoursPerWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $regularHoursPerWeek
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setRegularHoursPerWeek(\App\API\SOAP\StructType\DecimalValue $regularHoursPerWeek = null)
    {
        if (is_null($regularHoursPerWeek) || (is_array($regularHoursPerWeek) && empty($regularHoursPerWeek))) {
            unset($this->RegularHoursPerWeek);
        } else {
            $this->RegularHoursPerWeek = $regularHoursPerWeek;
        }
        return $this;
    }
    /**
     * Get TypeOfEmployment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTypeOfEmployment()
    {
        return isset($this->TypeOfEmployment) ? $this->TypeOfEmployment : null;
    }
    /**
     * Set TypeOfEmployment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $typeOfEmployment
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setTypeOfEmployment(\App\API\SOAP\StructType\StringValue $typeOfEmployment = null)
    {
        if (is_null($typeOfEmployment) || (is_array($typeOfEmployment) && empty($typeOfEmployment))) {
            unset($this->TypeOfEmployment);
        } else {
            $this->TypeOfEmployment = $typeOfEmployment;
        }
        return $this;
    }
    /**
     * Get UnionLocalID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUnionLocalID()
    {
        return isset($this->UnionLocalID) ? $this->UnionLocalID : null;
    }
    /**
     * Set UnionLocalID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $unionLocalID
     * @return \App\API\SOAP\StructType\LaborCostRate
     */
    public function setUnionLocalID(\App\API\SOAP\StructType\StringValue $unionLocalID = null)
    {
        if (is_null($unionLocalID) || (is_array($unionLocalID) && empty($unionLocalID))) {
            unset($this->UnionLocalID);
        } else {
            $this->UnionLocalID = $unionLocalID;
        }
        return $this;
    }
}
