<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitSpecification StructType
 * @subpackage Structs
 */
class KitSpecification extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Active;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The IsNonStock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IsNonStock;
    /**
     * The KitInventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $KitInventoryID;
    /**
     * The NonStockComponents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\NonStockComponents
     */
    public $NonStockComponents;
    /**
     * The RevisionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $RevisionID;
    /**
     * The StockComponents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StockComponents
     */
    public $StockComponents;
    /**
     * Constructor method for KitSpecification
     * @uses KitSpecification::setActive()
     * @uses KitSpecification::setDescription()
     * @uses KitSpecification::setIsNonStock()
     * @uses KitSpecification::setKitInventoryID()
     * @uses KitSpecification::setNonStockComponents()
     * @uses KitSpecification::setRevisionID()
     * @uses KitSpecification::setStockComponents()
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\BooleanValue $isNonStock
     * @param \App\API\SOAP\StructType\StringValue $kitInventoryID
     * @param \App\API\SOAP\StructType\NonStockComponents $nonStockComponents
     * @param \App\API\SOAP\StructType\StringValue $revisionID
     * @param \App\API\SOAP\StructType\StockComponents $stockComponents
     */
    public function __construct(\App\API\SOAP\StructType\BooleanValue $active = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\BooleanValue $isNonStock = null, \App\API\SOAP\StructType\StringValue $kitInventoryID = null, \App\API\SOAP\StructType\NonStockComponents $nonStockComponents = null, \App\API\SOAP\StructType\StringValue $revisionID = null, \App\API\SOAP\StructType\StockComponents $stockComponents = null)
    {
        $this
            ->setActive($active)
            ->setDescription($description)
            ->setIsNonStock($isNonStock)
            ->setKitInventoryID($kitInventoryID)
            ->setNonStockComponents($nonStockComponents)
            ->setRevisionID($revisionID)
            ->setStockComponents($stockComponents);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $active
     * @return \App\API\SOAP\StructType\KitSpecification
     */
    public function setActive(\App\API\SOAP\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\KitSpecification
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsNonStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIsNonStock()
    {
        return isset($this->IsNonStock) ? $this->IsNonStock : null;
    }
    /**
     * Set IsNonStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $isNonStock
     * @return \App\API\SOAP\StructType\KitSpecification
     */
    public function setIsNonStock(\App\API\SOAP\StructType\BooleanValue $isNonStock = null)
    {
        if (is_null($isNonStock) || (is_array($isNonStock) && empty($isNonStock))) {
            unset($this->IsNonStock);
        } else {
            $this->IsNonStock = $isNonStock;
        }
        return $this;
    }
    /**
     * Get KitInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getKitInventoryID()
    {
        return isset($this->KitInventoryID) ? $this->KitInventoryID : null;
    }
    /**
     * Set KitInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $kitInventoryID
     * @return \App\API\SOAP\StructType\KitSpecification
     */
    public function setKitInventoryID(\App\API\SOAP\StructType\StringValue $kitInventoryID = null)
    {
        if (is_null($kitInventoryID) || (is_array($kitInventoryID) && empty($kitInventoryID))) {
            unset($this->KitInventoryID);
        } else {
            $this->KitInventoryID = $kitInventoryID;
        }
        return $this;
    }
    /**
     * Get NonStockComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\NonStockComponents|null
     */
    public function getNonStockComponents()
    {
        return isset($this->NonStockComponents) ? $this->NonStockComponents : null;
    }
    /**
     * Set NonStockComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\NonStockComponents $nonStockComponents
     * @return \App\API\SOAP\StructType\KitSpecification
     */
    public function setNonStockComponents(\App\API\SOAP\StructType\NonStockComponents $nonStockComponents = null)
    {
        if (is_null($nonStockComponents) || (is_array($nonStockComponents) && empty($nonStockComponents))) {
            unset($this->NonStockComponents);
        } else {
            $this->NonStockComponents = $nonStockComponents;
        }
        return $this;
    }
    /**
     * Get RevisionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getRevisionID()
    {
        return isset($this->RevisionID) ? $this->RevisionID : null;
    }
    /**
     * Set RevisionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $revisionID
     * @return \App\API\SOAP\StructType\KitSpecification
     */
    public function setRevisionID(\App\API\SOAP\StructType\StringValue $revisionID = null)
    {
        if (is_null($revisionID) || (is_array($revisionID) && empty($revisionID))) {
            unset($this->RevisionID);
        } else {
            $this->RevisionID = $revisionID;
        }
        return $this;
    }
    /**
     * Get StockComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StockComponents|null
     */
    public function getStockComponents()
    {
        return isset($this->StockComponents) ? $this->StockComponents : null;
    }
    /**
     * Set StockComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StockComponents $stockComponents
     * @return \App\API\SOAP\StructType\KitSpecification
     */
    public function setStockComponents(\App\API\SOAP\StructType\StockComponents $stockComponents = null)
    {
        if (is_null($stockComponents) || (is_array($stockComponents) && empty($stockComponents))) {
            unset($this->StockComponents);
        } else {
            $this->StockComponents = $stockComponents;
        }
        return $this;
    }
}
