<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitAssemblyNonStockComponent StructType
 * @subpackage Structs
 */
class KitAssemblyNonStockComponent extends Entity
{
    /**
     * The ComponentQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ComponentQty;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The NonStockInventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $NonStockInventoryID;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReasonCode;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for KitAssemblyNonStockComponent
     * @uses KitAssemblyNonStockComponent::setComponentQty()
     * @uses KitAssemblyNonStockComponent::setLineNbr()
     * @uses KitAssemblyNonStockComponent::setNonStockInventoryID()
     * @uses KitAssemblyNonStockComponent::setQty()
     * @uses KitAssemblyNonStockComponent::setReasonCode()
     * @uses KitAssemblyNonStockComponent::setUnitCost()
     * @uses KitAssemblyNonStockComponent::setUOM()
     * @param \App\API\SOAP\StructType\DecimalValue $componentQty
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @param \App\API\SOAP\StructType\StringValue $nonStockInventoryID
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @param \App\API\SOAP\StructType\StringValue $reasonCode
     * @param \App\API\SOAP\StructType\DecimalValue $unitCost
     * @param \App\API\SOAP\StructType\StringValue $uOM
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $componentQty = null, \App\API\SOAP\StructType\IntValue $lineNbr = null, \App\API\SOAP\StructType\StringValue $nonStockInventoryID = null, \App\API\SOAP\StructType\DecimalValue $qty = null, \App\API\SOAP\StructType\StringValue $reasonCode = null, \App\API\SOAP\StructType\DecimalValue $unitCost = null, \App\API\SOAP\StructType\StringValue $uOM = null)
    {
        $this
            ->setComponentQty($componentQty)
            ->setLineNbr($lineNbr)
            ->setNonStockInventoryID($nonStockInventoryID)
            ->setQty($qty)
            ->setReasonCode($reasonCode)
            ->setUnitCost($unitCost)
            ->setUOM($uOM);
    }
    /**
     * Get ComponentQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getComponentQty()
    {
        return isset($this->ComponentQty) ? $this->ComponentQty : null;
    }
    /**
     * Set ComponentQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $componentQty
     * @return \App\API\SOAP\StructType\KitAssemblyNonStockComponent
     */
    public function setComponentQty(\App\API\SOAP\StructType\DecimalValue $componentQty = null)
    {
        if (is_null($componentQty) || (is_array($componentQty) && empty($componentQty))) {
            unset($this->ComponentQty);
        } else {
            $this->ComponentQty = $componentQty;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $lineNbr
     * @return \App\API\SOAP\StructType\KitAssemblyNonStockComponent
     */
    public function setLineNbr(\App\API\SOAP\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get NonStockInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getNonStockInventoryID()
    {
        return isset($this->NonStockInventoryID) ? $this->NonStockInventoryID : null;
    }
    /**
     * Set NonStockInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $nonStockInventoryID
     * @return \App\API\SOAP\StructType\KitAssemblyNonStockComponent
     */
    public function setNonStockInventoryID(\App\API\SOAP\StructType\StringValue $nonStockInventoryID = null)
    {
        if (is_null($nonStockInventoryID) || (is_array($nonStockInventoryID) && empty($nonStockInventoryID))) {
            unset($this->NonStockInventoryID);
        } else {
            $this->NonStockInventoryID = $nonStockInventoryID;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @return \App\API\SOAP\StructType\KitAssemblyNonStockComponent
     */
    public function setQty(\App\API\SOAP\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $reasonCode
     * @return \App\API\SOAP\StructType\KitAssemblyNonStockComponent
     */
    public function setReasonCode(\App\API\SOAP\StructType\StringValue $reasonCode = null)
    {
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unitCost
     * @return \App\API\SOAP\StructType\KitAssemblyNonStockComponent
     */
    public function setUnitCost(\App\API\SOAP\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\KitAssemblyNonStockComponent
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
