<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemWarehouse StructType
 * @subpackage Structs
 */
class ItemWarehouse extends Entity
{
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The DefaultIssueFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultIssueFrom;
    /**
     * The DefaultReceiptTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultReceiptTo;
    /**
     * The DefaultSubitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DefaultSubitem;
    /**
     * The InventoryAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryAccount;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The InventorySubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventorySubaccount;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The MSRP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $MSRP;
    /**
     * The OverrideInventoryAccountSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $OverrideInventoryAccountSubaccount;
    /**
     * The OverridePreferredVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $OverridePreferredVendor;
    /**
     * The OverridePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $OverridePrice;
    /**
     * The OverrideReplenishmentSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $OverrideReplenishmentSettings;
    /**
     * The OverrideServiceLevelOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $OverrideServiceLevelOverride;
    /**
     * The OverrideStandardCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $OverrideStandardCost;
    /**
     * The PreferredLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PreferredLocation;
    /**
     * The PreferredVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PreferredVendor;
    /**
     * The ProductManager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProductManager;
    /**
     * The ProductWorkgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProductWorkgroup;
    /**
     * The ReplenishmentClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReplenishmentClass;
    /**
     * The ReplenishmentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReplenishmentMethod;
    /**
     * The ReplenishmentSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReplenishmentSource;
    /**
     * The ReplenishmentWarehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReplenishmentWarehouse;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Seasonality;
    /**
     * The ServiceLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ServiceLevel;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for ItemWarehouse
     * @uses ItemWarehouse::setCreatedDateTime()
     * @uses ItemWarehouse::setDefaultIssueFrom()
     * @uses ItemWarehouse::setDefaultReceiptTo()
     * @uses ItemWarehouse::setDefaultSubitem()
     * @uses ItemWarehouse::setInventoryAccount()
     * @uses ItemWarehouse::setInventoryID()
     * @uses ItemWarehouse::setInventorySubaccount()
     * @uses ItemWarehouse::setLastModifiedDateTime()
     * @uses ItemWarehouse::setMSRP()
     * @uses ItemWarehouse::setOverrideInventoryAccountSubaccount()
     * @uses ItemWarehouse::setOverridePreferredVendor()
     * @uses ItemWarehouse::setOverridePrice()
     * @uses ItemWarehouse::setOverrideReplenishmentSettings()
     * @uses ItemWarehouse::setOverrideServiceLevelOverride()
     * @uses ItemWarehouse::setOverrideStandardCost()
     * @uses ItemWarehouse::setPreferredLocation()
     * @uses ItemWarehouse::setPreferredVendor()
     * @uses ItemWarehouse::setProductManager()
     * @uses ItemWarehouse::setProductWorkgroup()
     * @uses ItemWarehouse::setReplenishmentClass()
     * @uses ItemWarehouse::setReplenishmentMethod()
     * @uses ItemWarehouse::setReplenishmentSource()
     * @uses ItemWarehouse::setReplenishmentWarehouse()
     * @uses ItemWarehouse::setSeasonality()
     * @uses ItemWarehouse::setServiceLevel()
     * @uses ItemWarehouse::setStatus()
     * @uses ItemWarehouse::setWarehouseID()
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @param \App\API\SOAP\StructType\StringValue $defaultIssueFrom
     * @param \App\API\SOAP\StructType\StringValue $defaultReceiptTo
     * @param \App\API\SOAP\StructType\StringValue $defaultSubitem
     * @param \App\API\SOAP\StructType\StringValue $inventoryAccount
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\StringValue $inventorySubaccount
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @param \App\API\SOAP\StructType\DecimalValue $mSRP
     * @param \App\API\SOAP\StructType\BooleanValue $overrideInventoryAccountSubaccount
     * @param \App\API\SOAP\StructType\BooleanValue $overridePreferredVendor
     * @param \App\API\SOAP\StructType\BooleanValue $overridePrice
     * @param \App\API\SOAP\StructType\BooleanValue $overrideReplenishmentSettings
     * @param \App\API\SOAP\StructType\BooleanValue $overrideServiceLevelOverride
     * @param \App\API\SOAP\StructType\BooleanValue $overrideStandardCost
     * @param \App\API\SOAP\StructType\StringValue $preferredLocation
     * @param \App\API\SOAP\StructType\StringValue $preferredVendor
     * @param \App\API\SOAP\StructType\StringValue $productManager
     * @param \App\API\SOAP\StructType\StringValue $productWorkgroup
     * @param \App\API\SOAP\StructType\StringValue $replenishmentClass
     * @param \App\API\SOAP\StructType\StringValue $replenishmentMethod
     * @param \App\API\SOAP\StructType\StringValue $replenishmentSource
     * @param \App\API\SOAP\StructType\StringValue $replenishmentWarehouse
     * @param \App\API\SOAP\StructType\StringValue $seasonality
     * @param \App\API\SOAP\StructType\DecimalValue $serviceLevel
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     */
    public function __construct(\App\API\SOAP\StructType\DateTimeValue $createdDateTime = null, \App\API\SOAP\StructType\StringValue $defaultIssueFrom = null, \App\API\SOAP\StructType\StringValue $defaultReceiptTo = null, \App\API\SOAP\StructType\StringValue $defaultSubitem = null, \App\API\SOAP\StructType\StringValue $inventoryAccount = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\StringValue $inventorySubaccount = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null, \App\API\SOAP\StructType\DecimalValue $mSRP = null, \App\API\SOAP\StructType\BooleanValue $overrideInventoryAccountSubaccount = null, \App\API\SOAP\StructType\BooleanValue $overridePreferredVendor = null, \App\API\SOAP\StructType\BooleanValue $overridePrice = null, \App\API\SOAP\StructType\BooleanValue $overrideReplenishmentSettings = null, \App\API\SOAP\StructType\BooleanValue $overrideServiceLevelOverride = null, \App\API\SOAP\StructType\BooleanValue $overrideStandardCost = null, \App\API\SOAP\StructType\StringValue $preferredLocation = null, \App\API\SOAP\StructType\StringValue $preferredVendor = null, \App\API\SOAP\StructType\StringValue $productManager = null, \App\API\SOAP\StructType\StringValue $productWorkgroup = null, \App\API\SOAP\StructType\StringValue $replenishmentClass = null, \App\API\SOAP\StructType\StringValue $replenishmentMethod = null, \App\API\SOAP\StructType\StringValue $replenishmentSource = null, \App\API\SOAP\StructType\StringValue $replenishmentWarehouse = null, \App\API\SOAP\StructType\StringValue $seasonality = null, \App\API\SOAP\StructType\DecimalValue $serviceLevel = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        $this
            ->setCreatedDateTime($createdDateTime)
            ->setDefaultIssueFrom($defaultIssueFrom)
            ->setDefaultReceiptTo($defaultReceiptTo)
            ->setDefaultSubitem($defaultSubitem)
            ->setInventoryAccount($inventoryAccount)
            ->setInventoryID($inventoryID)
            ->setInventorySubaccount($inventorySubaccount)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setMSRP($mSRP)
            ->setOverrideInventoryAccountSubaccount($overrideInventoryAccountSubaccount)
            ->setOverridePreferredVendor($overridePreferredVendor)
            ->setOverridePrice($overridePrice)
            ->setOverrideReplenishmentSettings($overrideReplenishmentSettings)
            ->setOverrideServiceLevelOverride($overrideServiceLevelOverride)
            ->setOverrideStandardCost($overrideStandardCost)
            ->setPreferredLocation($preferredLocation)
            ->setPreferredVendor($preferredVendor)
            ->setProductManager($productManager)
            ->setProductWorkgroup($productWorkgroup)
            ->setReplenishmentClass($replenishmentClass)
            ->setReplenishmentMethod($replenishmentMethod)
            ->setReplenishmentSource($replenishmentSource)
            ->setReplenishmentWarehouse($replenishmentWarehouse)
            ->setSeasonality($seasonality)
            ->setServiceLevel($serviceLevel)
            ->setStatus($status)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setCreatedDateTime(\App\API\SOAP\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get DefaultIssueFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultIssueFrom()
    {
        return isset($this->DefaultIssueFrom) ? $this->DefaultIssueFrom : null;
    }
    /**
     * Set DefaultIssueFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultIssueFrom
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setDefaultIssueFrom(\App\API\SOAP\StructType\StringValue $defaultIssueFrom = null)
    {
        if (is_null($defaultIssueFrom) || (is_array($defaultIssueFrom) && empty($defaultIssueFrom))) {
            unset($this->DefaultIssueFrom);
        } else {
            $this->DefaultIssueFrom = $defaultIssueFrom;
        }
        return $this;
    }
    /**
     * Get DefaultReceiptTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultReceiptTo()
    {
        return isset($this->DefaultReceiptTo) ? $this->DefaultReceiptTo : null;
    }
    /**
     * Set DefaultReceiptTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultReceiptTo
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setDefaultReceiptTo(\App\API\SOAP\StructType\StringValue $defaultReceiptTo = null)
    {
        if (is_null($defaultReceiptTo) || (is_array($defaultReceiptTo) && empty($defaultReceiptTo))) {
            unset($this->DefaultReceiptTo);
        } else {
            $this->DefaultReceiptTo = $defaultReceiptTo;
        }
        return $this;
    }
    /**
     * Get DefaultSubitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDefaultSubitem()
    {
        return isset($this->DefaultSubitem) ? $this->DefaultSubitem : null;
    }
    /**
     * Set DefaultSubitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $defaultSubitem
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setDefaultSubitem(\App\API\SOAP\StructType\StringValue $defaultSubitem = null)
    {
        if (is_null($defaultSubitem) || (is_array($defaultSubitem) && empty($defaultSubitem))) {
            unset($this->DefaultSubitem);
        } else {
            $this->DefaultSubitem = $defaultSubitem;
        }
        return $this;
    }
    /**
     * Get InventoryAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryAccount()
    {
        return isset($this->InventoryAccount) ? $this->InventoryAccount : null;
    }
    /**
     * Set InventoryAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryAccount
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setInventoryAccount(\App\API\SOAP\StructType\StringValue $inventoryAccount = null)
    {
        if (is_null($inventoryAccount) || (is_array($inventoryAccount) && empty($inventoryAccount))) {
            unset($this->InventoryAccount);
        } else {
            $this->InventoryAccount = $inventoryAccount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get InventorySubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventorySubaccount()
    {
        return isset($this->InventorySubaccount) ? $this->InventorySubaccount : null;
    }
    /**
     * Set InventorySubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventorySubaccount
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setInventorySubaccount(\App\API\SOAP\StructType\StringValue $inventorySubaccount = null)
    {
        if (is_null($inventorySubaccount) || (is_array($inventorySubaccount) && empty($inventorySubaccount))) {
            unset($this->InventorySubaccount);
        } else {
            $this->InventorySubaccount = $inventorySubaccount;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get MSRP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getMSRP()
    {
        return isset($this->MSRP) ? $this->MSRP : null;
    }
    /**
     * Set MSRP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $mSRP
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setMSRP(\App\API\SOAP\StructType\DecimalValue $mSRP = null)
    {
        if (is_null($mSRP) || (is_array($mSRP) && empty($mSRP))) {
            unset($this->MSRP);
        } else {
            $this->MSRP = $mSRP;
        }
        return $this;
    }
    /**
     * Get OverrideInventoryAccountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getOverrideInventoryAccountSubaccount()
    {
        return isset($this->OverrideInventoryAccountSubaccount) ? $this->OverrideInventoryAccountSubaccount : null;
    }
    /**
     * Set OverrideInventoryAccountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $overrideInventoryAccountSubaccount
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setOverrideInventoryAccountSubaccount(\App\API\SOAP\StructType\BooleanValue $overrideInventoryAccountSubaccount = null)
    {
        if (is_null($overrideInventoryAccountSubaccount) || (is_array($overrideInventoryAccountSubaccount) && empty($overrideInventoryAccountSubaccount))) {
            unset($this->OverrideInventoryAccountSubaccount);
        } else {
            $this->OverrideInventoryAccountSubaccount = $overrideInventoryAccountSubaccount;
        }
        return $this;
    }
    /**
     * Get OverridePreferredVendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getOverridePreferredVendor()
    {
        return isset($this->OverridePreferredVendor) ? $this->OverridePreferredVendor : null;
    }
    /**
     * Set OverridePreferredVendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $overridePreferredVendor
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setOverridePreferredVendor(\App\API\SOAP\StructType\BooleanValue $overridePreferredVendor = null)
    {
        if (is_null($overridePreferredVendor) || (is_array($overridePreferredVendor) && empty($overridePreferredVendor))) {
            unset($this->OverridePreferredVendor);
        } else {
            $this->OverridePreferredVendor = $overridePreferredVendor;
        }
        return $this;
    }
    /**
     * Get OverridePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getOverridePrice()
    {
        return isset($this->OverridePrice) ? $this->OverridePrice : null;
    }
    /**
     * Set OverridePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $overridePrice
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setOverridePrice(\App\API\SOAP\StructType\BooleanValue $overridePrice = null)
    {
        if (is_null($overridePrice) || (is_array($overridePrice) && empty($overridePrice))) {
            unset($this->OverridePrice);
        } else {
            $this->OverridePrice = $overridePrice;
        }
        return $this;
    }
    /**
     * Get OverrideReplenishmentSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getOverrideReplenishmentSettings()
    {
        return isset($this->OverrideReplenishmentSettings) ? $this->OverrideReplenishmentSettings : null;
    }
    /**
     * Set OverrideReplenishmentSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $overrideReplenishmentSettings
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setOverrideReplenishmentSettings(\App\API\SOAP\StructType\BooleanValue $overrideReplenishmentSettings = null)
    {
        if (is_null($overrideReplenishmentSettings) || (is_array($overrideReplenishmentSettings) && empty($overrideReplenishmentSettings))) {
            unset($this->OverrideReplenishmentSettings);
        } else {
            $this->OverrideReplenishmentSettings = $overrideReplenishmentSettings;
        }
        return $this;
    }
    /**
     * Get OverrideServiceLevelOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getOverrideServiceLevelOverride()
    {
        return isset($this->OverrideServiceLevelOverride) ? $this->OverrideServiceLevelOverride : null;
    }
    /**
     * Set OverrideServiceLevelOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $overrideServiceLevelOverride
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setOverrideServiceLevelOverride(\App\API\SOAP\StructType\BooleanValue $overrideServiceLevelOverride = null)
    {
        if (is_null($overrideServiceLevelOverride) || (is_array($overrideServiceLevelOverride) && empty($overrideServiceLevelOverride))) {
            unset($this->OverrideServiceLevelOverride);
        } else {
            $this->OverrideServiceLevelOverride = $overrideServiceLevelOverride;
        }
        return $this;
    }
    /**
     * Get OverrideStandardCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getOverrideStandardCost()
    {
        return isset($this->OverrideStandardCost) ? $this->OverrideStandardCost : null;
    }
    /**
     * Set OverrideStandardCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $overrideStandardCost
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setOverrideStandardCost(\App\API\SOAP\StructType\BooleanValue $overrideStandardCost = null)
    {
        if (is_null($overrideStandardCost) || (is_array($overrideStandardCost) && empty($overrideStandardCost))) {
            unset($this->OverrideStandardCost);
        } else {
            $this->OverrideStandardCost = $overrideStandardCost;
        }
        return $this;
    }
    /**
     * Get PreferredLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPreferredLocation()
    {
        return isset($this->PreferredLocation) ? $this->PreferredLocation : null;
    }
    /**
     * Set PreferredLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $preferredLocation
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setPreferredLocation(\App\API\SOAP\StructType\StringValue $preferredLocation = null)
    {
        if (is_null($preferredLocation) || (is_array($preferredLocation) && empty($preferredLocation))) {
            unset($this->PreferredLocation);
        } else {
            $this->PreferredLocation = $preferredLocation;
        }
        return $this;
    }
    /**
     * Get PreferredVendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPreferredVendor()
    {
        return isset($this->PreferredVendor) ? $this->PreferredVendor : null;
    }
    /**
     * Set PreferredVendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $preferredVendor
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setPreferredVendor(\App\API\SOAP\StructType\StringValue $preferredVendor = null)
    {
        if (is_null($preferredVendor) || (is_array($preferredVendor) && empty($preferredVendor))) {
            unset($this->PreferredVendor);
        } else {
            $this->PreferredVendor = $preferredVendor;
        }
        return $this;
    }
    /**
     * Get ProductManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProductManager()
    {
        return isset($this->ProductManager) ? $this->ProductManager : null;
    }
    /**
     * Set ProductManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $productManager
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setProductManager(\App\API\SOAP\StructType\StringValue $productManager = null)
    {
        if (is_null($productManager) || (is_array($productManager) && empty($productManager))) {
            unset($this->ProductManager);
        } else {
            $this->ProductManager = $productManager;
        }
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProductWorkgroup()
    {
        return isset($this->ProductWorkgroup) ? $this->ProductWorkgroup : null;
    }
    /**
     * Set ProductWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $productWorkgroup
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setProductWorkgroup(\App\API\SOAP\StructType\StringValue $productWorkgroup = null)
    {
        if (is_null($productWorkgroup) || (is_array($productWorkgroup) && empty($productWorkgroup))) {
            unset($this->ProductWorkgroup);
        } else {
            $this->ProductWorkgroup = $productWorkgroup;
        }
        return $this;
    }
    /**
     * Get ReplenishmentClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReplenishmentClass()
    {
        return isset($this->ReplenishmentClass) ? $this->ReplenishmentClass : null;
    }
    /**
     * Set ReplenishmentClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $replenishmentClass
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setReplenishmentClass(\App\API\SOAP\StructType\StringValue $replenishmentClass = null)
    {
        if (is_null($replenishmentClass) || (is_array($replenishmentClass) && empty($replenishmentClass))) {
            unset($this->ReplenishmentClass);
        } else {
            $this->ReplenishmentClass = $replenishmentClass;
        }
        return $this;
    }
    /**
     * Get ReplenishmentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReplenishmentMethod()
    {
        return isset($this->ReplenishmentMethod) ? $this->ReplenishmentMethod : null;
    }
    /**
     * Set ReplenishmentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $replenishmentMethod
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setReplenishmentMethod(\App\API\SOAP\StructType\StringValue $replenishmentMethod = null)
    {
        if (is_null($replenishmentMethod) || (is_array($replenishmentMethod) && empty($replenishmentMethod))) {
            unset($this->ReplenishmentMethod);
        } else {
            $this->ReplenishmentMethod = $replenishmentMethod;
        }
        return $this;
    }
    /**
     * Get ReplenishmentSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReplenishmentSource()
    {
        return isset($this->ReplenishmentSource) ? $this->ReplenishmentSource : null;
    }
    /**
     * Set ReplenishmentSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $replenishmentSource
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setReplenishmentSource(\App\API\SOAP\StructType\StringValue $replenishmentSource = null)
    {
        if (is_null($replenishmentSource) || (is_array($replenishmentSource) && empty($replenishmentSource))) {
            unset($this->ReplenishmentSource);
        } else {
            $this->ReplenishmentSource = $replenishmentSource;
        }
        return $this;
    }
    /**
     * Get ReplenishmentWarehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReplenishmentWarehouse()
    {
        return isset($this->ReplenishmentWarehouse) ? $this->ReplenishmentWarehouse : null;
    }
    /**
     * Set ReplenishmentWarehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $replenishmentWarehouse
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setReplenishmentWarehouse(\App\API\SOAP\StructType\StringValue $replenishmentWarehouse = null)
    {
        if (is_null($replenishmentWarehouse) || (is_array($replenishmentWarehouse) && empty($replenishmentWarehouse))) {
            unset($this->ReplenishmentWarehouse);
        } else {
            $this->ReplenishmentWarehouse = $replenishmentWarehouse;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $seasonality
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setSeasonality(\App\API\SOAP\StructType\StringValue $seasonality = null)
    {
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get ServiceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getServiceLevel()
    {
        return isset($this->ServiceLevel) ? $this->ServiceLevel : null;
    }
    /**
     * Set ServiceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $serviceLevel
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setServiceLevel(\App\API\SOAP\StructType\DecimalValue $serviceLevel = null)
    {
        if (is_null($serviceLevel) || (is_array($serviceLevel) && empty($serviceLevel))) {
            unset($this->ServiceLevel);
        } else {
            $this->ServiceLevel = $serviceLevel;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     * @return \App\API\SOAP\StructType\ItemWarehouse
     */
    public function setWarehouseID(\App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
