<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSalesCategoryMember StructType
 * @subpackage Structs
 */
class ItemSalesCategoryMember extends Entity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ItemClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ItemStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ItemStatus;
    /**
     * Constructor method for ItemSalesCategoryMember
     * @uses ItemSalesCategoryMember::setDescription()
     * @uses ItemSalesCategoryMember::setInventoryID()
     * @uses ItemSalesCategoryMember::setItemClass()
     * @uses ItemSalesCategoryMember::setItemStatus()
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\StringValue $itemClass
     * @param \App\API\SOAP\StructType\StringValue $itemStatus
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\StringValue $itemClass = null, \App\API\SOAP\StructType\StringValue $itemStatus = null)
    {
        $this
            ->setDescription($description)
            ->setInventoryID($inventoryID)
            ->setItemClass($itemClass)
            ->setItemStatus($itemStatus);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ItemSalesCategoryMember
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\ItemSalesCategoryMember
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $itemClass
     * @return \App\API\SOAP\StructType\ItemSalesCategoryMember
     */
    public function setItemClass(\App\API\SOAP\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ItemStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getItemStatus()
    {
        return isset($this->ItemStatus) ? $this->ItemStatus : null;
    }
    /**
     * Set ItemStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $itemStatus
     * @return \App\API\SOAP\StructType\ItemSalesCategoryMember
     */
    public function setItemStatus(\App\API\SOAP\StructType\StringValue $itemStatus = null)
    {
        if (is_null($itemStatus) || (is_array($itemStatus) && empty($itemStatus))) {
            unset($this->ItemStatus);
        } else {
            $this->ItemStatus = $itemStatus;
        }
        return $this;
    }
}
