<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPriceClasses StructType
 * @subpackage Structs
 */
class ItemPriceClasses extends AbstractStructBase
{
    /**
     * The DiscountItemPriceClassesDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DiscountItemPriceClassesDetail[]
     */
    public $DiscountItemPriceClassesDetail;
    /**
     * Constructor method for ItemPriceClasses
     * @uses ItemPriceClasses::setDiscountItemPriceClassesDetail()
     * @param \App\API\SOAP\StructType\DiscountItemPriceClassesDetail[] $discountItemPriceClassesDetail
     */
    public function __construct(array $discountItemPriceClassesDetail = array())
    {
        $this
            ->setDiscountItemPriceClassesDetail($discountItemPriceClassesDetail);
    }
    /**
     * Get DiscountItemPriceClassesDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DiscountItemPriceClassesDetail[]|null
     */
    public function getDiscountItemPriceClassesDetail()
    {
        return isset($this->DiscountItemPriceClassesDetail) ? $this->DiscountItemPriceClassesDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountItemPriceClassesDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountItemPriceClassesDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountItemPriceClassesDetailForArrayConstraintsFromSetDiscountItemPriceClassesDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPriceClassesDiscountItemPriceClassesDetailItem) {
            // validation for constraint: itemType
            if (!$itemPriceClassesDiscountItemPriceClassesDetailItem instanceof \App\API\SOAP\StructType\DiscountItemPriceClassesDetail) {
                $invalidValues[] = is_object($itemPriceClassesDiscountItemPriceClassesDetailItem) ? get_class($itemPriceClassesDiscountItemPriceClassesDetailItem) : sprintf('%s(%s)', gettype($itemPriceClassesDiscountItemPriceClassesDetailItem), var_export($itemPriceClassesDiscountItemPriceClassesDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountItemPriceClassesDetail property can only contain items of type \App\API\SOAP\StructType\DiscountItemPriceClassesDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountItemPriceClassesDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\DiscountItemPriceClassesDetail[] $discountItemPriceClassesDetail
     * @return \App\API\SOAP\StructType\ItemPriceClasses
     */
    public function setDiscountItemPriceClassesDetail(array $discountItemPriceClassesDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($discountItemPriceClassesDetailArrayErrorMessage = self::validateDiscountItemPriceClassesDetailForArrayConstraintsFromSetDiscountItemPriceClassesDetail($discountItemPriceClassesDetail))) {
            throw new \InvalidArgumentException($discountItemPriceClassesDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($discountItemPriceClassesDetail) || (is_array($discountItemPriceClassesDetail) && empty($discountItemPriceClassesDetail))) {
            unset($this->DiscountItemPriceClassesDetail);
        } else {
            $this->DiscountItemPriceClassesDetail = $discountItemPriceClassesDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountItemPriceClassesDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\DiscountItemPriceClassesDetail $item
     * @return \App\API\SOAP\StructType\ItemPriceClasses
     */
    public function addToDiscountItemPriceClassesDetail(\App\API\SOAP\StructType\DiscountItemPriceClassesDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\DiscountItemPriceClassesDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountItemPriceClassesDetail property can only contain items of type \App\API\SOAP\StructType\DiscountItemPriceClassesDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountItemPriceClassesDetail[] = $item;
        return $this;
    }
}
