<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoke StructType
 * @subpackage Structs
 */
class Invoke extends AbstractStructBase
{
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\API\SOAP\StructType\Entity
     */
    public $entity;
    /**
     * The action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\API\SOAP\StructType\Action
     */
    public $action;
    /**
     * Constructor method for Invoke
     * @uses Invoke::setEntity()
     * @uses Invoke::setAction()
     * @param \App\API\SOAP\StructType\Entity $entity
     * @param \App\API\SOAP\StructType\Action $action
     */
    public function __construct(\App\API\SOAP\StructType\Entity $entity = null, \App\API\SOAP\StructType\Action $action = null)
    {
        $this
            ->setEntity($entity)
            ->setAction($action);
    }
    /**
     * Get entity value
     * @return \App\API\SOAP\StructType\Entity|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \App\API\SOAP\StructType\Entity $entity
     * @return \App\API\SOAP\StructType\Invoke
     */
    public function setEntity(\App\API\SOAP\StructType\Entity $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get action value
     * @return \App\API\SOAP\StructType\Action|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param \App\API\SOAP\StructType\Action $action
     * @return \App\API\SOAP\StructType\Invoke
     */
    public function setAction(\App\API\SOAP\StructType\Action $action = null)
    {
        $this->action = $action;
        return $this;
    }
}
