<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends Entity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The ApplicationsCreditMemo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ApplicationsCreditMemo
     */
    public $ApplicationsCreditMemo;
    /**
     * The ApplicationsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ApplicationsDefault
     */
    public $ApplicationsDefault;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Balance;
    /**
     * The BillingPrinted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $BillingPrinted;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Customer;
    /**
     * The CustomerOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerOrder;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Details
     */
    public $Details;
    /**
     * The DiscountDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DiscountDetails
     */
    public $DiscountDetails;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $DueDate;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LinkARAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LinkARAccount;
    /**
     * The LinkBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LinkBranch;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LocationID;
    /**
     * The PostPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PostPeriod;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Project;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TaxDetails
     */
    public $TaxDetails;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * The Terms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Terms;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setAmount()
     * @uses Invoice::setApplicationsCreditMemo()
     * @uses Invoice::setApplicationsDefault()
     * @uses Invoice::setBalance()
     * @uses Invoice::setBillingPrinted()
     * @uses Invoice::setCreatedDateTime()
     * @uses Invoice::setCustomer()
     * @uses Invoice::setCustomerOrder()
     * @uses Invoice::setDate()
     * @uses Invoice::setDescription()
     * @uses Invoice::setDetails()
     * @uses Invoice::setDiscountDetails()
     * @uses Invoice::setDueDate()
     * @uses Invoice::setHold()
     * @uses Invoice::setLastModifiedDateTime()
     * @uses Invoice::setLinkARAccount()
     * @uses Invoice::setLinkBranch()
     * @uses Invoice::setLocationID()
     * @uses Invoice::setPostPeriod()
     * @uses Invoice::setProject()
     * @uses Invoice::setReferenceNbr()
     * @uses Invoice::setStatus()
     * @uses Invoice::setTaxDetails()
     * @uses Invoice::setTaxTotal()
     * @uses Invoice::setTerms()
     * @uses Invoice::setType()
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @param \App\API\SOAP\StructType\ApplicationsCreditMemo $applicationsCreditMemo
     * @param \App\API\SOAP\StructType\ApplicationsDefault $applicationsDefault
     * @param \App\API\SOAP\StructType\DecimalValue $balance
     * @param \App\API\SOAP\StructType\BooleanValue $billingPrinted
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @param \App\API\SOAP\StructType\StringValue $customer
     * @param \App\API\SOAP\StructType\StringValue $customerOrder
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\Details $details
     * @param \App\API\SOAP\StructType\DiscountDetails $discountDetails
     * @param \App\API\SOAP\StructType\DateTimeValue $dueDate
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @param \App\API\SOAP\StructType\StringValue $linkARAccount
     * @param \App\API\SOAP\StructType\StringValue $linkBranch
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @param \App\API\SOAP\StructType\StringValue $postPeriod
     * @param \App\API\SOAP\StructType\StringValue $project
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\TaxDetails $taxDetails
     * @param \App\API\SOAP\StructType\DecimalValue $taxTotal
     * @param \App\API\SOAP\StructType\StringValue $terms
     * @param \App\API\SOAP\StructType\StringValue $type
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $amount = null, \App\API\SOAP\StructType\ApplicationsCreditMemo $applicationsCreditMemo = null, \App\API\SOAP\StructType\ApplicationsDefault $applicationsDefault = null, \App\API\SOAP\StructType\DecimalValue $balance = null, \App\API\SOAP\StructType\BooleanValue $billingPrinted = null, \App\API\SOAP\StructType\DateTimeValue $createdDateTime = null, \App\API\SOAP\StructType\StringValue $customer = null, \App\API\SOAP\StructType\StringValue $customerOrder = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\Details $details = null, \App\API\SOAP\StructType\DiscountDetails $discountDetails = null, \App\API\SOAP\StructType\DateTimeValue $dueDate = null, \App\API\SOAP\StructType\BooleanValue $hold = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null, \App\API\SOAP\StructType\StringValue $linkARAccount = null, \App\API\SOAP\StructType\StringValue $linkBranch = null, \App\API\SOAP\StructType\StringValue $locationID = null, \App\API\SOAP\StructType\StringValue $postPeriod = null, \App\API\SOAP\StructType\StringValue $project = null, \App\API\SOAP\StructType\StringValue $referenceNbr = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\TaxDetails $taxDetails = null, \App\API\SOAP\StructType\DecimalValue $taxTotal = null, \App\API\SOAP\StructType\StringValue $terms = null, \App\API\SOAP\StructType\StringValue $type = null)
    {
        $this
            ->setAmount($amount)
            ->setApplicationsCreditMemo($applicationsCreditMemo)
            ->setApplicationsDefault($applicationsDefault)
            ->setBalance($balance)
            ->setBillingPrinted($billingPrinted)
            ->setCreatedDateTime($createdDateTime)
            ->setCustomer($customer)
            ->setCustomerOrder($customerOrder)
            ->setDate($date)
            ->setDescription($description)
            ->setDetails($details)
            ->setDiscountDetails($discountDetails)
            ->setDueDate($dueDate)
            ->setHold($hold)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLinkARAccount($linkARAccount)
            ->setLinkBranch($linkBranch)
            ->setLocationID($locationID)
            ->setPostPeriod($postPeriod)
            ->setProject($project)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setTaxDetails($taxDetails)
            ->setTaxTotal($taxTotal)
            ->setTerms($terms)
            ->setType($type);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setAmount(\App\API\SOAP\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ApplicationsCreditMemo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ApplicationsCreditMemo|null
     */
    public function getApplicationsCreditMemo()
    {
        return isset($this->ApplicationsCreditMemo) ? $this->ApplicationsCreditMemo : null;
    }
    /**
     * Set ApplicationsCreditMemo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ApplicationsCreditMemo $applicationsCreditMemo
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setApplicationsCreditMemo(\App\API\SOAP\StructType\ApplicationsCreditMemo $applicationsCreditMemo = null)
    {
        if (is_null($applicationsCreditMemo) || (is_array($applicationsCreditMemo) && empty($applicationsCreditMemo))) {
            unset($this->ApplicationsCreditMemo);
        } else {
            $this->ApplicationsCreditMemo = $applicationsCreditMemo;
        }
        return $this;
    }
    /**
     * Get ApplicationsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ApplicationsDefault|null
     */
    public function getApplicationsDefault()
    {
        return isset($this->ApplicationsDefault) ? $this->ApplicationsDefault : null;
    }
    /**
     * Set ApplicationsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ApplicationsDefault $applicationsDefault
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setApplicationsDefault(\App\API\SOAP\StructType\ApplicationsDefault $applicationsDefault = null)
    {
        if (is_null($applicationsDefault) || (is_array($applicationsDefault) && empty($applicationsDefault))) {
            unset($this->ApplicationsDefault);
        } else {
            $this->ApplicationsDefault = $applicationsDefault;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $balance
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setBalance(\App\API\SOAP\StructType\DecimalValue $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get BillingPrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillingPrinted()
    {
        return isset($this->BillingPrinted) ? $this->BillingPrinted : null;
    }
    /**
     * Set BillingPrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billingPrinted
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setBillingPrinted(\App\API\SOAP\StructType\BooleanValue $billingPrinted = null)
    {
        if (is_null($billingPrinted) || (is_array($billingPrinted) && empty($billingPrinted))) {
            unset($this->BillingPrinted);
        } else {
            $this->BillingPrinted = $billingPrinted;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setCreatedDateTime(\App\API\SOAP\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customer
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setCustomer(\App\API\SOAP\StructType\StringValue $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerOrder
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setCustomerOrder(\App\API\SOAP\StructType\StringValue $customerOrder = null)
    {
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Details $details
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setDetails(\App\API\SOAP\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get DiscountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DiscountDetails|null
     */
    public function getDiscountDetails()
    {
        return isset($this->DiscountDetails) ? $this->DiscountDetails : null;
    }
    /**
     * Set DiscountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DiscountDetails $discountDetails
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setDiscountDetails(\App\API\SOAP\StructType\DiscountDetails $discountDetails = null)
    {
        if (is_null($discountDetails) || (is_array($discountDetails) && empty($discountDetails))) {
            unset($this->DiscountDetails);
        } else {
            $this->DiscountDetails = $discountDetails;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $dueDate
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setDueDate(\App\API\SOAP\StructType\DateTimeValue $dueDate = null)
    {
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setHold(\App\API\SOAP\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LinkARAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLinkARAccount()
    {
        return isset($this->LinkARAccount) ? $this->LinkARAccount : null;
    }
    /**
     * Set LinkARAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $linkARAccount
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setLinkARAccount(\App\API\SOAP\StructType\StringValue $linkARAccount = null)
    {
        if (is_null($linkARAccount) || (is_array($linkARAccount) && empty($linkARAccount))) {
            unset($this->LinkARAccount);
        } else {
            $this->LinkARAccount = $linkARAccount;
        }
        return $this;
    }
    /**
     * Get LinkBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLinkBranch()
    {
        return isset($this->LinkBranch) ? $this->LinkBranch : null;
    }
    /**
     * Set LinkBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $linkBranch
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setLinkBranch(\App\API\SOAP\StructType\StringValue $linkBranch = null)
    {
        if (is_null($linkBranch) || (is_array($linkBranch) && empty($linkBranch))) {
            unset($this->LinkBranch);
        } else {
            $this->LinkBranch = $linkBranch;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setLocationID(\App\API\SOAP\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get PostPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPostPeriod()
    {
        return isset($this->PostPeriod) ? $this->PostPeriod : null;
    }
    /**
     * Set PostPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $postPeriod
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setPostPeriod(\App\API\SOAP\StructType\StringValue $postPeriod = null)
    {
        if (is_null($postPeriod) || (is_array($postPeriod) && empty($postPeriod))) {
            unset($this->PostPeriod);
        } else {
            $this->PostPeriod = $postPeriod;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $project
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setProject(\App\API\SOAP\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setReferenceNbr(\App\API\SOAP\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TaxDetails|null
     */
    public function getTaxDetails()
    {
        return isset($this->TaxDetails) ? $this->TaxDetails : null;
    }
    /**
     * Set TaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\TaxDetails $taxDetails
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setTaxDetails(\App\API\SOAP\StructType\TaxDetails $taxDetails = null)
    {
        if (is_null($taxDetails) || (is_array($taxDetails) && empty($taxDetails))) {
            unset($this->TaxDetails);
        } else {
            $this->TaxDetails = $taxDetails;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxTotal
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setTaxTotal(\App\API\SOAP\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get Terms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTerms()
    {
        return isset($this->Terms) ? $this->Terms : null;
    }
    /**
     * Set Terms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $terms
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setTerms(\App\API\SOAP\StructType\StringValue $terms = null)
    {
        if (is_null($terms) || (is_array($terms) && empty($terms))) {
            unset($this->Terms);
        } else {
            $this->Terms = $terms;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\Invoice
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
