<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItemUOMConversion StructType
 * @subpackage Structs
 */
class InventoryItemUOMConversion extends Entity
{
    /**
     * The ConversionFactor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ConversionFactor;
    /**
     * The FromUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FromUOM;
    /**
     * The MultiplyOrDivide
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $MultiplyOrDivide;
    /**
     * The ToUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ToUOM;
    /**
     * Constructor method for InventoryItemUOMConversion
     * @uses InventoryItemUOMConversion::setConversionFactor()
     * @uses InventoryItemUOMConversion::setFromUOM()
     * @uses InventoryItemUOMConversion::setMultiplyOrDivide()
     * @uses InventoryItemUOMConversion::setToUOM()
     * @param \App\API\SOAP\StructType\DecimalValue $conversionFactor
     * @param \App\API\SOAP\StructType\StringValue $fromUOM
     * @param \App\API\SOAP\StructType\StringValue $multiplyOrDivide
     * @param \App\API\SOAP\StructType\StringValue $toUOM
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $conversionFactor = null, \App\API\SOAP\StructType\StringValue $fromUOM = null, \App\API\SOAP\StructType\StringValue $multiplyOrDivide = null, \App\API\SOAP\StructType\StringValue $toUOM = null)
    {
        $this
            ->setConversionFactor($conversionFactor)
            ->setFromUOM($fromUOM)
            ->setMultiplyOrDivide($multiplyOrDivide)
            ->setToUOM($toUOM);
    }
    /**
     * Get ConversionFactor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getConversionFactor()
    {
        return isset($this->ConversionFactor) ? $this->ConversionFactor : null;
    }
    /**
     * Set ConversionFactor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $conversionFactor
     * @return \App\API\SOAP\StructType\InventoryItemUOMConversion
     */
    public function setConversionFactor(\App\API\SOAP\StructType\DecimalValue $conversionFactor = null)
    {
        if (is_null($conversionFactor) || (is_array($conversionFactor) && empty($conversionFactor))) {
            unset($this->ConversionFactor);
        } else {
            $this->ConversionFactor = $conversionFactor;
        }
        return $this;
    }
    /**
     * Get FromUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFromUOM()
    {
        return isset($this->FromUOM) ? $this->FromUOM : null;
    }
    /**
     * Set FromUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $fromUOM
     * @return \App\API\SOAP\StructType\InventoryItemUOMConversion
     */
    public function setFromUOM(\App\API\SOAP\StructType\StringValue $fromUOM = null)
    {
        if (is_null($fromUOM) || (is_array($fromUOM) && empty($fromUOM))) {
            unset($this->FromUOM);
        } else {
            $this->FromUOM = $fromUOM;
        }
        return $this;
    }
    /**
     * Get MultiplyOrDivide value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getMultiplyOrDivide()
    {
        return isset($this->MultiplyOrDivide) ? $this->MultiplyOrDivide : null;
    }
    /**
     * Set MultiplyOrDivide value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $multiplyOrDivide
     * @return \App\API\SOAP\StructType\InventoryItemUOMConversion
     */
    public function setMultiplyOrDivide(\App\API\SOAP\StructType\StringValue $multiplyOrDivide = null)
    {
        if (is_null($multiplyOrDivide) || (is_array($multiplyOrDivide) && empty($multiplyOrDivide))) {
            unset($this->MultiplyOrDivide);
        } else {
            $this->MultiplyOrDivide = $multiplyOrDivide;
        }
        return $this;
    }
    /**
     * Get ToUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getToUOM()
    {
        return isset($this->ToUOM) ? $this->ToUOM : null;
    }
    /**
     * Set ToUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $toUOM
     * @return \App\API\SOAP\StructType\InventoryItemUOMConversion
     */
    public function setToUOM(\App\API\SOAP\StructType\StringValue $toUOM = null)
    {
        if (is_null($toUOM) || (is_array($toUOM) && empty($toUOM))) {
            unset($this->ToUOM);
        } else {
            $this->ToUOM = $toUOM;
        }
        return $this;
    }
}
