<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryAllocationInquiry StructType
 * @subpackage Structs
 */
class InventoryAllocationInquiry extends Entity
{
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Available;
    /**
     * The AvailableForIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AvailableForIssue;
    /**
     * The AvailableForShipping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AvailableForShipping;
    /**
     * The BaseUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BaseUnit;
    /**
     * The InTransit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $InTransit;
    /**
     * The InTransitToSO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $InTransitToSO;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The InventoryIssues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $InventoryIssues;
    /**
     * The InventoryReceipts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $InventoryReceipts;
    /**
     * The KitAssemblyDemand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $KitAssemblyDemand;
    /**
     * The KitAssemblySupply
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $KitAssemblySupply;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Location;
    /**
     * The OnHand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OnHand;
    /**
     * The OnLocationNotAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $OnLocationNotAvailable;
    /**
     * The PurchaseForSO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PurchaseForSO;
    /**
     * The PurchaseForSOPrepared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PurchaseForSOPrepared;
    /**
     * The PurchaseOrders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PurchaseOrders;
    /**
     * The PurchasePrepared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PurchasePrepared;
    /**
     * The PurchaseReceipts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PurchaseReceipts;
    /**
     * The ReceiptsForSO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ReceiptsForSO;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Results
     */
    public $Results;
    /**
     * The SOAllocated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $SOAllocated;
    /**
     * The SOBackOrdered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $SOBackOrdered;
    /**
     * The SOBooked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $SOBooked;
    /**
     * The SOPrepared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $SOPrepared;
    /**
     * The SOShipped
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $SOShipped;
    /**
     * The SOToPurchase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $SOToPurchase;
    /**
     * The TotalAddition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TotalAddition;
    /**
     * The TotalDeduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TotalDeduction;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for InventoryAllocationInquiry
     * @uses InventoryAllocationInquiry::setAvailable()
     * @uses InventoryAllocationInquiry::setAvailableForIssue()
     * @uses InventoryAllocationInquiry::setAvailableForShipping()
     * @uses InventoryAllocationInquiry::setBaseUnit()
     * @uses InventoryAllocationInquiry::setInTransit()
     * @uses InventoryAllocationInquiry::setInTransitToSO()
     * @uses InventoryAllocationInquiry::setInventoryID()
     * @uses InventoryAllocationInquiry::setInventoryIssues()
     * @uses InventoryAllocationInquiry::setInventoryReceipts()
     * @uses InventoryAllocationInquiry::setKitAssemblyDemand()
     * @uses InventoryAllocationInquiry::setKitAssemblySupply()
     * @uses InventoryAllocationInquiry::setLocation()
     * @uses InventoryAllocationInquiry::setOnHand()
     * @uses InventoryAllocationInquiry::setOnLocationNotAvailable()
     * @uses InventoryAllocationInquiry::setPurchaseForSO()
     * @uses InventoryAllocationInquiry::setPurchaseForSOPrepared()
     * @uses InventoryAllocationInquiry::setPurchaseOrders()
     * @uses InventoryAllocationInquiry::setPurchasePrepared()
     * @uses InventoryAllocationInquiry::setPurchaseReceipts()
     * @uses InventoryAllocationInquiry::setReceiptsForSO()
     * @uses InventoryAllocationInquiry::setResults()
     * @uses InventoryAllocationInquiry::setSOAllocated()
     * @uses InventoryAllocationInquiry::setSOBackOrdered()
     * @uses InventoryAllocationInquiry::setSOBooked()
     * @uses InventoryAllocationInquiry::setSOPrepared()
     * @uses InventoryAllocationInquiry::setSOShipped()
     * @uses InventoryAllocationInquiry::setSOToPurchase()
     * @uses InventoryAllocationInquiry::setTotalAddition()
     * @uses InventoryAllocationInquiry::setTotalDeduction()
     * @uses InventoryAllocationInquiry::setWarehouseID()
     * @param \App\API\SOAP\StructType\DecimalValue $available
     * @param \App\API\SOAP\StructType\DecimalValue $availableForIssue
     * @param \App\API\SOAP\StructType\DecimalValue $availableForShipping
     * @param \App\API\SOAP\StructType\StringValue $baseUnit
     * @param \App\API\SOAP\StructType\DecimalValue $inTransit
     * @param \App\API\SOAP\StructType\DecimalValue $inTransitToSO
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\DecimalValue $inventoryIssues
     * @param \App\API\SOAP\StructType\DecimalValue $inventoryReceipts
     * @param \App\API\SOAP\StructType\DecimalValue $kitAssemblyDemand
     * @param \App\API\SOAP\StructType\DecimalValue $kitAssemblySupply
     * @param \App\API\SOAP\StructType\StringValue $location
     * @param \App\API\SOAP\StructType\DecimalValue $onHand
     * @param \App\API\SOAP\StructType\DecimalValue $onLocationNotAvailable
     * @param \App\API\SOAP\StructType\DecimalValue $purchaseForSO
     * @param \App\API\SOAP\StructType\DecimalValue $purchaseForSOPrepared
     * @param \App\API\SOAP\StructType\DecimalValue $purchaseOrders
     * @param \App\API\SOAP\StructType\DecimalValue $purchasePrepared
     * @param \App\API\SOAP\StructType\DecimalValue $purchaseReceipts
     * @param \App\API\SOAP\StructType\DecimalValue $receiptsForSO
     * @param \App\API\SOAP\StructType\Results $results
     * @param \App\API\SOAP\StructType\DecimalValue $sOAllocated
     * @param \App\API\SOAP\StructType\DecimalValue $sOBackOrdered
     * @param \App\API\SOAP\StructType\DecimalValue $sOBooked
     * @param \App\API\SOAP\StructType\DecimalValue $sOPrepared
     * @param \App\API\SOAP\StructType\DecimalValue $sOShipped
     * @param \App\API\SOAP\StructType\DecimalValue $sOToPurchase
     * @param \App\API\SOAP\StructType\DecimalValue $totalAddition
     * @param \App\API\SOAP\StructType\DecimalValue $totalDeduction
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $available = null, \App\API\SOAP\StructType\DecimalValue $availableForIssue = null, \App\API\SOAP\StructType\DecimalValue $availableForShipping = null, \App\API\SOAP\StructType\StringValue $baseUnit = null, \App\API\SOAP\StructType\DecimalValue $inTransit = null, \App\API\SOAP\StructType\DecimalValue $inTransitToSO = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\DecimalValue $inventoryIssues = null, \App\API\SOAP\StructType\DecimalValue $inventoryReceipts = null, \App\API\SOAP\StructType\DecimalValue $kitAssemblyDemand = null, \App\API\SOAP\StructType\DecimalValue $kitAssemblySupply = null, \App\API\SOAP\StructType\StringValue $location = null, \App\API\SOAP\StructType\DecimalValue $onHand = null, \App\API\SOAP\StructType\DecimalValue $onLocationNotAvailable = null, \App\API\SOAP\StructType\DecimalValue $purchaseForSO = null, \App\API\SOAP\StructType\DecimalValue $purchaseForSOPrepared = null, \App\API\SOAP\StructType\DecimalValue $purchaseOrders = null, \App\API\SOAP\StructType\DecimalValue $purchasePrepared = null, \App\API\SOAP\StructType\DecimalValue $purchaseReceipts = null, \App\API\SOAP\StructType\DecimalValue $receiptsForSO = null, \App\API\SOAP\StructType\Results $results = null, \App\API\SOAP\StructType\DecimalValue $sOAllocated = null, \App\API\SOAP\StructType\DecimalValue $sOBackOrdered = null, \App\API\SOAP\StructType\DecimalValue $sOBooked = null, \App\API\SOAP\StructType\DecimalValue $sOPrepared = null, \App\API\SOAP\StructType\DecimalValue $sOShipped = null, \App\API\SOAP\StructType\DecimalValue $sOToPurchase = null, \App\API\SOAP\StructType\DecimalValue $totalAddition = null, \App\API\SOAP\StructType\DecimalValue $totalDeduction = null, \App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        $this
            ->setAvailable($available)
            ->setAvailableForIssue($availableForIssue)
            ->setAvailableForShipping($availableForShipping)
            ->setBaseUnit($baseUnit)
            ->setInTransit($inTransit)
            ->setInTransitToSO($inTransitToSO)
            ->setInventoryID($inventoryID)
            ->setInventoryIssues($inventoryIssues)
            ->setInventoryReceipts($inventoryReceipts)
            ->setKitAssemblyDemand($kitAssemblyDemand)
            ->setKitAssemblySupply($kitAssemblySupply)
            ->setLocation($location)
            ->setOnHand($onHand)
            ->setOnLocationNotAvailable($onLocationNotAvailable)
            ->setPurchaseForSO($purchaseForSO)
            ->setPurchaseForSOPrepared($purchaseForSOPrepared)
            ->setPurchaseOrders($purchaseOrders)
            ->setPurchasePrepared($purchasePrepared)
            ->setPurchaseReceipts($purchaseReceipts)
            ->setReceiptsForSO($receiptsForSO)
            ->setResults($results)
            ->setSOAllocated($sOAllocated)
            ->setSOBackOrdered($sOBackOrdered)
            ->setSOBooked($sOBooked)
            ->setSOPrepared($sOPrepared)
            ->setSOShipped($sOShipped)
            ->setSOToPurchase($sOToPurchase)
            ->setTotalAddition($totalAddition)
            ->setTotalDeduction($totalDeduction)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAvailable()
    {
        return isset($this->Available) ? $this->Available : null;
    }
    /**
     * Set Available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $available
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setAvailable(\App\API\SOAP\StructType\DecimalValue $available = null)
    {
        if (is_null($available) || (is_array($available) && empty($available))) {
            unset($this->Available);
        } else {
            $this->Available = $available;
        }
        return $this;
    }
    /**
     * Get AvailableForIssue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAvailableForIssue()
    {
        return isset($this->AvailableForIssue) ? $this->AvailableForIssue : null;
    }
    /**
     * Set AvailableForIssue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $availableForIssue
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setAvailableForIssue(\App\API\SOAP\StructType\DecimalValue $availableForIssue = null)
    {
        if (is_null($availableForIssue) || (is_array($availableForIssue) && empty($availableForIssue))) {
            unset($this->AvailableForIssue);
        } else {
            $this->AvailableForIssue = $availableForIssue;
        }
        return $this;
    }
    /**
     * Get AvailableForShipping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAvailableForShipping()
    {
        return isset($this->AvailableForShipping) ? $this->AvailableForShipping : null;
    }
    /**
     * Set AvailableForShipping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $availableForShipping
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setAvailableForShipping(\App\API\SOAP\StructType\DecimalValue $availableForShipping = null)
    {
        if (is_null($availableForShipping) || (is_array($availableForShipping) && empty($availableForShipping))) {
            unset($this->AvailableForShipping);
        } else {
            $this->AvailableForShipping = $availableForShipping;
        }
        return $this;
    }
    /**
     * Get BaseUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBaseUnit()
    {
        return isset($this->BaseUnit) ? $this->BaseUnit : null;
    }
    /**
     * Set BaseUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $baseUnit
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setBaseUnit(\App\API\SOAP\StructType\StringValue $baseUnit = null)
    {
        if (is_null($baseUnit) || (is_array($baseUnit) && empty($baseUnit))) {
            unset($this->BaseUnit);
        } else {
            $this->BaseUnit = $baseUnit;
        }
        return $this;
    }
    /**
     * Get InTransit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getInTransit()
    {
        return isset($this->InTransit) ? $this->InTransit : null;
    }
    /**
     * Set InTransit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $inTransit
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setInTransit(\App\API\SOAP\StructType\DecimalValue $inTransit = null)
    {
        if (is_null($inTransit) || (is_array($inTransit) && empty($inTransit))) {
            unset($this->InTransit);
        } else {
            $this->InTransit = $inTransit;
        }
        return $this;
    }
    /**
     * Get InTransitToSO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getInTransitToSO()
    {
        return isset($this->InTransitToSO) ? $this->InTransitToSO : null;
    }
    /**
     * Set InTransitToSO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $inTransitToSO
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setInTransitToSO(\App\API\SOAP\StructType\DecimalValue $inTransitToSO = null)
    {
        if (is_null($inTransitToSO) || (is_array($inTransitToSO) && empty($inTransitToSO))) {
            unset($this->InTransitToSO);
        } else {
            $this->InTransitToSO = $inTransitToSO;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get InventoryIssues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getInventoryIssues()
    {
        return isset($this->InventoryIssues) ? $this->InventoryIssues : null;
    }
    /**
     * Set InventoryIssues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $inventoryIssues
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setInventoryIssues(\App\API\SOAP\StructType\DecimalValue $inventoryIssues = null)
    {
        if (is_null($inventoryIssues) || (is_array($inventoryIssues) && empty($inventoryIssues))) {
            unset($this->InventoryIssues);
        } else {
            $this->InventoryIssues = $inventoryIssues;
        }
        return $this;
    }
    /**
     * Get InventoryReceipts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getInventoryReceipts()
    {
        return isset($this->InventoryReceipts) ? $this->InventoryReceipts : null;
    }
    /**
     * Set InventoryReceipts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $inventoryReceipts
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setInventoryReceipts(\App\API\SOAP\StructType\DecimalValue $inventoryReceipts = null)
    {
        if (is_null($inventoryReceipts) || (is_array($inventoryReceipts) && empty($inventoryReceipts))) {
            unset($this->InventoryReceipts);
        } else {
            $this->InventoryReceipts = $inventoryReceipts;
        }
        return $this;
    }
    /**
     * Get KitAssemblyDemand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getKitAssemblyDemand()
    {
        return isset($this->KitAssemblyDemand) ? $this->KitAssemblyDemand : null;
    }
    /**
     * Set KitAssemblyDemand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $kitAssemblyDemand
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setKitAssemblyDemand(\App\API\SOAP\StructType\DecimalValue $kitAssemblyDemand = null)
    {
        if (is_null($kitAssemblyDemand) || (is_array($kitAssemblyDemand) && empty($kitAssemblyDemand))) {
            unset($this->KitAssemblyDemand);
        } else {
            $this->KitAssemblyDemand = $kitAssemblyDemand;
        }
        return $this;
    }
    /**
     * Get KitAssemblySupply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getKitAssemblySupply()
    {
        return isset($this->KitAssemblySupply) ? $this->KitAssemblySupply : null;
    }
    /**
     * Set KitAssemblySupply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $kitAssemblySupply
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setKitAssemblySupply(\App\API\SOAP\StructType\DecimalValue $kitAssemblySupply = null)
    {
        if (is_null($kitAssemblySupply) || (is_array($kitAssemblySupply) && empty($kitAssemblySupply))) {
            unset($this->KitAssemblySupply);
        } else {
            $this->KitAssemblySupply = $kitAssemblySupply;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $location
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setLocation(\App\API\SOAP\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get OnHand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOnHand()
    {
        return isset($this->OnHand) ? $this->OnHand : null;
    }
    /**
     * Set OnHand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $onHand
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setOnHand(\App\API\SOAP\StructType\DecimalValue $onHand = null)
    {
        if (is_null($onHand) || (is_array($onHand) && empty($onHand))) {
            unset($this->OnHand);
        } else {
            $this->OnHand = $onHand;
        }
        return $this;
    }
    /**
     * Get OnLocationNotAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getOnLocationNotAvailable()
    {
        return isset($this->OnLocationNotAvailable) ? $this->OnLocationNotAvailable : null;
    }
    /**
     * Set OnLocationNotAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $onLocationNotAvailable
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setOnLocationNotAvailable(\App\API\SOAP\StructType\DecimalValue $onLocationNotAvailable = null)
    {
        if (is_null($onLocationNotAvailable) || (is_array($onLocationNotAvailable) && empty($onLocationNotAvailable))) {
            unset($this->OnLocationNotAvailable);
        } else {
            $this->OnLocationNotAvailable = $onLocationNotAvailable;
        }
        return $this;
    }
    /**
     * Get PurchaseForSO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPurchaseForSO()
    {
        return isset($this->PurchaseForSO) ? $this->PurchaseForSO : null;
    }
    /**
     * Set PurchaseForSO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $purchaseForSO
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setPurchaseForSO(\App\API\SOAP\StructType\DecimalValue $purchaseForSO = null)
    {
        if (is_null($purchaseForSO) || (is_array($purchaseForSO) && empty($purchaseForSO))) {
            unset($this->PurchaseForSO);
        } else {
            $this->PurchaseForSO = $purchaseForSO;
        }
        return $this;
    }
    /**
     * Get PurchaseForSOPrepared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPurchaseForSOPrepared()
    {
        return isset($this->PurchaseForSOPrepared) ? $this->PurchaseForSOPrepared : null;
    }
    /**
     * Set PurchaseForSOPrepared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $purchaseForSOPrepared
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setPurchaseForSOPrepared(\App\API\SOAP\StructType\DecimalValue $purchaseForSOPrepared = null)
    {
        if (is_null($purchaseForSOPrepared) || (is_array($purchaseForSOPrepared) && empty($purchaseForSOPrepared))) {
            unset($this->PurchaseForSOPrepared);
        } else {
            $this->PurchaseForSOPrepared = $purchaseForSOPrepared;
        }
        return $this;
    }
    /**
     * Get PurchaseOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPurchaseOrders()
    {
        return isset($this->PurchaseOrders) ? $this->PurchaseOrders : null;
    }
    /**
     * Set PurchaseOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $purchaseOrders
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setPurchaseOrders(\App\API\SOAP\StructType\DecimalValue $purchaseOrders = null)
    {
        if (is_null($purchaseOrders) || (is_array($purchaseOrders) && empty($purchaseOrders))) {
            unset($this->PurchaseOrders);
        } else {
            $this->PurchaseOrders = $purchaseOrders;
        }
        return $this;
    }
    /**
     * Get PurchasePrepared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPurchasePrepared()
    {
        return isset($this->PurchasePrepared) ? $this->PurchasePrepared : null;
    }
    /**
     * Set PurchasePrepared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $purchasePrepared
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setPurchasePrepared(\App\API\SOAP\StructType\DecimalValue $purchasePrepared = null)
    {
        if (is_null($purchasePrepared) || (is_array($purchasePrepared) && empty($purchasePrepared))) {
            unset($this->PurchasePrepared);
        } else {
            $this->PurchasePrepared = $purchasePrepared;
        }
        return $this;
    }
    /**
     * Get PurchaseReceipts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPurchaseReceipts()
    {
        return isset($this->PurchaseReceipts) ? $this->PurchaseReceipts : null;
    }
    /**
     * Set PurchaseReceipts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $purchaseReceipts
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setPurchaseReceipts(\App\API\SOAP\StructType\DecimalValue $purchaseReceipts = null)
    {
        if (is_null($purchaseReceipts) || (is_array($purchaseReceipts) && empty($purchaseReceipts))) {
            unset($this->PurchaseReceipts);
        } else {
            $this->PurchaseReceipts = $purchaseReceipts;
        }
        return $this;
    }
    /**
     * Get ReceiptsForSO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getReceiptsForSO()
    {
        return isset($this->ReceiptsForSO) ? $this->ReceiptsForSO : null;
    }
    /**
     * Set ReceiptsForSO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $receiptsForSO
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setReceiptsForSO(\App\API\SOAP\StructType\DecimalValue $receiptsForSO = null)
    {
        if (is_null($receiptsForSO) || (is_array($receiptsForSO) && empty($receiptsForSO))) {
            unset($this->ReceiptsForSO);
        } else {
            $this->ReceiptsForSO = $receiptsForSO;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Results|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Results $results
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setResults(\App\API\SOAP\StructType\Results $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get SOAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getSOAllocated()
    {
        return isset($this->SOAllocated) ? $this->SOAllocated : null;
    }
    /**
     * Set SOAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $sOAllocated
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setSOAllocated(\App\API\SOAP\StructType\DecimalValue $sOAllocated = null)
    {
        if (is_null($sOAllocated) || (is_array($sOAllocated) && empty($sOAllocated))) {
            unset($this->SOAllocated);
        } else {
            $this->SOAllocated = $sOAllocated;
        }
        return $this;
    }
    /**
     * Get SOBackOrdered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getSOBackOrdered()
    {
        return isset($this->SOBackOrdered) ? $this->SOBackOrdered : null;
    }
    /**
     * Set SOBackOrdered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $sOBackOrdered
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setSOBackOrdered(\App\API\SOAP\StructType\DecimalValue $sOBackOrdered = null)
    {
        if (is_null($sOBackOrdered) || (is_array($sOBackOrdered) && empty($sOBackOrdered))) {
            unset($this->SOBackOrdered);
        } else {
            $this->SOBackOrdered = $sOBackOrdered;
        }
        return $this;
    }
    /**
     * Get SOBooked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getSOBooked()
    {
        return isset($this->SOBooked) ? $this->SOBooked : null;
    }
    /**
     * Set SOBooked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $sOBooked
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setSOBooked(\App\API\SOAP\StructType\DecimalValue $sOBooked = null)
    {
        if (is_null($sOBooked) || (is_array($sOBooked) && empty($sOBooked))) {
            unset($this->SOBooked);
        } else {
            $this->SOBooked = $sOBooked;
        }
        return $this;
    }
    /**
     * Get SOPrepared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getSOPrepared()
    {
        return isset($this->SOPrepared) ? $this->SOPrepared : null;
    }
    /**
     * Set SOPrepared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $sOPrepared
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setSOPrepared(\App\API\SOAP\StructType\DecimalValue $sOPrepared = null)
    {
        if (is_null($sOPrepared) || (is_array($sOPrepared) && empty($sOPrepared))) {
            unset($this->SOPrepared);
        } else {
            $this->SOPrepared = $sOPrepared;
        }
        return $this;
    }
    /**
     * Get SOShipped value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getSOShipped()
    {
        return isset($this->SOShipped) ? $this->SOShipped : null;
    }
    /**
     * Set SOShipped value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $sOShipped
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setSOShipped(\App\API\SOAP\StructType\DecimalValue $sOShipped = null)
    {
        if (is_null($sOShipped) || (is_array($sOShipped) && empty($sOShipped))) {
            unset($this->SOShipped);
        } else {
            $this->SOShipped = $sOShipped;
        }
        return $this;
    }
    /**
     * Get SOToPurchase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getSOToPurchase()
    {
        return isset($this->SOToPurchase) ? $this->SOToPurchase : null;
    }
    /**
     * Set SOToPurchase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $sOToPurchase
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setSOToPurchase(\App\API\SOAP\StructType\DecimalValue $sOToPurchase = null)
    {
        if (is_null($sOToPurchase) || (is_array($sOToPurchase) && empty($sOToPurchase))) {
            unset($this->SOToPurchase);
        } else {
            $this->SOToPurchase = $sOToPurchase;
        }
        return $this;
    }
    /**
     * Get TotalAddition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTotalAddition()
    {
        return isset($this->TotalAddition) ? $this->TotalAddition : null;
    }
    /**
     * Set TotalAddition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $totalAddition
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setTotalAddition(\App\API\SOAP\StructType\DecimalValue $totalAddition = null)
    {
        if (is_null($totalAddition) || (is_array($totalAddition) && empty($totalAddition))) {
            unset($this->TotalAddition);
        } else {
            $this->TotalAddition = $totalAddition;
        }
        return $this;
    }
    /**
     * Get TotalDeduction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTotalDeduction()
    {
        return isset($this->TotalDeduction) ? $this->TotalDeduction : null;
    }
    /**
     * Set TotalDeduction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $totalDeduction
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setTotalDeduction(\App\API\SOAP\StructType\DecimalValue $totalDeduction = null)
    {
        if (is_null($totalDeduction) || (is_array($totalDeduction) && empty($totalDeduction))) {
            unset($this->TotalDeduction);
        } else {
            $this->TotalDeduction = $totalDeduction;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     * @return \App\API\SOAP\StructType\InventoryAllocationInquiry
     */
    public function setWarehouseID(\App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
