<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for History StructType
 * @subpackage Structs
 */
class History extends AbstractStructBase
{
    /**
     * The CheckHistoryDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CheckHistoryDetail[]
     */
    public $CheckHistoryDetail;
    /**
     * Constructor method for History
     * @uses History::setCheckHistoryDetail()
     * @param \App\API\SOAP\StructType\CheckHistoryDetail[] $checkHistoryDetail
     */
    public function __construct(array $checkHistoryDetail = array())
    {
        $this
            ->setCheckHistoryDetail($checkHistoryDetail);
    }
    /**
     * Get CheckHistoryDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CheckHistoryDetail[]|null
     */
    public function getCheckHistoryDetail()
    {
        return isset($this->CheckHistoryDetail) ? $this->CheckHistoryDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCheckHistoryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckHistoryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCheckHistoryDetailForArrayConstraintsFromSetCheckHistoryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $historyCheckHistoryDetailItem) {
            // validation for constraint: itemType
            if (!$historyCheckHistoryDetailItem instanceof \App\API\SOAP\StructType\CheckHistoryDetail) {
                $invalidValues[] = is_object($historyCheckHistoryDetailItem) ? get_class($historyCheckHistoryDetailItem) : sprintf('%s(%s)', gettype($historyCheckHistoryDetailItem), var_export($historyCheckHistoryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CheckHistoryDetail property can only contain items of type \App\API\SOAP\StructType\CheckHistoryDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CheckHistoryDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CheckHistoryDetail[] $checkHistoryDetail
     * @return \App\API\SOAP\StructType\History
     */
    public function setCheckHistoryDetail(array $checkHistoryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($checkHistoryDetailArrayErrorMessage = self::validateCheckHistoryDetailForArrayConstraintsFromSetCheckHistoryDetail($checkHistoryDetail))) {
            throw new \InvalidArgumentException($checkHistoryDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($checkHistoryDetail) || (is_array($checkHistoryDetail) && empty($checkHistoryDetail))) {
            unset($this->CheckHistoryDetail);
        } else {
            $this->CheckHistoryDetail = $checkHistoryDetail;
        }
        return $this;
    }
    /**
     * Add item to CheckHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CheckHistoryDetail $item
     * @return \App\API\SOAP\StructType\History
     */
    public function addToCheckHistoryDetail(\App\API\SOAP\StructType\CheckHistoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\CheckHistoryDetail) {
            throw new \InvalidArgumentException(sprintf('The CheckHistoryDetail property can only contain items of type \App\API\SOAP\StructType\CheckHistoryDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CheckHistoryDetail[] = $item;
        return $this;
    }
}
