<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightRates StructType
 * @subpackage Structs
 */
class FreightRates extends AbstractStructBase
{
    /**
     * The ShipViaFreightRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShipViaFreightRate[]
     */
    public $ShipViaFreightRate;
    /**
     * Constructor method for FreightRates
     * @uses FreightRates::setShipViaFreightRate()
     * @param \App\API\SOAP\StructType\ShipViaFreightRate[] $shipViaFreightRate
     */
    public function __construct(array $shipViaFreightRate = array())
    {
        $this
            ->setShipViaFreightRate($shipViaFreightRate);
    }
    /**
     * Get ShipViaFreightRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShipViaFreightRate[]|null
     */
    public function getShipViaFreightRate()
    {
        return isset($this->ShipViaFreightRate) ? $this->ShipViaFreightRate : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipViaFreightRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipViaFreightRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipViaFreightRateForArrayConstraintsFromSetShipViaFreightRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $freightRatesShipViaFreightRateItem) {
            // validation for constraint: itemType
            if (!$freightRatesShipViaFreightRateItem instanceof \App\API\SOAP\StructType\ShipViaFreightRate) {
                $invalidValues[] = is_object($freightRatesShipViaFreightRateItem) ? get_class($freightRatesShipViaFreightRateItem) : sprintf('%s(%s)', gettype($freightRatesShipViaFreightRateItem), var_export($freightRatesShipViaFreightRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipViaFreightRate property can only contain items of type \App\API\SOAP\StructType\ShipViaFreightRate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipViaFreightRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShipViaFreightRate[] $shipViaFreightRate
     * @return \App\API\SOAP\StructType\FreightRates
     */
    public function setShipViaFreightRate(array $shipViaFreightRate = array())
    {
        // validation for constraint: array
        if ('' !== ($shipViaFreightRateArrayErrorMessage = self::validateShipViaFreightRateForArrayConstraintsFromSetShipViaFreightRate($shipViaFreightRate))) {
            throw new \InvalidArgumentException($shipViaFreightRateArrayErrorMessage, __LINE__);
        }
        if (is_null($shipViaFreightRate) || (is_array($shipViaFreightRate) && empty($shipViaFreightRate))) {
            unset($this->ShipViaFreightRate);
        } else {
            $this->ShipViaFreightRate = $shipViaFreightRate;
        }
        return $this;
    }
    /**
     * Add item to ShipViaFreightRate value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShipViaFreightRate $item
     * @return \App\API\SOAP\StructType\FreightRates
     */
    public function addToShipViaFreightRate(\App\API\SOAP\StructType\ShipViaFreightRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ShipViaFreightRate) {
            throw new \InvalidArgumentException(sprintf('The ShipViaFreightRate property can only contain items of type \App\API\SOAP\StructType\ShipViaFreightRate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipViaFreightRate[] = $item;
        return $this;
    }
}
