<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightDetails StructType
 * @subpackage Structs
 */
class FreightDetails extends AbstractStructBase
{
    /**
     * The SalesInvoiceFreightDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesInvoiceFreightDetail[]
     */
    public $SalesInvoiceFreightDetail;
    /**
     * Constructor method for FreightDetails
     * @uses FreightDetails::setSalesInvoiceFreightDetail()
     * @param \App\API\SOAP\StructType\SalesInvoiceFreightDetail[] $salesInvoiceFreightDetail
     */
    public function __construct(array $salesInvoiceFreightDetail = array())
    {
        $this
            ->setSalesInvoiceFreightDetail($salesInvoiceFreightDetail);
    }
    /**
     * Get SalesInvoiceFreightDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesInvoiceFreightDetail[]|null
     */
    public function getSalesInvoiceFreightDetail()
    {
        return isset($this->SalesInvoiceFreightDetail) ? $this->SalesInvoiceFreightDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesInvoiceFreightDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesInvoiceFreightDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesInvoiceFreightDetailForArrayConstraintsFromSetSalesInvoiceFreightDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $freightDetailsSalesInvoiceFreightDetailItem) {
            // validation for constraint: itemType
            if (!$freightDetailsSalesInvoiceFreightDetailItem instanceof \App\API\SOAP\StructType\SalesInvoiceFreightDetail) {
                $invalidValues[] = is_object($freightDetailsSalesInvoiceFreightDetailItem) ? get_class($freightDetailsSalesInvoiceFreightDetailItem) : sprintf('%s(%s)', gettype($freightDetailsSalesInvoiceFreightDetailItem), var_export($freightDetailsSalesInvoiceFreightDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesInvoiceFreightDetail property can only contain items of type \App\API\SOAP\StructType\SalesInvoiceFreightDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesInvoiceFreightDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesInvoiceFreightDetail[] $salesInvoiceFreightDetail
     * @return \App\API\SOAP\StructType\FreightDetails
     */
    public function setSalesInvoiceFreightDetail(array $salesInvoiceFreightDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($salesInvoiceFreightDetailArrayErrorMessage = self::validateSalesInvoiceFreightDetailForArrayConstraintsFromSetSalesInvoiceFreightDetail($salesInvoiceFreightDetail))) {
            throw new \InvalidArgumentException($salesInvoiceFreightDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($salesInvoiceFreightDetail) || (is_array($salesInvoiceFreightDetail) && empty($salesInvoiceFreightDetail))) {
            unset($this->SalesInvoiceFreightDetail);
        } else {
            $this->SalesInvoiceFreightDetail = $salesInvoiceFreightDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceFreightDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesInvoiceFreightDetail $item
     * @return \App\API\SOAP\StructType\FreightDetails
     */
    public function addToSalesInvoiceFreightDetail(\App\API\SOAP\StructType\SalesInvoiceFreightDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesInvoiceFreightDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceFreightDetail property can only contain items of type \App\API\SOAP\StructType\SalesInvoiceFreightDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesInvoiceFreightDetail[] = $item;
        return $this;
    }
}
