<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FOBPoint StructType
 * @subpackage Structs
 */
class FOBPoint extends Entity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The FOBPointID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FOBPointID;
    /**
     * Constructor method for FOBPoint
     * @uses FOBPoint::setDescription()
     * @uses FOBPoint::setFOBPointID()
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $fOBPointID
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $fOBPointID = null)
    {
        $this
            ->setDescription($description)
            ->setFOBPointID($fOBPointID);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\FOBPoint
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FOBPointID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFOBPointID()
    {
        return isset($this->FOBPointID) ? $this->FOBPointID : null;
    }
    /**
     * Set FOBPointID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $fOBPointID
     * @return \App\API\SOAP\StructType\FOBPoint
     */
    public function setFOBPointID(\App\API\SOAP\StructType\StringValue $fOBPointID = null)
    {
        if (is_null($fOBPointID) || (is_array($fOBPointID) && empty($fOBPointID))) {
            unset($this->FOBPointID);
        } else {
            $this->FOBPointID = $fOBPointID;
        }
        return $this;
    }
}
