<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseReceiptTaxDetails StructType
 * @subpackage Structs
 */
class ExpenseReceiptTaxDetails extends Entity
{
    /**
     * The DeductibleTaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $DeductibleTaxRate;
    /**
     * The ExpenseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ExpenseAmount;
    /**
     * The IncludeInVATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IncludeInVATExemptTotal;
    /**
     * The PendingVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $PendingVAT;
    /**
     * The ReverseVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ReverseVAT;
    /**
     * The StatisticalVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $StatisticalVAT;
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxAmount;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxRate;
    /**
     * The TaxType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxType;
    /**
     * Constructor method for ExpenseReceiptTaxDetails
     * @uses ExpenseReceiptTaxDetails::setDeductibleTaxRate()
     * @uses ExpenseReceiptTaxDetails::setExpenseAmount()
     * @uses ExpenseReceiptTaxDetails::setIncludeInVATExemptTotal()
     * @uses ExpenseReceiptTaxDetails::setPendingVAT()
     * @uses ExpenseReceiptTaxDetails::setReverseVAT()
     * @uses ExpenseReceiptTaxDetails::setStatisticalVAT()
     * @uses ExpenseReceiptTaxDetails::setTaxableAmount()
     * @uses ExpenseReceiptTaxDetails::setTaxAmount()
     * @uses ExpenseReceiptTaxDetails::setTaxID()
     * @uses ExpenseReceiptTaxDetails::setTaxRate()
     * @uses ExpenseReceiptTaxDetails::setTaxType()
     * @param \App\API\SOAP\StructType\DecimalValue $deductibleTaxRate
     * @param \App\API\SOAP\StructType\DecimalValue $expenseAmount
     * @param \App\API\SOAP\StructType\BooleanValue $includeInVATExemptTotal
     * @param \App\API\SOAP\StructType\BooleanValue $pendingVAT
     * @param \App\API\SOAP\StructType\BooleanValue $reverseVAT
     * @param \App\API\SOAP\StructType\BooleanValue $statisticalVAT
     * @param \App\API\SOAP\StructType\DecimalValue $taxableAmount
     * @param \App\API\SOAP\StructType\DecimalValue $taxAmount
     * @param \App\API\SOAP\StructType\StringValue $taxID
     * @param \App\API\SOAP\StructType\DecimalValue $taxRate
     * @param \App\API\SOAP\StructType\StringValue $taxType
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $deductibleTaxRate = null, \App\API\SOAP\StructType\DecimalValue $expenseAmount = null, \App\API\SOAP\StructType\BooleanValue $includeInVATExemptTotal = null, \App\API\SOAP\StructType\BooleanValue $pendingVAT = null, \App\API\SOAP\StructType\BooleanValue $reverseVAT = null, \App\API\SOAP\StructType\BooleanValue $statisticalVAT = null, \App\API\SOAP\StructType\DecimalValue $taxableAmount = null, \App\API\SOAP\StructType\DecimalValue $taxAmount = null, \App\API\SOAP\StructType\StringValue $taxID = null, \App\API\SOAP\StructType\DecimalValue $taxRate = null, \App\API\SOAP\StructType\StringValue $taxType = null)
    {
        $this
            ->setDeductibleTaxRate($deductibleTaxRate)
            ->setExpenseAmount($expenseAmount)
            ->setIncludeInVATExemptTotal($includeInVATExemptTotal)
            ->setPendingVAT($pendingVAT)
            ->setReverseVAT($reverseVAT)
            ->setStatisticalVAT($statisticalVAT)
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate)
            ->setTaxType($taxType);
    }
    /**
     * Get DeductibleTaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getDeductibleTaxRate()
    {
        return isset($this->DeductibleTaxRate) ? $this->DeductibleTaxRate : null;
    }
    /**
     * Set DeductibleTaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $deductibleTaxRate
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setDeductibleTaxRate(\App\API\SOAP\StructType\DecimalValue $deductibleTaxRate = null)
    {
        if (is_null($deductibleTaxRate) || (is_array($deductibleTaxRate) && empty($deductibleTaxRate))) {
            unset($this->DeductibleTaxRate);
        } else {
            $this->DeductibleTaxRate = $deductibleTaxRate;
        }
        return $this;
    }
    /**
     * Get ExpenseAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getExpenseAmount()
    {
        return isset($this->ExpenseAmount) ? $this->ExpenseAmount : null;
    }
    /**
     * Set ExpenseAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $expenseAmount
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setExpenseAmount(\App\API\SOAP\StructType\DecimalValue $expenseAmount = null)
    {
        if (is_null($expenseAmount) || (is_array($expenseAmount) && empty($expenseAmount))) {
            unset($this->ExpenseAmount);
        } else {
            $this->ExpenseAmount = $expenseAmount;
        }
        return $this;
    }
    /**
     * Get IncludeInVATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncludeInVATExemptTotal()
    {
        return isset($this->IncludeInVATExemptTotal) ? $this->IncludeInVATExemptTotal : null;
    }
    /**
     * Set IncludeInVATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $includeInVATExemptTotal
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setIncludeInVATExemptTotal(\App\API\SOAP\StructType\BooleanValue $includeInVATExemptTotal = null)
    {
        if (is_null($includeInVATExemptTotal) || (is_array($includeInVATExemptTotal) && empty($includeInVATExemptTotal))) {
            unset($this->IncludeInVATExemptTotal);
        } else {
            $this->IncludeInVATExemptTotal = $includeInVATExemptTotal;
        }
        return $this;
    }
    /**
     * Get PendingVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getPendingVAT()
    {
        return isset($this->PendingVAT) ? $this->PendingVAT : null;
    }
    /**
     * Set PendingVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $pendingVAT
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setPendingVAT(\App\API\SOAP\StructType\BooleanValue $pendingVAT = null)
    {
        if (is_null($pendingVAT) || (is_array($pendingVAT) && empty($pendingVAT))) {
            unset($this->PendingVAT);
        } else {
            $this->PendingVAT = $pendingVAT;
        }
        return $this;
    }
    /**
     * Get ReverseVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getReverseVAT()
    {
        return isset($this->ReverseVAT) ? $this->ReverseVAT : null;
    }
    /**
     * Set ReverseVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $reverseVAT
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setReverseVAT(\App\API\SOAP\StructType\BooleanValue $reverseVAT = null)
    {
        if (is_null($reverseVAT) || (is_array($reverseVAT) && empty($reverseVAT))) {
            unset($this->ReverseVAT);
        } else {
            $this->ReverseVAT = $reverseVAT;
        }
        return $this;
    }
    /**
     * Get StatisticalVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getStatisticalVAT()
    {
        return isset($this->StatisticalVAT) ? $this->StatisticalVAT : null;
    }
    /**
     * Set StatisticalVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $statisticalVAT
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setStatisticalVAT(\App\API\SOAP\StructType\BooleanValue $statisticalVAT = null)
    {
        if (is_null($statisticalVAT) || (is_array($statisticalVAT) && empty($statisticalVAT))) {
            unset($this->StatisticalVAT);
        } else {
            $this->StatisticalVAT = $statisticalVAT;
        }
        return $this;
    }
    /**
     * Get TaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxableAmount()
    {
        return isset($this->TaxableAmount) ? $this->TaxableAmount : null;
    }
    /**
     * Set TaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxableAmount
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setTaxableAmount(\App\API\SOAP\StructType\DecimalValue $taxableAmount = null)
    {
        if (is_null($taxableAmount) || (is_array($taxableAmount) && empty($taxableAmount))) {
            unset($this->TaxableAmount);
        } else {
            $this->TaxableAmount = $taxableAmount;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxAmount
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setTaxAmount(\App\API\SOAP\StructType\DecimalValue $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxID
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setTaxID(\App\API\SOAP\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxRate()
    {
        return isset($this->TaxRate) ? $this->TaxRate : null;
    }
    /**
     * Set TaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxRate
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setTaxRate(\App\API\SOAP\StructType\DecimalValue $taxRate = null)
    {
        if (is_null($taxRate) || (is_array($taxRate) && empty($taxRate))) {
            unset($this->TaxRate);
        } else {
            $this->TaxRate = $taxRate;
        }
        return $this;
    }
    /**
     * Get TaxType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxType()
    {
        return isset($this->TaxType) ? $this->TaxType : null;
    }
    /**
     * Set TaxType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxType
     * @return \App\API\SOAP\StructType\ExpenseReceiptTaxDetails
     */
    public function setTaxType(\App\API\SOAP\StructType\StringValue $taxType = null)
    {
        if (is_null($taxType) || (is_array($taxType) && empty($taxType))) {
            unset($this->TaxType);
        } else {
            $this->TaxType = $taxType;
        }
        return $this;
    }
}
