<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseClaimDetails StructType
 * @subpackage Structs
 */
class ExpenseClaimDetails extends Entity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The AmountInClaimCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $AmountInClaimCurrency;
    /**
     * The APRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $APRefNbr;
    /**
     * The ARRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ARRefNbr;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Billable;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The ClaimAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ClaimAmount;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CostCode;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The EmployeePart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $EmployeePart;
    /**
     * The ExpenseAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ExpenseAccount;
    /**
     * The ExpenseItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ExpenseItemID;
    /**
     * The ExpenseSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ExpenseSubaccount;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LocationID;
    /**
     * The NetAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $NetAmount;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The RefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $RefNbr;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxAmount;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TaxZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxZone;
    /**
     * The TipAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TipAmount;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for ExpenseClaimDetails
     * @uses ExpenseClaimDetails::setAmount()
     * @uses ExpenseClaimDetails::setAmountInClaimCurrency()
     * @uses ExpenseClaimDetails::setAPRefNbr()
     * @uses ExpenseClaimDetails::setARRefNbr()
     * @uses ExpenseClaimDetails::setBillable()
     * @uses ExpenseClaimDetails::setBranch()
     * @uses ExpenseClaimDetails::setClaimAmount()
     * @uses ExpenseClaimDetails::setCostCode()
     * @uses ExpenseClaimDetails::setCurrencyID()
     * @uses ExpenseClaimDetails::setCustomerID()
     * @uses ExpenseClaimDetails::setDate()
     * @uses ExpenseClaimDetails::setDescription()
     * @uses ExpenseClaimDetails::setEmployeePart()
     * @uses ExpenseClaimDetails::setExpenseAccount()
     * @uses ExpenseClaimDetails::setExpenseItemID()
     * @uses ExpenseClaimDetails::setExpenseSubaccount()
     * @uses ExpenseClaimDetails::setLocationID()
     * @uses ExpenseClaimDetails::setNetAmount()
     * @uses ExpenseClaimDetails::setProjectID()
     * @uses ExpenseClaimDetails::setProjectTaskID()
     * @uses ExpenseClaimDetails::setQty()
     * @uses ExpenseClaimDetails::setRefNbr()
     * @uses ExpenseClaimDetails::setSalesAccount()
     * @uses ExpenseClaimDetails::setSalesSubaccount()
     * @uses ExpenseClaimDetails::setStatus()
     * @uses ExpenseClaimDetails::setTaxAmount()
     * @uses ExpenseClaimDetails::setTaxCategory()
     * @uses ExpenseClaimDetails::setTaxZone()
     * @uses ExpenseClaimDetails::setTipAmount()
     * @uses ExpenseClaimDetails::setUnitCost()
     * @uses ExpenseClaimDetails::setUOM()
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @param \App\API\SOAP\StructType\DecimalValue $amountInClaimCurrency
     * @param \App\API\SOAP\StructType\StringValue $aPRefNbr
     * @param \App\API\SOAP\StructType\StringValue $aRRefNbr
     * @param \App\API\SOAP\StructType\BooleanValue $billable
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\DecimalValue $claimAmount
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DecimalValue $employeePart
     * @param \App\API\SOAP\StructType\StringValue $expenseAccount
     * @param \App\API\SOAP\StructType\StringValue $expenseItemID
     * @param \App\API\SOAP\StructType\StringValue $expenseSubaccount
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @param \App\API\SOAP\StructType\DecimalValue $netAmount
     * @param \App\API\SOAP\StructType\StringValue $projectID
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @param \App\API\SOAP\StructType\StringValue $refNbr
     * @param \App\API\SOAP\StructType\StringValue $salesAccount
     * @param \App\API\SOAP\StructType\StringValue $salesSubaccount
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\DecimalValue $taxAmount
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @param \App\API\SOAP\StructType\StringValue $taxZone
     * @param \App\API\SOAP\StructType\DecimalValue $tipAmount
     * @param \App\API\SOAP\StructType\DecimalValue $unitCost
     * @param \App\API\SOAP\StructType\StringValue $uOM
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $amount = null, \App\API\SOAP\StructType\DecimalValue $amountInClaimCurrency = null, \App\API\SOAP\StructType\StringValue $aPRefNbr = null, \App\API\SOAP\StructType\StringValue $aRRefNbr = null, \App\API\SOAP\StructType\BooleanValue $billable = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\DecimalValue $claimAmount = null, \App\API\SOAP\StructType\StringValue $costCode = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\StringValue $customerID = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DecimalValue $employeePart = null, \App\API\SOAP\StructType\StringValue $expenseAccount = null, \App\API\SOAP\StructType\StringValue $expenseItemID = null, \App\API\SOAP\StructType\StringValue $expenseSubaccount = null, \App\API\SOAP\StructType\StringValue $locationID = null, \App\API\SOAP\StructType\DecimalValue $netAmount = null, \App\API\SOAP\StructType\StringValue $projectID = null, \App\API\SOAP\StructType\StringValue $projectTaskID = null, \App\API\SOAP\StructType\DecimalValue $qty = null, \App\API\SOAP\StructType\StringValue $refNbr = null, \App\API\SOAP\StructType\StringValue $salesAccount = null, \App\API\SOAP\StructType\StringValue $salesSubaccount = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\DecimalValue $taxAmount = null, \App\API\SOAP\StructType\StringValue $taxCategory = null, \App\API\SOAP\StructType\StringValue $taxZone = null, \App\API\SOAP\StructType\DecimalValue $tipAmount = null, \App\API\SOAP\StructType\DecimalValue $unitCost = null, \App\API\SOAP\StructType\StringValue $uOM = null)
    {
        $this
            ->setAmount($amount)
            ->setAmountInClaimCurrency($amountInClaimCurrency)
            ->setAPRefNbr($aPRefNbr)
            ->setARRefNbr($aRRefNbr)
            ->setBillable($billable)
            ->setBranch($branch)
            ->setClaimAmount($claimAmount)
            ->setCostCode($costCode)
            ->setCurrencyID($currencyID)
            ->setCustomerID($customerID)
            ->setDate($date)
            ->setDescription($description)
            ->setEmployeePart($employeePart)
            ->setExpenseAccount($expenseAccount)
            ->setExpenseItemID($expenseItemID)
            ->setExpenseSubaccount($expenseSubaccount)
            ->setLocationID($locationID)
            ->setNetAmount($netAmount)
            ->setProjectID($projectID)
            ->setProjectTaskID($projectTaskID)
            ->setQty($qty)
            ->setRefNbr($refNbr)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setStatus($status)
            ->setTaxAmount($taxAmount)
            ->setTaxCategory($taxCategory)
            ->setTaxZone($taxZone)
            ->setTipAmount($tipAmount)
            ->setUnitCost($unitCost)
            ->setUOM($uOM);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setAmount(\App\API\SOAP\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get AmountInClaimCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmountInClaimCurrency()
    {
        return isset($this->AmountInClaimCurrency) ? $this->AmountInClaimCurrency : null;
    }
    /**
     * Set AmountInClaimCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amountInClaimCurrency
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setAmountInClaimCurrency(\App\API\SOAP\StructType\DecimalValue $amountInClaimCurrency = null)
    {
        if (is_null($amountInClaimCurrency) || (is_array($amountInClaimCurrency) && empty($amountInClaimCurrency))) {
            unset($this->AmountInClaimCurrency);
        } else {
            $this->AmountInClaimCurrency = $amountInClaimCurrency;
        }
        return $this;
    }
    /**
     * Get APRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAPRefNbr()
    {
        return isset($this->APRefNbr) ? $this->APRefNbr : null;
    }
    /**
     * Set APRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $aPRefNbr
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setAPRefNbr(\App\API\SOAP\StructType\StringValue $aPRefNbr = null)
    {
        if (is_null($aPRefNbr) || (is_array($aPRefNbr) && empty($aPRefNbr))) {
            unset($this->APRefNbr);
        } else {
            $this->APRefNbr = $aPRefNbr;
        }
        return $this;
    }
    /**
     * Get ARRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getARRefNbr()
    {
        return isset($this->ARRefNbr) ? $this->ARRefNbr : null;
    }
    /**
     * Set ARRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $aRRefNbr
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setARRefNbr(\App\API\SOAP\StructType\StringValue $aRRefNbr = null)
    {
        if (is_null($aRRefNbr) || (is_array($aRRefNbr) && empty($aRRefNbr))) {
            unset($this->ARRefNbr);
        } else {
            $this->ARRefNbr = $aRRefNbr;
        }
        return $this;
    }
    /**
     * Get Billable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * Set Billable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billable
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setBillable(\App\API\SOAP\StructType\BooleanValue $billable = null)
    {
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get ClaimAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getClaimAmount()
    {
        return isset($this->ClaimAmount) ? $this->ClaimAmount : null;
    }
    /**
     * Set ClaimAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $claimAmount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setClaimAmount(\App\API\SOAP\StructType\DecimalValue $claimAmount = null)
    {
        if (is_null($claimAmount) || (is_array($claimAmount) && empty($claimAmount))) {
            unset($this->ClaimAmount);
        } else {
            $this->ClaimAmount = $claimAmount;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setCostCode(\App\API\SOAP\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setCustomerID(\App\API\SOAP\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EmployeePart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getEmployeePart()
    {
        return isset($this->EmployeePart) ? $this->EmployeePart : null;
    }
    /**
     * Set EmployeePart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $employeePart
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setEmployeePart(\App\API\SOAP\StructType\DecimalValue $employeePart = null)
    {
        if (is_null($employeePart) || (is_array($employeePart) && empty($employeePart))) {
            unset($this->EmployeePart);
        } else {
            $this->EmployeePart = $employeePart;
        }
        return $this;
    }
    /**
     * Get ExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getExpenseAccount()
    {
        return isset($this->ExpenseAccount) ? $this->ExpenseAccount : null;
    }
    /**
     * Set ExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $expenseAccount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setExpenseAccount(\App\API\SOAP\StructType\StringValue $expenseAccount = null)
    {
        if (is_null($expenseAccount) || (is_array($expenseAccount) && empty($expenseAccount))) {
            unset($this->ExpenseAccount);
        } else {
            $this->ExpenseAccount = $expenseAccount;
        }
        return $this;
    }
    /**
     * Get ExpenseItemID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getExpenseItemID()
    {
        return isset($this->ExpenseItemID) ? $this->ExpenseItemID : null;
    }
    /**
     * Set ExpenseItemID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $expenseItemID
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setExpenseItemID(\App\API\SOAP\StructType\StringValue $expenseItemID = null)
    {
        if (is_null($expenseItemID) || (is_array($expenseItemID) && empty($expenseItemID))) {
            unset($this->ExpenseItemID);
        } else {
            $this->ExpenseItemID = $expenseItemID;
        }
        return $this;
    }
    /**
     * Get ExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getExpenseSubaccount()
    {
        return isset($this->ExpenseSubaccount) ? $this->ExpenseSubaccount : null;
    }
    /**
     * Set ExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $expenseSubaccount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setExpenseSubaccount(\App\API\SOAP\StructType\StringValue $expenseSubaccount = null)
    {
        if (is_null($expenseSubaccount) || (is_array($expenseSubaccount) && empty($expenseSubaccount))) {
            unset($this->ExpenseSubaccount);
        } else {
            $this->ExpenseSubaccount = $expenseSubaccount;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $locationID
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setLocationID(\App\API\SOAP\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get NetAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getNetAmount()
    {
        return isset($this->NetAmount) ? $this->NetAmount : null;
    }
    /**
     * Set NetAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $netAmount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setNetAmount(\App\API\SOAP\StructType\DecimalValue $netAmount = null)
    {
        if (is_null($netAmount) || (is_array($netAmount) && empty($netAmount))) {
            unset($this->NetAmount);
        } else {
            $this->NetAmount = $netAmount;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectID
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setProjectID(\App\API\SOAP\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTaskID
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setProjectTaskID(\App\API\SOAP\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setQty(\App\API\SOAP\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get RefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getRefNbr()
    {
        return isset($this->RefNbr) ? $this->RefNbr : null;
    }
    /**
     * Set RefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $refNbr
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setRefNbr(\App\API\SOAP\StructType\StringValue $refNbr = null)
    {
        if (is_null($refNbr) || (is_array($refNbr) && empty($refNbr))) {
            unset($this->RefNbr);
        } else {
            $this->RefNbr = $refNbr;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesAccount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setSalesAccount(\App\API\SOAP\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $salesSubaccount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setSalesSubaccount(\App\API\SOAP\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxAmount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setTaxAmount(\App\API\SOAP\StructType\DecimalValue $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setTaxCategory(\App\API\SOAP\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxZone
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setTaxZone(\App\API\SOAP\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get TipAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTipAmount()
    {
        return isset($this->TipAmount) ? $this->TipAmount : null;
    }
    /**
     * Set TipAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $tipAmount
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setTipAmount(\App\API\SOAP\StructType\DecimalValue $tipAmount = null)
    {
        if (is_null($tipAmount) || (is_array($tipAmount) && empty($tipAmount))) {
            unset($this->TipAmount);
        } else {
            $this->TipAmount = $tipAmount;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unitCost
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setUnitCost(\App\API\SOAP\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
