<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRelatedActivity StructType
 * @subpackage Structs
 */
class EventRelatedActivity extends Entity
{
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Billable;
    /**
     * The BillableOvertime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BillableOvertime;
    /**
     * The BillableTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BillableTime;
    /**
     * The Overtime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Overtime;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Summary;
    /**
     * The TimeSpent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TimeSpent;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for EventRelatedActivity
     * @uses EventRelatedActivity::setBillable()
     * @uses EventRelatedActivity::setBillableOvertime()
     * @uses EventRelatedActivity::setBillableTime()
     * @uses EventRelatedActivity::setOvertime()
     * @uses EventRelatedActivity::setStartDate()
     * @uses EventRelatedActivity::setStatus()
     * @uses EventRelatedActivity::setSummary()
     * @uses EventRelatedActivity::setTimeSpent()
     * @uses EventRelatedActivity::setType()
     * @param \App\API\SOAP\StructType\BooleanValue $billable
     * @param \App\API\SOAP\StructType\StringValue $billableOvertime
     * @param \App\API\SOAP\StructType\StringValue $billableTime
     * @param \App\API\SOAP\StructType\StringValue $overtime
     * @param \App\API\SOAP\StructType\DateTimeValue $startDate
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $summary
     * @param \App\API\SOAP\StructType\StringValue $timeSpent
     * @param \App\API\SOAP\StructType\StringValue $type
     */
    public function __construct(\App\API\SOAP\StructType\BooleanValue $billable = null, \App\API\SOAP\StructType\StringValue $billableOvertime = null, \App\API\SOAP\StructType\StringValue $billableTime = null, \App\API\SOAP\StructType\StringValue $overtime = null, \App\API\SOAP\StructType\DateTimeValue $startDate = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $summary = null, \App\API\SOAP\StructType\StringValue $timeSpent = null, \App\API\SOAP\StructType\StringValue $type = null)
    {
        $this
            ->setBillable($billable)
            ->setBillableOvertime($billableOvertime)
            ->setBillableTime($billableTime)
            ->setOvertime($overtime)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setSummary($summary)
            ->setTimeSpent($timeSpent)
            ->setType($type);
    }
    /**
     * Get Billable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * Set Billable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billable
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setBillable(\App\API\SOAP\StructType\BooleanValue $billable = null)
    {
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get BillableOvertime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBillableOvertime()
    {
        return isset($this->BillableOvertime) ? $this->BillableOvertime : null;
    }
    /**
     * Set BillableOvertime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $billableOvertime
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setBillableOvertime(\App\API\SOAP\StructType\StringValue $billableOvertime = null)
    {
        if (is_null($billableOvertime) || (is_array($billableOvertime) && empty($billableOvertime))) {
            unset($this->BillableOvertime);
        } else {
            $this->BillableOvertime = $billableOvertime;
        }
        return $this;
    }
    /**
     * Get BillableTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBillableTime()
    {
        return isset($this->BillableTime) ? $this->BillableTime : null;
    }
    /**
     * Set BillableTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $billableTime
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setBillableTime(\App\API\SOAP\StructType\StringValue $billableTime = null)
    {
        if (is_null($billableTime) || (is_array($billableTime) && empty($billableTime))) {
            unset($this->BillableTime);
        } else {
            $this->BillableTime = $billableTime;
        }
        return $this;
    }
    /**
     * Get Overtime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOvertime()
    {
        return isset($this->Overtime) ? $this->Overtime : null;
    }
    /**
     * Set Overtime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $overtime
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setOvertime(\App\API\SOAP\StructType\StringValue $overtime = null)
    {
        if (is_null($overtime) || (is_array($overtime) && empty($overtime))) {
            unset($this->Overtime);
        } else {
            $this->Overtime = $overtime;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $startDate
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setStartDate(\App\API\SOAP\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $summary
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setSummary(\App\API\SOAP\StructType\StringValue $summary = null)
    {
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get TimeSpent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTimeSpent()
    {
        return isset($this->TimeSpent) ? $this->TimeSpent : null;
    }
    /**
     * Set TimeSpent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $timeSpent
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setTimeSpent(\App\API\SOAP\StructType\StringValue $timeSpent = null)
    {
        if (is_null($timeSpent) || (is_array($timeSpent) && empty($timeSpent))) {
            unset($this->TimeSpent);
        } else {
            $this->TimeSpent = $timeSpent;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\EventRelatedActivity
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
