<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventAttendee StructType
 * @subpackage Structs
 */
class EventAttendee extends Entity
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Comment;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Email;
    /**
     * The EventNoteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\GuidValue
     */
    public $EventNoteID;
    /**
     * The InvitationStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InvitationStatus;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Key;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Name;
    /**
     * The NameAttendeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $NameAttendeeName;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $Type;
    /**
     * Constructor method for EventAttendee
     * @uses EventAttendee::setComment()
     * @uses EventAttendee::setEmail()
     * @uses EventAttendee::setEventNoteID()
     * @uses EventAttendee::setInvitationStatus()
     * @uses EventAttendee::setKey()
     * @uses EventAttendee::setName()
     * @uses EventAttendee::setNameAttendeeName()
     * @uses EventAttendee::setType()
     * @param \App\API\SOAP\StructType\StringValue $comment
     * @param \App\API\SOAP\StructType\StringValue $email
     * @param \App\API\SOAP\StructType\GuidValue $eventNoteID
     * @param \App\API\SOAP\StructType\StringValue $invitationStatus
     * @param \App\API\SOAP\StructType\StringValue $key
     * @param \App\API\SOAP\StructType\StringValue $name
     * @param \App\API\SOAP\StructType\StringValue $nameAttendeeName
     * @param \App\API\SOAP\StructType\IntValue $type
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $comment = null, \App\API\SOAP\StructType\StringValue $email = null, \App\API\SOAP\StructType\GuidValue $eventNoteID = null, \App\API\SOAP\StructType\StringValue $invitationStatus = null, \App\API\SOAP\StructType\StringValue $key = null, \App\API\SOAP\StructType\StringValue $name = null, \App\API\SOAP\StructType\StringValue $nameAttendeeName = null, \App\API\SOAP\StructType\IntValue $type = null)
    {
        $this
            ->setComment($comment)
            ->setEmail($email)
            ->setEventNoteID($eventNoteID)
            ->setInvitationStatus($invitationStatus)
            ->setKey($key)
            ->setName($name)
            ->setNameAttendeeName($nameAttendeeName)
            ->setType($type);
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $comment
     * @return \App\API\SOAP\StructType\EventAttendee
     */
    public function setComment(\App\API\SOAP\StructType\StringValue $comment = null)
    {
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $email
     * @return \App\API\SOAP\StructType\EventAttendee
     */
    public function setEmail(\App\API\SOAP\StructType\StringValue $email = null)
    {
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get EventNoteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\GuidValue|null
     */
    public function getEventNoteID()
    {
        return isset($this->EventNoteID) ? $this->EventNoteID : null;
    }
    /**
     * Set EventNoteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\GuidValue $eventNoteID
     * @return \App\API\SOAP\StructType\EventAttendee
     */
    public function setEventNoteID(\App\API\SOAP\StructType\GuidValue $eventNoteID = null)
    {
        if (is_null($eventNoteID) || (is_array($eventNoteID) && empty($eventNoteID))) {
            unset($this->EventNoteID);
        } else {
            $this->EventNoteID = $eventNoteID;
        }
        return $this;
    }
    /**
     * Get InvitationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInvitationStatus()
    {
        return isset($this->InvitationStatus) ? $this->InvitationStatus : null;
    }
    /**
     * Set InvitationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $invitationStatus
     * @return \App\API\SOAP\StructType\EventAttendee
     */
    public function setInvitationStatus(\App\API\SOAP\StructType\StringValue $invitationStatus = null)
    {
        if (is_null($invitationStatus) || (is_array($invitationStatus) && empty($invitationStatus))) {
            unset($this->InvitationStatus);
        } else {
            $this->InvitationStatus = $invitationStatus;
        }
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $key
     * @return \App\API\SOAP\StructType\EventAttendee
     */
    public function setKey(\App\API\SOAP\StructType\StringValue $key = null)
    {
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $name
     * @return \App\API\SOAP\StructType\EventAttendee
     */
    public function setName(\App\API\SOAP\StructType\StringValue $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameAttendeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getNameAttendeeName()
    {
        return isset($this->NameAttendeeName) ? $this->NameAttendeeName : null;
    }
    /**
     * Set NameAttendeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $nameAttendeeName
     * @return \App\API\SOAP\StructType\EventAttendee
     */
    public function setNameAttendeeName(\App\API\SOAP\StructType\StringValue $nameAttendeeName = null)
    {
        if (is_null($nameAttendeeName) || (is_array($nameAttendeeName) && empty($nameAttendeeName))) {
            unset($this->NameAttendeeName);
        } else {
            $this->NameAttendeeName = $nameAttendeeName;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $type
     * @return \App\API\SOAP\StructType\EventAttendee
     */
    public function setType(\App\API\SOAP\StructType\IntValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
