<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Entity StructType
 * @subpackage Structs
 */
class Entity extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ID;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Delete;
    /**
     * The ReturnBehavior
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReturnBehavior;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\API\SOAP\StructType\LongValue
     */
    public $RowNumber;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\API\SOAP\ArrayType\ArrayOfCustomField
     */
    public $CustomFields;
    /**
     * Constructor method for Entity
     * @uses Entity::setID()
     * @uses Entity::setDelete()
     * @uses Entity::setReturnBehavior()
     * @uses Entity::setRowNumber()
     * @uses Entity::setNote()
     * @uses Entity::setCustomFields()
     * @param string $iD
     * @param bool $delete
     * @param string $returnBehavior
     * @param \App\API\SOAP\StructType\LongValue $rowNumber
     * @param string $note
     * @param \App\API\SOAP\ArrayType\ArrayOfCustomField $customFields
     */
    public function __construct($iD = null, $delete = null, $returnBehavior = null, \App\API\SOAP\StructType\LongValue $rowNumber = null, $note = null, \App\API\SOAP\ArrayType\ArrayOfCustomField $customFields = null)
    {
        $this
            ->setID($iD)
            ->setDelete($delete)
            ->setReturnBehavior($returnBehavior)
            ->setRowNumber($rowNumber)
            ->setNote($note)
            ->setCustomFields($customFields);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \App\API\SOAP\StructType\Entity
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($iD) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($iD, true)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \App\API\SOAP\StructType\Entity
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get ReturnBehavior value
     * @return string
     */
    public function getReturnBehavior()
    {
        return $this->ReturnBehavior;
    }
    /**
     * Set ReturnBehavior value
     * @uses \App\API\SOAP\EnumType\ReturnBehavior::valueIsValid()
     * @uses \App\API\SOAP\EnumType\ReturnBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $returnBehavior
     * @return \App\API\SOAP\StructType\Entity
     */
    public function setReturnBehavior($returnBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\App\API\SOAP\EnumType\ReturnBehavior::valueIsValid($returnBehavior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\API\SOAP\EnumType\ReturnBehavior', is_array($returnBehavior) ? implode(', ', $returnBehavior) : var_export($returnBehavior, true), implode(', ', \App\API\SOAP\EnumType\ReturnBehavior::getValidValues())), __LINE__);
        }
        $this->ReturnBehavior = $returnBehavior;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return \App\API\SOAP\StructType\LongValue|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param \App\API\SOAP\StructType\LongValue $rowNumber
     * @return \App\API\SOAP\StructType\Entity
     */
    public function setRowNumber(\App\API\SOAP\StructType\LongValue $rowNumber = null)
    {
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \App\API\SOAP\StructType\Entity
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \App\API\SOAP\ArrayType\ArrayOfCustomField|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \App\API\SOAP\ArrayType\ArrayOfCustomField $customFields
     * @return \App\API\SOAP\StructType\Entity
     */
    public function setCustomFields(\App\API\SOAP\ArrayType\ArrayOfCustomField $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
}
