<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employees StructType
 * @subpackage Structs
 */
class Employees extends AbstractStructBase
{
    /**
     * The ProjectEmployee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ProjectEmployee[]
     */
    public $ProjectEmployee;
    /**
     * Constructor method for Employees
     * @uses Employees::setProjectEmployee()
     * @param \App\API\SOAP\StructType\ProjectEmployee[] $projectEmployee
     */
    public function __construct(array $projectEmployee = array())
    {
        $this
            ->setProjectEmployee($projectEmployee);
    }
    /**
     * Get ProjectEmployee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ProjectEmployee[]|null
     */
    public function getProjectEmployee()
    {
        return isset($this->ProjectEmployee) ? $this->ProjectEmployee : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectEmployee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectEmployee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectEmployeeForArrayConstraintsFromSetProjectEmployee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employeesProjectEmployeeItem) {
            // validation for constraint: itemType
            if (!$employeesProjectEmployeeItem instanceof \App\API\SOAP\StructType\ProjectEmployee) {
                $invalidValues[] = is_object($employeesProjectEmployeeItem) ? get_class($employeesProjectEmployeeItem) : sprintf('%s(%s)', gettype($employeesProjectEmployeeItem), var_export($employeesProjectEmployeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProjectEmployee property can only contain items of type \App\API\SOAP\StructType\ProjectEmployee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProjectEmployee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectEmployee[] $projectEmployee
     * @return \App\API\SOAP\StructType\Employees
     */
    public function setProjectEmployee(array $projectEmployee = array())
    {
        // validation for constraint: array
        if ('' !== ($projectEmployeeArrayErrorMessage = self::validateProjectEmployeeForArrayConstraintsFromSetProjectEmployee($projectEmployee))) {
            throw new \InvalidArgumentException($projectEmployeeArrayErrorMessage, __LINE__);
        }
        if (is_null($projectEmployee) || (is_array($projectEmployee) && empty($projectEmployee))) {
            unset($this->ProjectEmployee);
        } else {
            $this->ProjectEmployee = $projectEmployee;
        }
        return $this;
    }
    /**
     * Add item to ProjectEmployee value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectEmployee $item
     * @return \App\API\SOAP\StructType\Employees
     */
    public function addToProjectEmployee(\App\API\SOAP\StructType\ProjectEmployee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ProjectEmployee) {
            throw new \InvalidArgumentException(sprintf('The ProjectEmployee property can only contain items of type \App\API\SOAP\StructType\ProjectEmployee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProjectEmployee[] = $item;
        return $this;
    }
}
