<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailProcessing StructType
 * @subpackage Structs
 */
class EmailProcessing extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $Account;
    /**
     * The AccountEmailAccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccountEmailAccountID;
    /**
     * The AssignedToMe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $AssignedToMe;
    /**
     * The AssignedToOwner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AssignedToOwner;
    /**
     * The IncludeFailed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $IncludeFailed;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Result
     */
    public $Result;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for EmailProcessing
     * @uses EmailProcessing::setAccount()
     * @uses EmailProcessing::setAccountEmailAccountID()
     * @uses EmailProcessing::setAssignedToMe()
     * @uses EmailProcessing::setAssignedToOwner()
     * @uses EmailProcessing::setIncludeFailed()
     * @uses EmailProcessing::setResult()
     * @uses EmailProcessing::setType()
     * @param \App\API\SOAP\StructType\IntValue $account
     * @param \App\API\SOAP\StructType\StringValue $accountEmailAccountID
     * @param \App\API\SOAP\StructType\BooleanValue $assignedToMe
     * @param \App\API\SOAP\StructType\StringValue $assignedToOwner
     * @param \App\API\SOAP\StructType\BooleanValue $includeFailed
     * @param \App\API\SOAP\StructType\Result $result
     * @param \App\API\SOAP\StructType\StringValue $type
     */
    public function __construct(\App\API\SOAP\StructType\IntValue $account = null, \App\API\SOAP\StructType\StringValue $accountEmailAccountID = null, \App\API\SOAP\StructType\BooleanValue $assignedToMe = null, \App\API\SOAP\StructType\StringValue $assignedToOwner = null, \App\API\SOAP\StructType\BooleanValue $includeFailed = null, \App\API\SOAP\StructType\Result $result = null, \App\API\SOAP\StructType\StringValue $type = null)
    {
        $this
            ->setAccount($account)
            ->setAccountEmailAccountID($accountEmailAccountID)
            ->setAssignedToMe($assignedToMe)
            ->setAssignedToOwner($assignedToOwner)
            ->setIncludeFailed($includeFailed)
            ->setResult($result)
            ->setType($type);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $account
     * @return \App\API\SOAP\StructType\EmailProcessing
     */
    public function setAccount(\App\API\SOAP\StructType\IntValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountEmailAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccountEmailAccountID()
    {
        return isset($this->AccountEmailAccountID) ? $this->AccountEmailAccountID : null;
    }
    /**
     * Set AccountEmailAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accountEmailAccountID
     * @return \App\API\SOAP\StructType\EmailProcessing
     */
    public function setAccountEmailAccountID(\App\API\SOAP\StructType\StringValue $accountEmailAccountID = null)
    {
        if (is_null($accountEmailAccountID) || (is_array($accountEmailAccountID) && empty($accountEmailAccountID))) {
            unset($this->AccountEmailAccountID);
        } else {
            $this->AccountEmailAccountID = $accountEmailAccountID;
        }
        return $this;
    }
    /**
     * Get AssignedToMe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getAssignedToMe()
    {
        return isset($this->AssignedToMe) ? $this->AssignedToMe : null;
    }
    /**
     * Set AssignedToMe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $assignedToMe
     * @return \App\API\SOAP\StructType\EmailProcessing
     */
    public function setAssignedToMe(\App\API\SOAP\StructType\BooleanValue $assignedToMe = null)
    {
        if (is_null($assignedToMe) || (is_array($assignedToMe) && empty($assignedToMe))) {
            unset($this->AssignedToMe);
        } else {
            $this->AssignedToMe = $assignedToMe;
        }
        return $this;
    }
    /**
     * Get AssignedToOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAssignedToOwner()
    {
        return isset($this->AssignedToOwner) ? $this->AssignedToOwner : null;
    }
    /**
     * Set AssignedToOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $assignedToOwner
     * @return \App\API\SOAP\StructType\EmailProcessing
     */
    public function setAssignedToOwner(\App\API\SOAP\StructType\StringValue $assignedToOwner = null)
    {
        if (is_null($assignedToOwner) || (is_array($assignedToOwner) && empty($assignedToOwner))) {
            unset($this->AssignedToOwner);
        } else {
            $this->AssignedToOwner = $assignedToOwner;
        }
        return $this;
    }
    /**
     * Get IncludeFailed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncludeFailed()
    {
        return isset($this->IncludeFailed) ? $this->IncludeFailed : null;
    }
    /**
     * Set IncludeFailed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $includeFailed
     * @return \App\API\SOAP\StructType\EmailProcessing
     */
    public function setIncludeFailed(\App\API\SOAP\StructType\BooleanValue $includeFailed = null)
    {
        if (is_null($includeFailed) || (is_array($includeFailed) && empty($includeFailed))) {
            unset($this->IncludeFailed);
        } else {
            $this->IncludeFailed = $includeFailed;
        }
        return $this;
    }
    /**
     * Get Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Result|null
     */
    public function getResult()
    {
        return isset($this->Result) ? $this->Result : null;
    }
    /**
     * Set Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Result $result
     * @return \App\API\SOAP\StructType\EmailProcessing
     */
    public function setResult(\App\API\SOAP\StructType\Result $result = null)
    {
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->Result);
        } else {
            $this->Result = $result;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\EmailProcessing
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
