<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Email StructType
 * @subpackage Structs
 */
class Email extends Entity
{
    /**
     * The Bcc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Bcc;
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Body;
    /**
     * The Cc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Cc;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $From;
    /**
     * The FromEmailAccountDisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FromEmailAccountDisplayName;
    /**
     * The FromEmailAccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $FromEmailAccountID;
    /**
     * The Incoming
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Incoming;
    /**
     * The Internal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Internal;
    /**
     * The MailStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $MailStatus;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Owner;
    /**
     * The Parent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\GuidValue
     */
    public $Parent;
    /**
     * The ParentSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ParentSummary;
    /**
     * The RelatedEntityDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $RelatedEntityDescription;
    /**
     * The StartTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $StartTime;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subject;
    /**
     * The TimeActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TimeActivity
     */
    public $TimeActivity;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $To;
    /**
     * The Workgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Workgroup;
    /**
     * Constructor method for Email
     * @uses Email::setBcc()
     * @uses Email::setBody()
     * @uses Email::setCc()
     * @uses Email::setDate()
     * @uses Email::setDescription()
     * @uses Email::setFrom()
     * @uses Email::setFromEmailAccountDisplayName()
     * @uses Email::setFromEmailAccountID()
     * @uses Email::setIncoming()
     * @uses Email::setInternal()
     * @uses Email::setMailStatus()
     * @uses Email::setOwner()
     * @uses Email::setParent()
     * @uses Email::setParentSummary()
     * @uses Email::setRelatedEntityDescription()
     * @uses Email::setStartTime()
     * @uses Email::setSubject()
     * @uses Email::setTimeActivity()
     * @uses Email::setTo()
     * @uses Email::setWorkgroup()
     * @param \App\API\SOAP\StructType\StringValue $bcc
     * @param \App\API\SOAP\StructType\StringValue $body
     * @param \App\API\SOAP\StructType\StringValue $cc
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $from
     * @param \App\API\SOAP\StructType\StringValue $fromEmailAccountDisplayName
     * @param \App\API\SOAP\StructType\IntValue $fromEmailAccountID
     * @param \App\API\SOAP\StructType\BooleanValue $incoming
     * @param \App\API\SOAP\StructType\BooleanValue $internal
     * @param \App\API\SOAP\StructType\StringValue $mailStatus
     * @param \App\API\SOAP\StructType\StringValue $owner
     * @param \App\API\SOAP\StructType\GuidValue $parent
     * @param \App\API\SOAP\StructType\StringValue $parentSummary
     * @param \App\API\SOAP\StructType\StringValue $relatedEntityDescription
     * @param \App\API\SOAP\StructType\DateTimeValue $startTime
     * @param \App\API\SOAP\StructType\StringValue $subject
     * @param \App\API\SOAP\StructType\TimeActivity $timeActivity
     * @param \App\API\SOAP\StructType\StringValue $to
     * @param \App\API\SOAP\StructType\StringValue $workgroup
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $bcc = null, \App\API\SOAP\StructType\StringValue $body = null, \App\API\SOAP\StructType\StringValue $cc = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $from = null, \App\API\SOAP\StructType\StringValue $fromEmailAccountDisplayName = null, \App\API\SOAP\StructType\IntValue $fromEmailAccountID = null, \App\API\SOAP\StructType\BooleanValue $incoming = null, \App\API\SOAP\StructType\BooleanValue $internal = null, \App\API\SOAP\StructType\StringValue $mailStatus = null, \App\API\SOAP\StructType\StringValue $owner = null, \App\API\SOAP\StructType\GuidValue $parent = null, \App\API\SOAP\StructType\StringValue $parentSummary = null, \App\API\SOAP\StructType\StringValue $relatedEntityDescription = null, \App\API\SOAP\StructType\DateTimeValue $startTime = null, \App\API\SOAP\StructType\StringValue $subject = null, \App\API\SOAP\StructType\TimeActivity $timeActivity = null, \App\API\SOAP\StructType\StringValue $to = null, \App\API\SOAP\StructType\StringValue $workgroup = null)
    {
        $this
            ->setBcc($bcc)
            ->setBody($body)
            ->setCc($cc)
            ->setDate($date)
            ->setDescription($description)
            ->setFrom($from)
            ->setFromEmailAccountDisplayName($fromEmailAccountDisplayName)
            ->setFromEmailAccountID($fromEmailAccountID)
            ->setIncoming($incoming)
            ->setInternal($internal)
            ->setMailStatus($mailStatus)
            ->setOwner($owner)
            ->setParent($parent)
            ->setParentSummary($parentSummary)
            ->setRelatedEntityDescription($relatedEntityDescription)
            ->setStartTime($startTime)
            ->setSubject($subject)
            ->setTimeActivity($timeActivity)
            ->setTo($to)
            ->setWorkgroup($workgroup);
    }
    /**
     * Get Bcc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBcc()
    {
        return isset($this->Bcc) ? $this->Bcc : null;
    }
    /**
     * Set Bcc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $bcc
     * @return \App\API\SOAP\StructType\Email
     */
    public function setBcc(\App\API\SOAP\StructType\StringValue $bcc = null)
    {
        if (is_null($bcc) || (is_array($bcc) && empty($bcc))) {
            unset($this->Bcc);
        } else {
            $this->Bcc = $bcc;
        }
        return $this;
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $body
     * @return \App\API\SOAP\StructType\Email
     */
    public function setBody(\App\API\SOAP\StructType\StringValue $body = null)
    {
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get Cc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCc()
    {
        return isset($this->Cc) ? $this->Cc : null;
    }
    /**
     * Set Cc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $cc
     * @return \App\API\SOAP\StructType\Email
     */
    public function setCc(\App\API\SOAP\StructType\StringValue $cc = null)
    {
        if (is_null($cc) || (is_array($cc) && empty($cc))) {
            unset($this->Cc);
        } else {
            $this->Cc = $cc;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\Email
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\Email
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get From value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFrom()
    {
        return isset($this->From) ? $this->From : null;
    }
    /**
     * Set From value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $from
     * @return \App\API\SOAP\StructType\Email
     */
    public function setFrom(\App\API\SOAP\StructType\StringValue $from = null)
    {
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->From);
        } else {
            $this->From = $from;
        }
        return $this;
    }
    /**
     * Get FromEmailAccountDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFromEmailAccountDisplayName()
    {
        return isset($this->FromEmailAccountDisplayName) ? $this->FromEmailAccountDisplayName : null;
    }
    /**
     * Set FromEmailAccountDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $fromEmailAccountDisplayName
     * @return \App\API\SOAP\StructType\Email
     */
    public function setFromEmailAccountDisplayName(\App\API\SOAP\StructType\StringValue $fromEmailAccountDisplayName = null)
    {
        if (is_null($fromEmailAccountDisplayName) || (is_array($fromEmailAccountDisplayName) && empty($fromEmailAccountDisplayName))) {
            unset($this->FromEmailAccountDisplayName);
        } else {
            $this->FromEmailAccountDisplayName = $fromEmailAccountDisplayName;
        }
        return $this;
    }
    /**
     * Get FromEmailAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getFromEmailAccountID()
    {
        return isset($this->FromEmailAccountID) ? $this->FromEmailAccountID : null;
    }
    /**
     * Set FromEmailAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $fromEmailAccountID
     * @return \App\API\SOAP\StructType\Email
     */
    public function setFromEmailAccountID(\App\API\SOAP\StructType\IntValue $fromEmailAccountID = null)
    {
        if (is_null($fromEmailAccountID) || (is_array($fromEmailAccountID) && empty($fromEmailAccountID))) {
            unset($this->FromEmailAccountID);
        } else {
            $this->FromEmailAccountID = $fromEmailAccountID;
        }
        return $this;
    }
    /**
     * Get Incoming value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getIncoming()
    {
        return isset($this->Incoming) ? $this->Incoming : null;
    }
    /**
     * Set Incoming value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $incoming
     * @return \App\API\SOAP\StructType\Email
     */
    public function setIncoming(\App\API\SOAP\StructType\BooleanValue $incoming = null)
    {
        if (is_null($incoming) || (is_array($incoming) && empty($incoming))) {
            unset($this->Incoming);
        } else {
            $this->Incoming = $incoming;
        }
        return $this;
    }
    /**
     * Get Internal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getInternal()
    {
        return isset($this->Internal) ? $this->Internal : null;
    }
    /**
     * Set Internal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $internal
     * @return \App\API\SOAP\StructType\Email
     */
    public function setInternal(\App\API\SOAP\StructType\BooleanValue $internal = null)
    {
        if (is_null($internal) || (is_array($internal) && empty($internal))) {
            unset($this->Internal);
        } else {
            $this->Internal = $internal;
        }
        return $this;
    }
    /**
     * Get MailStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getMailStatus()
    {
        return isset($this->MailStatus) ? $this->MailStatus : null;
    }
    /**
     * Set MailStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $mailStatus
     * @return \App\API\SOAP\StructType\Email
     */
    public function setMailStatus(\App\API\SOAP\StructType\StringValue $mailStatus = null)
    {
        if (is_null($mailStatus) || (is_array($mailStatus) && empty($mailStatus))) {
            unset($this->MailStatus);
        } else {
            $this->MailStatus = $mailStatus;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $owner
     * @return \App\API\SOAP\StructType\Email
     */
    public function setOwner(\App\API\SOAP\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\GuidValue|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\GuidValue $parent
     * @return \App\API\SOAP\StructType\Email
     */
    public function setParent(\App\API\SOAP\StructType\GuidValue $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getParentSummary()
    {
        return isset($this->ParentSummary) ? $this->ParentSummary : null;
    }
    /**
     * Set ParentSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $parentSummary
     * @return \App\API\SOAP\StructType\Email
     */
    public function setParentSummary(\App\API\SOAP\StructType\StringValue $parentSummary = null)
    {
        if (is_null($parentSummary) || (is_array($parentSummary) && empty($parentSummary))) {
            unset($this->ParentSummary);
        } else {
            $this->ParentSummary = $parentSummary;
        }
        return $this;
    }
    /**
     * Get RelatedEntityDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getRelatedEntityDescription()
    {
        return isset($this->RelatedEntityDescription) ? $this->RelatedEntityDescription : null;
    }
    /**
     * Set RelatedEntityDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $relatedEntityDescription
     * @return \App\API\SOAP\StructType\Email
     */
    public function setRelatedEntityDescription(\App\API\SOAP\StructType\StringValue $relatedEntityDescription = null)
    {
        if (is_null($relatedEntityDescription) || (is_array($relatedEntityDescription) && empty($relatedEntityDescription))) {
            unset($this->RelatedEntityDescription);
        } else {
            $this->RelatedEntityDescription = $relatedEntityDescription;
        }
        return $this;
    }
    /**
     * Get StartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getStartTime()
    {
        return isset($this->StartTime) ? $this->StartTime : null;
    }
    /**
     * Set StartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $startTime
     * @return \App\API\SOAP\StructType\Email
     */
    public function setStartTime(\App\API\SOAP\StructType\DateTimeValue $startTime = null)
    {
        if (is_null($startTime) || (is_array($startTime) && empty($startTime))) {
            unset($this->StartTime);
        } else {
            $this->StartTime = $startTime;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subject
     * @return \App\API\SOAP\StructType\Email
     */
    public function setSubject(\App\API\SOAP\StructType\StringValue $subject = null)
    {
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get TimeActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TimeActivity|null
     */
    public function getTimeActivity()
    {
        return isset($this->TimeActivity) ? $this->TimeActivity : null;
    }
    /**
     * Set TimeActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\TimeActivity $timeActivity
     * @return \App\API\SOAP\StructType\Email
     */
    public function setTimeActivity(\App\API\SOAP\StructType\TimeActivity $timeActivity = null)
    {
        if (is_null($timeActivity) || (is_array($timeActivity) && empty($timeActivity))) {
            unset($this->TimeActivity);
        } else {
            $this->TimeActivity = $timeActivity;
        }
        return $this;
    }
    /**
     * Get To value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTo()
    {
        return isset($this->To) ? $this->To : null;
    }
    /**
     * Set To value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $to
     * @return \App\API\SOAP\StructType\Email
     */
    public function setTo(\App\API\SOAP\StructType\StringValue $to = null)
    {
        if (is_null($to) || (is_array($to) && empty($to))) {
            unset($this->To);
        } else {
            $this->To = $to;
        }
        return $this;
    }
    /**
     * Get Workgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWorkgroup()
    {
        return isset($this->Workgroup) ? $this->Workgroup : null;
    }
    /**
     * Set Workgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $workgroup
     * @return \App\API\SOAP\StructType\Email
     */
    public function setWorkgroup(\App\API\SOAP\StructType\StringValue $workgroup = null)
    {
        if (is_null($workgroup) || (is_array($workgroup) && empty($workgroup))) {
            unset($this->Workgroup);
        } else {
            $this->Workgroup = $workgroup;
        }
        return $this;
    }
}
