<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Duplicates StructType
 * @subpackage Structs
 */
class Duplicates extends AbstractStructBase
{
    /**
     * The DuplicateDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DuplicateDetail[]
     */
    public $DuplicateDetail;
    /**
     * The ContactDuplicateDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ContactDuplicateDetail[]
     */
    public $ContactDuplicateDetail;
    /**
     * Constructor method for Duplicates
     * @uses Duplicates::setDuplicateDetail()
     * @uses Duplicates::setContactDuplicateDetail()
     * @param \App\API\SOAP\StructType\DuplicateDetail[] $duplicateDetail
     * @param \App\API\SOAP\StructType\ContactDuplicateDetail[] $contactDuplicateDetail
     */
    public function __construct(array $duplicateDetail = array(), array $contactDuplicateDetail = array())
    {
        $this
            ->setDuplicateDetail($duplicateDetail)
            ->setContactDuplicateDetail($contactDuplicateDetail);
    }
    /**
     * Get DuplicateDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DuplicateDetail[]|null
     */
    public function getDuplicateDetail()
    {
        return isset($this->DuplicateDetail) ? $this->DuplicateDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDuplicateDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuplicateDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDuplicateDetailForArrayConstraintsFromSetDuplicateDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $duplicatesDuplicateDetailItem) {
            // validation for constraint: itemType
            if (!$duplicatesDuplicateDetailItem instanceof \App\API\SOAP\StructType\DuplicateDetail) {
                $invalidValues[] = is_object($duplicatesDuplicateDetailItem) ? get_class($duplicatesDuplicateDetailItem) : sprintf('%s(%s)', gettype($duplicatesDuplicateDetailItem), var_export($duplicatesDuplicateDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DuplicateDetail property can only contain items of type \App\API\SOAP\StructType\DuplicateDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DuplicateDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\DuplicateDetail[] $duplicateDetail
     * @return \App\API\SOAP\StructType\Duplicates
     */
    public function setDuplicateDetail(array $duplicateDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($duplicateDetailArrayErrorMessage = self::validateDuplicateDetailForArrayConstraintsFromSetDuplicateDetail($duplicateDetail))) {
            throw new \InvalidArgumentException($duplicateDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($duplicateDetail) || (is_array($duplicateDetail) && empty($duplicateDetail))) {
            unset($this->DuplicateDetail);
        } else {
            $this->DuplicateDetail = $duplicateDetail;
        }
        return $this;
    }
    /**
     * Add item to DuplicateDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\DuplicateDetail $item
     * @return \App\API\SOAP\StructType\Duplicates
     */
    public function addToDuplicateDetail(\App\API\SOAP\StructType\DuplicateDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\DuplicateDetail) {
            throw new \InvalidArgumentException(sprintf('The DuplicateDetail property can only contain items of type \App\API\SOAP\StructType\DuplicateDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DuplicateDetail[] = $item;
        return $this;
    }
    /**
     * Get ContactDuplicateDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ContactDuplicateDetail[]|null
     */
    public function getContactDuplicateDetail()
    {
        return isset($this->ContactDuplicateDetail) ? $this->ContactDuplicateDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContactDuplicateDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactDuplicateDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactDuplicateDetailForArrayConstraintsFromSetContactDuplicateDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $duplicatesContactDuplicateDetailItem) {
            // validation for constraint: itemType
            if (!$duplicatesContactDuplicateDetailItem instanceof \App\API\SOAP\StructType\ContactDuplicateDetail) {
                $invalidValues[] = is_object($duplicatesContactDuplicateDetailItem) ? get_class($duplicatesContactDuplicateDetailItem) : sprintf('%s(%s)', gettype($duplicatesContactDuplicateDetailItem), var_export($duplicatesContactDuplicateDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactDuplicateDetail property can only contain items of type \App\API\SOAP\StructType\ContactDuplicateDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactDuplicateDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ContactDuplicateDetail[] $contactDuplicateDetail
     * @return \App\API\SOAP\StructType\Duplicates
     */
    public function setContactDuplicateDetail(array $contactDuplicateDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($contactDuplicateDetailArrayErrorMessage = self::validateContactDuplicateDetailForArrayConstraintsFromSetContactDuplicateDetail($contactDuplicateDetail))) {
            throw new \InvalidArgumentException($contactDuplicateDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($contactDuplicateDetail) || (is_array($contactDuplicateDetail) && empty($contactDuplicateDetail))) {
            unset($this->ContactDuplicateDetail);
        } else {
            $this->ContactDuplicateDetail = $contactDuplicateDetail;
        }
        return $this;
    }
    /**
     * Add item to ContactDuplicateDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ContactDuplicateDetail $item
     * @return \App\API\SOAP\StructType\Duplicates
     */
    public function addToContactDuplicateDetail(\App\API\SOAP\StructType\ContactDuplicateDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ContactDuplicateDetail) {
            throw new \InvalidArgumentException(sprintf('The ContactDuplicateDetail property can only contain items of type \App\API\SOAP\StructType\ContactDuplicateDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactDuplicateDetail[] = $item;
        return $this;
    }
}
