<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountDetails StructType
 * @subpackage Structs
 */
class DiscountDetails extends AbstractStructBase
{
    /**
     * The SalesOrdersDiscountDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesOrdersDiscountDetails[]
     */
    public $SalesOrdersDiscountDetails;
    /**
     * The InvoiceDiscountDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\InvoiceDiscountDetail[]
     */
    public $InvoiceDiscountDetail;
    /**
     * The SalesInvoiceDiscountDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesInvoiceDiscountDetails[]
     */
    public $SalesInvoiceDiscountDetails;
    /**
     * Constructor method for DiscountDetails
     * @uses DiscountDetails::setSalesOrdersDiscountDetails()
     * @uses DiscountDetails::setInvoiceDiscountDetail()
     * @uses DiscountDetails::setSalesInvoiceDiscountDetails()
     * @param \App\API\SOAP\StructType\SalesOrdersDiscountDetails[] $salesOrdersDiscountDetails
     * @param \App\API\SOAP\StructType\InvoiceDiscountDetail[] $invoiceDiscountDetail
     * @param \App\API\SOAP\StructType\SalesInvoiceDiscountDetails[] $salesInvoiceDiscountDetails
     */
    public function __construct(array $salesOrdersDiscountDetails = array(), array $invoiceDiscountDetail = array(), array $salesInvoiceDiscountDetails = array())
    {
        $this
            ->setSalesOrdersDiscountDetails($salesOrdersDiscountDetails)
            ->setInvoiceDiscountDetail($invoiceDiscountDetail)
            ->setSalesInvoiceDiscountDetails($salesInvoiceDiscountDetails);
    }
    /**
     * Get SalesOrdersDiscountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesOrdersDiscountDetails[]|null
     */
    public function getSalesOrdersDiscountDetails()
    {
        return isset($this->SalesOrdersDiscountDetails) ? $this->SalesOrdersDiscountDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesOrdersDiscountDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesOrdersDiscountDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesOrdersDiscountDetailsForArrayConstraintsFromSetSalesOrdersDiscountDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountDetailsSalesOrdersDiscountDetailsItem) {
            // validation for constraint: itemType
            if (!$discountDetailsSalesOrdersDiscountDetailsItem instanceof \App\API\SOAP\StructType\SalesOrdersDiscountDetails) {
                $invalidValues[] = is_object($discountDetailsSalesOrdersDiscountDetailsItem) ? get_class($discountDetailsSalesOrdersDiscountDetailsItem) : sprintf('%s(%s)', gettype($discountDetailsSalesOrdersDiscountDetailsItem), var_export($discountDetailsSalesOrdersDiscountDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesOrdersDiscountDetails property can only contain items of type \App\API\SOAP\StructType\SalesOrdersDiscountDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesOrdersDiscountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesOrdersDiscountDetails[] $salesOrdersDiscountDetails
     * @return \App\API\SOAP\StructType\DiscountDetails
     */
    public function setSalesOrdersDiscountDetails(array $salesOrdersDiscountDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($salesOrdersDiscountDetailsArrayErrorMessage = self::validateSalesOrdersDiscountDetailsForArrayConstraintsFromSetSalesOrdersDiscountDetails($salesOrdersDiscountDetails))) {
            throw new \InvalidArgumentException($salesOrdersDiscountDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($salesOrdersDiscountDetails) || (is_array($salesOrdersDiscountDetails) && empty($salesOrdersDiscountDetails))) {
            unset($this->SalesOrdersDiscountDetails);
        } else {
            $this->SalesOrdersDiscountDetails = $salesOrdersDiscountDetails;
        }
        return $this;
    }
    /**
     * Add item to SalesOrdersDiscountDetails value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesOrdersDiscountDetails $item
     * @return \App\API\SOAP\StructType\DiscountDetails
     */
    public function addToSalesOrdersDiscountDetails(\App\API\SOAP\StructType\SalesOrdersDiscountDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesOrdersDiscountDetails) {
            throw new \InvalidArgumentException(sprintf('The SalesOrdersDiscountDetails property can only contain items of type \App\API\SOAP\StructType\SalesOrdersDiscountDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesOrdersDiscountDetails[] = $item;
        return $this;
    }
    /**
     * Get InvoiceDiscountDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\InvoiceDiscountDetail[]|null
     */
    public function getInvoiceDiscountDetail()
    {
        return isset($this->InvoiceDiscountDetail) ? $this->InvoiceDiscountDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceDiscountDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceDiscountDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceDiscountDetailForArrayConstraintsFromSetInvoiceDiscountDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountDetailsInvoiceDiscountDetailItem) {
            // validation for constraint: itemType
            if (!$discountDetailsInvoiceDiscountDetailItem instanceof \App\API\SOAP\StructType\InvoiceDiscountDetail) {
                $invalidValues[] = is_object($discountDetailsInvoiceDiscountDetailItem) ? get_class($discountDetailsInvoiceDiscountDetailItem) : sprintf('%s(%s)', gettype($discountDetailsInvoiceDiscountDetailItem), var_export($discountDetailsInvoiceDiscountDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceDiscountDetail property can only contain items of type \App\API\SOAP\StructType\InvoiceDiscountDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceDiscountDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InvoiceDiscountDetail[] $invoiceDiscountDetail
     * @return \App\API\SOAP\StructType\DiscountDetails
     */
    public function setInvoiceDiscountDetail(array $invoiceDiscountDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceDiscountDetailArrayErrorMessage = self::validateInvoiceDiscountDetailForArrayConstraintsFromSetInvoiceDiscountDetail($invoiceDiscountDetail))) {
            throw new \InvalidArgumentException($invoiceDiscountDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceDiscountDetail) || (is_array($invoiceDiscountDetail) && empty($invoiceDiscountDetail))) {
            unset($this->InvoiceDiscountDetail);
        } else {
            $this->InvoiceDiscountDetail = $invoiceDiscountDetail;
        }
        return $this;
    }
    /**
     * Add item to InvoiceDiscountDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InvoiceDiscountDetail $item
     * @return \App\API\SOAP\StructType\DiscountDetails
     */
    public function addToInvoiceDiscountDetail(\App\API\SOAP\StructType\InvoiceDiscountDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\InvoiceDiscountDetail) {
            throw new \InvalidArgumentException(sprintf('The InvoiceDiscountDetail property can only contain items of type \App\API\SOAP\StructType\InvoiceDiscountDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceDiscountDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesInvoiceDiscountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesInvoiceDiscountDetails[]|null
     */
    public function getSalesInvoiceDiscountDetails()
    {
        return isset($this->SalesInvoiceDiscountDetails) ? $this->SalesInvoiceDiscountDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesInvoiceDiscountDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesInvoiceDiscountDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesInvoiceDiscountDetailsForArrayConstraintsFromSetSalesInvoiceDiscountDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountDetailsSalesInvoiceDiscountDetailsItem) {
            // validation for constraint: itemType
            if (!$discountDetailsSalesInvoiceDiscountDetailsItem instanceof \App\API\SOAP\StructType\SalesInvoiceDiscountDetails) {
                $invalidValues[] = is_object($discountDetailsSalesInvoiceDiscountDetailsItem) ? get_class($discountDetailsSalesInvoiceDiscountDetailsItem) : sprintf('%s(%s)', gettype($discountDetailsSalesInvoiceDiscountDetailsItem), var_export($discountDetailsSalesInvoiceDiscountDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesInvoiceDiscountDetails property can only contain items of type \App\API\SOAP\StructType\SalesInvoiceDiscountDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesInvoiceDiscountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesInvoiceDiscountDetails[] $salesInvoiceDiscountDetails
     * @return \App\API\SOAP\StructType\DiscountDetails
     */
    public function setSalesInvoiceDiscountDetails(array $salesInvoiceDiscountDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($salesInvoiceDiscountDetailsArrayErrorMessage = self::validateSalesInvoiceDiscountDetailsForArrayConstraintsFromSetSalesInvoiceDiscountDetails($salesInvoiceDiscountDetails))) {
            throw new \InvalidArgumentException($salesInvoiceDiscountDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($salesInvoiceDiscountDetails) || (is_array($salesInvoiceDiscountDetails) && empty($salesInvoiceDiscountDetails))) {
            unset($this->SalesInvoiceDiscountDetails);
        } else {
            $this->SalesInvoiceDiscountDetails = $salesInvoiceDiscountDetails;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceDiscountDetails value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesInvoiceDiscountDetails $item
     * @return \App\API\SOAP\StructType\DiscountDetails
     */
    public function addToSalesInvoiceDiscountDetails(\App\API\SOAP\StructType\SalesInvoiceDiscountDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesInvoiceDiscountDetails) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceDiscountDetails property can only contain items of type \App\API\SOAP\StructType\SalesInvoiceDiscountDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesInvoiceDiscountDetails[] = $item;
        return $this;
    }
}
