<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountCode StructType
 * @subpackage Structs
 */
class DiscountCode extends Entity
{
    /**
     * The ApplicableTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ApplicableTo;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The DiscountCodeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DiscountCodeID;
    /**
     * The DiscountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $DiscountType;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * Constructor method for DiscountCode
     * @uses DiscountCode::setApplicableTo()
     * @uses DiscountCode::setCreatedDateTime()
     * @uses DiscountCode::setDescription()
     * @uses DiscountCode::setDiscountCodeID()
     * @uses DiscountCode::setDiscountType()
     * @uses DiscountCode::setLastModifiedDateTime()
     * @param \App\API\SOAP\StructType\StringValue $applicableTo
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $discountCodeID
     * @param \App\API\SOAP\StructType\StringValue $discountType
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $applicableTo = null, \App\API\SOAP\StructType\DateTimeValue $createdDateTime = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $discountCodeID = null, \App\API\SOAP\StructType\StringValue $discountType = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        $this
            ->setApplicableTo($applicableTo)
            ->setCreatedDateTime($createdDateTime)
            ->setDescription($description)
            ->setDiscountCodeID($discountCodeID)
            ->setDiscountType($discountType)
            ->setLastModifiedDateTime($lastModifiedDateTime);
    }
    /**
     * Get ApplicableTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getApplicableTo()
    {
        return isset($this->ApplicableTo) ? $this->ApplicableTo : null;
    }
    /**
     * Set ApplicableTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $applicableTo
     * @return \App\API\SOAP\StructType\DiscountCode
     */
    public function setApplicableTo(\App\API\SOAP\StructType\StringValue $applicableTo = null)
    {
        if (is_null($applicableTo) || (is_array($applicableTo) && empty($applicableTo))) {
            unset($this->ApplicableTo);
        } else {
            $this->ApplicableTo = $applicableTo;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @return \App\API\SOAP\StructType\DiscountCode
     */
    public function setCreatedDateTime(\App\API\SOAP\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\DiscountCode
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DiscountCodeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDiscountCodeID()
    {
        return isset($this->DiscountCodeID) ? $this->DiscountCodeID : null;
    }
    /**
     * Set DiscountCodeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $discountCodeID
     * @return \App\API\SOAP\StructType\DiscountCode
     */
    public function setDiscountCodeID(\App\API\SOAP\StructType\StringValue $discountCodeID = null)
    {
        if (is_null($discountCodeID) || (is_array($discountCodeID) && empty($discountCodeID))) {
            unset($this->DiscountCodeID);
        } else {
            $this->DiscountCodeID = $discountCodeID;
        }
        return $this;
    }
    /**
     * Get DiscountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDiscountType()
    {
        return isset($this->DiscountType) ? $this->DiscountType : null;
    }
    /**
     * Set DiscountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $discountType
     * @return \App\API\SOAP\StructType\DiscountCode
     */
    public function setDiscountType(\App\API\SOAP\StructType\StringValue $discountType = null)
    {
        if (is_null($discountType) || (is_array($discountType) && empty($discountType))) {
            unset($this->DiscountType);
        } else {
            $this->DiscountType = $discountType;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\DiscountCode
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
}
