<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountBreakpoints StructType
 * @subpackage Structs
 */
class DiscountBreakpoints extends AbstractStructBase
{
    /**
     * The DiscountBreakpointDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DiscountBreakpointDetail[]
     */
    public $DiscountBreakpointDetail;
    /**
     * Constructor method for DiscountBreakpoints
     * @uses DiscountBreakpoints::setDiscountBreakpointDetail()
     * @param \App\API\SOAP\StructType\DiscountBreakpointDetail[] $discountBreakpointDetail
     */
    public function __construct(array $discountBreakpointDetail = array())
    {
        $this
            ->setDiscountBreakpointDetail($discountBreakpointDetail);
    }
    /**
     * Get DiscountBreakpointDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DiscountBreakpointDetail[]|null
     */
    public function getDiscountBreakpointDetail()
    {
        return isset($this->DiscountBreakpointDetail) ? $this->DiscountBreakpointDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountBreakpointDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountBreakpointDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountBreakpointDetailForArrayConstraintsFromSetDiscountBreakpointDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountBreakpointsDiscountBreakpointDetailItem) {
            // validation for constraint: itemType
            if (!$discountBreakpointsDiscountBreakpointDetailItem instanceof \App\API\SOAP\StructType\DiscountBreakpointDetail) {
                $invalidValues[] = is_object($discountBreakpointsDiscountBreakpointDetailItem) ? get_class($discountBreakpointsDiscountBreakpointDetailItem) : sprintf('%s(%s)', gettype($discountBreakpointsDiscountBreakpointDetailItem), var_export($discountBreakpointsDiscountBreakpointDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountBreakpointDetail property can only contain items of type \App\API\SOAP\StructType\DiscountBreakpointDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountBreakpointDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\DiscountBreakpointDetail[] $discountBreakpointDetail
     * @return \App\API\SOAP\StructType\DiscountBreakpoints
     */
    public function setDiscountBreakpointDetail(array $discountBreakpointDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($discountBreakpointDetailArrayErrorMessage = self::validateDiscountBreakpointDetailForArrayConstraintsFromSetDiscountBreakpointDetail($discountBreakpointDetail))) {
            throw new \InvalidArgumentException($discountBreakpointDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($discountBreakpointDetail) || (is_array($discountBreakpointDetail) && empty($discountBreakpointDetail))) {
            unset($this->DiscountBreakpointDetail);
        } else {
            $this->DiscountBreakpointDetail = $discountBreakpointDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountBreakpointDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\DiscountBreakpointDetail $item
     * @return \App\API\SOAP\StructType\DiscountBreakpoints
     */
    public function addToDiscountBreakpointDetail(\App\API\SOAP\StructType\DiscountBreakpointDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\DiscountBreakpointDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountBreakpointDetail property can only contain items of type \App\API\SOAP\StructType\DiscountBreakpointDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountBreakpointDetail[] = $item;
        return $this;
    }
}
