<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Details StructType
 * @subpackage Structs
 */
class Details extends AbstractStructBase
{
    /**
     * The ExpenseClaimDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ExpenseClaimDetails[]
     */
    public $ExpenseClaimDetails;
    /**
     * The CheckDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CheckDetail[]
     */
    public $CheckDetail;
    /**
     * The PhysicalInventoryCountDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\PhysicalInventoryCountDetail[]
     */
    public $PhysicalInventoryCountDetail;
    /**
     * The JournalVoucherDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\JournalVoucherDetail[]
     */
    public $JournalVoucherDetail;
    /**
     * The SalesOrderDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesOrderDetail[]
     */
    public $SalesOrderDetail;
    /**
     * The BillDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BillDetail[]
     */
    public $BillDetail;
    /**
     * The PurchaseReceiptDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\PurchaseReceiptDetail[]
     */
    public $PurchaseReceiptDetail;
    /**
     * The CashSaleDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CashSaleDetail[]
     */
    public $CashSaleDetail;
    /**
     * The CustomerPaymentMethodDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CustomerPaymentMethodDetail[]
     */
    public $CustomerPaymentMethodDetail;
    /**
     * The FinancialPeriodDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\FinancialPeriodDetail[]
     */
    public $FinancialPeriodDetail;
    /**
     * The TrialBalanceDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TrialBalanceDetail[]
     */
    public $TrialBalanceDetail;
    /**
     * The ShippingTermDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShippingTermDetail[]
     */
    public $ShippingTermDetail;
    /**
     * The ProjectBillingDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ProjectBillingDetails[]
     */
    public $ProjectBillingDetails;
    /**
     * The InvoiceDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\InvoiceDetail[]
     */
    public $InvoiceDetail;
    /**
     * The ManageFinancialPeriodsDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ManageFinancialPeriodsDetail[]
     */
    public $ManageFinancialPeriodsDetail;
    /**
     * The AdjustmentDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AdjustmentDetail[]
     */
    public $AdjustmentDetail;
    /**
     * The JournalTransactionDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\JournalTransactionDetail[]
     */
    public $JournalTransactionDetail;
    /**
     * The InventoryReceiptDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\InventoryReceiptDetail[]
     */
    public $InventoryReceiptDetail;
    /**
     * The SalesInvoiceDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\SalesInvoiceDetail[]
     */
    public $SalesInvoiceDetail;
    /**
     * The ShipmentDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShipmentDetail[]
     */
    public $ShipmentDetail;
    /**
     * The TaxCategoryTaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TaxCategoryTaxDetail[]
     */
    public $TaxCategoryTaxDetail;
    /**
     * The FinancialYearPeriodDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\FinancialYearPeriodDetail[]
     */
    public $FinancialYearPeriodDetail;
    /**
     * The ProjectTransactionDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ProjectTransactionDetail[]
     */
    public $ProjectTransactionDetail;
    /**
     * The TransferOrderDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\TransferOrderDetail[]
     */
    public $TransferOrderDetail;
    /**
     * The PurchaseOrderDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\PurchaseOrderDetail[]
     */
    public $PurchaseOrderDetail;
    /**
     * The PhysicalInventoryReviewDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\PhysicalInventoryReviewDetail[]
     */
    public $PhysicalInventoryReviewDetail;
    /**
     * Constructor method for Details
     * @uses Details::setExpenseClaimDetails()
     * @uses Details::setCheckDetail()
     * @uses Details::setPhysicalInventoryCountDetail()
     * @uses Details::setJournalVoucherDetail()
     * @uses Details::setSalesOrderDetail()
     * @uses Details::setBillDetail()
     * @uses Details::setPurchaseReceiptDetail()
     * @uses Details::setCashSaleDetail()
     * @uses Details::setCustomerPaymentMethodDetail()
     * @uses Details::setFinancialPeriodDetail()
     * @uses Details::setTrialBalanceDetail()
     * @uses Details::setShippingTermDetail()
     * @uses Details::setProjectBillingDetails()
     * @uses Details::setInvoiceDetail()
     * @uses Details::setManageFinancialPeriodsDetail()
     * @uses Details::setAdjustmentDetail()
     * @uses Details::setJournalTransactionDetail()
     * @uses Details::setInventoryReceiptDetail()
     * @uses Details::setSalesInvoiceDetail()
     * @uses Details::setShipmentDetail()
     * @uses Details::setTaxCategoryTaxDetail()
     * @uses Details::setFinancialYearPeriodDetail()
     * @uses Details::setProjectTransactionDetail()
     * @uses Details::setTransferOrderDetail()
     * @uses Details::setPurchaseOrderDetail()
     * @uses Details::setPhysicalInventoryReviewDetail()
     * @param \App\API\SOAP\StructType\ExpenseClaimDetails[] $expenseClaimDetails
     * @param \App\API\SOAP\StructType\CheckDetail[] $checkDetail
     * @param \App\API\SOAP\StructType\PhysicalInventoryCountDetail[] $physicalInventoryCountDetail
     * @param \App\API\SOAP\StructType\JournalVoucherDetail[] $journalVoucherDetail
     * @param \App\API\SOAP\StructType\SalesOrderDetail[] $salesOrderDetail
     * @param \App\API\SOAP\StructType\BillDetail[] $billDetail
     * @param \App\API\SOAP\StructType\PurchaseReceiptDetail[] $purchaseReceiptDetail
     * @param \App\API\SOAP\StructType\CashSaleDetail[] $cashSaleDetail
     * @param \App\API\SOAP\StructType\CustomerPaymentMethodDetail[] $customerPaymentMethodDetail
     * @param \App\API\SOAP\StructType\FinancialPeriodDetail[] $financialPeriodDetail
     * @param \App\API\SOAP\StructType\TrialBalanceDetail[] $trialBalanceDetail
     * @param \App\API\SOAP\StructType\ShippingTermDetail[] $shippingTermDetail
     * @param \App\API\SOAP\StructType\ProjectBillingDetails[] $projectBillingDetails
     * @param \App\API\SOAP\StructType\InvoiceDetail[] $invoiceDetail
     * @param \App\API\SOAP\StructType\ManageFinancialPeriodsDetail[] $manageFinancialPeriodsDetail
     * @param \App\API\SOAP\StructType\AdjustmentDetail[] $adjustmentDetail
     * @param \App\API\SOAP\StructType\JournalTransactionDetail[] $journalTransactionDetail
     * @param \App\API\SOAP\StructType\InventoryReceiptDetail[] $inventoryReceiptDetail
     * @param \App\API\SOAP\StructType\SalesInvoiceDetail[] $salesInvoiceDetail
     * @param \App\API\SOAP\StructType\ShipmentDetail[] $shipmentDetail
     * @param \App\API\SOAP\StructType\TaxCategoryTaxDetail[] $taxCategoryTaxDetail
     * @param \App\API\SOAP\StructType\FinancialYearPeriodDetail[] $financialYearPeriodDetail
     * @param \App\API\SOAP\StructType\ProjectTransactionDetail[] $projectTransactionDetail
     * @param \App\API\SOAP\StructType\TransferOrderDetail[] $transferOrderDetail
     * @param \App\API\SOAP\StructType\PurchaseOrderDetail[] $purchaseOrderDetail
     * @param \App\API\SOAP\StructType\PhysicalInventoryReviewDetail[] $physicalInventoryReviewDetail
     */
    public function __construct(array $expenseClaimDetails = array(), array $checkDetail = array(), array $physicalInventoryCountDetail = array(), array $journalVoucherDetail = array(), array $salesOrderDetail = array(), array $billDetail = array(), array $purchaseReceiptDetail = array(), array $cashSaleDetail = array(), array $customerPaymentMethodDetail = array(), array $financialPeriodDetail = array(), array $trialBalanceDetail = array(), array $shippingTermDetail = array(), array $projectBillingDetails = array(), array $invoiceDetail = array(), array $manageFinancialPeriodsDetail = array(), array $adjustmentDetail = array(), array $journalTransactionDetail = array(), array $inventoryReceiptDetail = array(), array $salesInvoiceDetail = array(), array $shipmentDetail = array(), array $taxCategoryTaxDetail = array(), array $financialYearPeriodDetail = array(), array $projectTransactionDetail = array(), array $transferOrderDetail = array(), array $purchaseOrderDetail = array(), array $physicalInventoryReviewDetail = array())
    {
        $this
            ->setExpenseClaimDetails($expenseClaimDetails)
            ->setCheckDetail($checkDetail)
            ->setPhysicalInventoryCountDetail($physicalInventoryCountDetail)
            ->setJournalVoucherDetail($journalVoucherDetail)
            ->setSalesOrderDetail($salesOrderDetail)
            ->setBillDetail($billDetail)
            ->setPurchaseReceiptDetail($purchaseReceiptDetail)
            ->setCashSaleDetail($cashSaleDetail)
            ->setCustomerPaymentMethodDetail($customerPaymentMethodDetail)
            ->setFinancialPeriodDetail($financialPeriodDetail)
            ->setTrialBalanceDetail($trialBalanceDetail)
            ->setShippingTermDetail($shippingTermDetail)
            ->setProjectBillingDetails($projectBillingDetails)
            ->setInvoiceDetail($invoiceDetail)
            ->setManageFinancialPeriodsDetail($manageFinancialPeriodsDetail)
            ->setAdjustmentDetail($adjustmentDetail)
            ->setJournalTransactionDetail($journalTransactionDetail)
            ->setInventoryReceiptDetail($inventoryReceiptDetail)
            ->setSalesInvoiceDetail($salesInvoiceDetail)
            ->setShipmentDetail($shipmentDetail)
            ->setTaxCategoryTaxDetail($taxCategoryTaxDetail)
            ->setFinancialYearPeriodDetail($financialYearPeriodDetail)
            ->setProjectTransactionDetail($projectTransactionDetail)
            ->setTransferOrderDetail($transferOrderDetail)
            ->setPurchaseOrderDetail($purchaseOrderDetail)
            ->setPhysicalInventoryReviewDetail($physicalInventoryReviewDetail);
    }
    /**
     * Get ExpenseClaimDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ExpenseClaimDetails[]|null
     */
    public function getExpenseClaimDetails()
    {
        return isset($this->ExpenseClaimDetails) ? $this->ExpenseClaimDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExpenseClaimDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpenseClaimDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseClaimDetailsForArrayConstraintsFromSetExpenseClaimDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsExpenseClaimDetailsItem) {
            // validation for constraint: itemType
            if (!$detailsExpenseClaimDetailsItem instanceof \App\API\SOAP\StructType\ExpenseClaimDetails) {
                $invalidValues[] = is_object($detailsExpenseClaimDetailsItem) ? get_class($detailsExpenseClaimDetailsItem) : sprintf('%s(%s)', gettype($detailsExpenseClaimDetailsItem), var_export($detailsExpenseClaimDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExpenseClaimDetails property can only contain items of type \App\API\SOAP\StructType\ExpenseClaimDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExpenseClaimDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ExpenseClaimDetails[] $expenseClaimDetails
     * @return \App\API\SOAP\StructType\Details
     */
    public function setExpenseClaimDetails(array $expenseClaimDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseClaimDetailsArrayErrorMessage = self::validateExpenseClaimDetailsForArrayConstraintsFromSetExpenseClaimDetails($expenseClaimDetails))) {
            throw new \InvalidArgumentException($expenseClaimDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($expenseClaimDetails) || (is_array($expenseClaimDetails) && empty($expenseClaimDetails))) {
            unset($this->ExpenseClaimDetails);
        } else {
            $this->ExpenseClaimDetails = $expenseClaimDetails;
        }
        return $this;
    }
    /**
     * Add item to ExpenseClaimDetails value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ExpenseClaimDetails $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToExpenseClaimDetails(\App\API\SOAP\StructType\ExpenseClaimDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ExpenseClaimDetails) {
            throw new \InvalidArgumentException(sprintf('The ExpenseClaimDetails property can only contain items of type \App\API\SOAP\StructType\ExpenseClaimDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExpenseClaimDetails[] = $item;
        return $this;
    }
    /**
     * Get CheckDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CheckDetail[]|null
     */
    public function getCheckDetail()
    {
        return isset($this->CheckDetail) ? $this->CheckDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCheckDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCheckDetailForArrayConstraintsFromSetCheckDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsCheckDetailItem) {
            // validation for constraint: itemType
            if (!$detailsCheckDetailItem instanceof \App\API\SOAP\StructType\CheckDetail) {
                $invalidValues[] = is_object($detailsCheckDetailItem) ? get_class($detailsCheckDetailItem) : sprintf('%s(%s)', gettype($detailsCheckDetailItem), var_export($detailsCheckDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CheckDetail property can only contain items of type \App\API\SOAP\StructType\CheckDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CheckDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CheckDetail[] $checkDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setCheckDetail(array $checkDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($checkDetailArrayErrorMessage = self::validateCheckDetailForArrayConstraintsFromSetCheckDetail($checkDetail))) {
            throw new \InvalidArgumentException($checkDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($checkDetail) || (is_array($checkDetail) && empty($checkDetail))) {
            unset($this->CheckDetail);
        } else {
            $this->CheckDetail = $checkDetail;
        }
        return $this;
    }
    /**
     * Add item to CheckDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CheckDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToCheckDetail(\App\API\SOAP\StructType\CheckDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\CheckDetail) {
            throw new \InvalidArgumentException(sprintf('The CheckDetail property can only contain items of type \App\API\SOAP\StructType\CheckDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CheckDetail[] = $item;
        return $this;
    }
    /**
     * Get PhysicalInventoryCountDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\PhysicalInventoryCountDetail[]|null
     */
    public function getPhysicalInventoryCountDetail()
    {
        return isset($this->PhysicalInventoryCountDetail) ? $this->PhysicalInventoryCountDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPhysicalInventoryCountDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhysicalInventoryCountDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhysicalInventoryCountDetailForArrayConstraintsFromSetPhysicalInventoryCountDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsPhysicalInventoryCountDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPhysicalInventoryCountDetailItem instanceof \App\API\SOAP\StructType\PhysicalInventoryCountDetail) {
                $invalidValues[] = is_object($detailsPhysicalInventoryCountDetailItem) ? get_class($detailsPhysicalInventoryCountDetailItem) : sprintf('%s(%s)', gettype($detailsPhysicalInventoryCountDetailItem), var_export($detailsPhysicalInventoryCountDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhysicalInventoryCountDetail property can only contain items of type \App\API\SOAP\StructType\PhysicalInventoryCountDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhysicalInventoryCountDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PhysicalInventoryCountDetail[] $physicalInventoryCountDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setPhysicalInventoryCountDetail(array $physicalInventoryCountDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($physicalInventoryCountDetailArrayErrorMessage = self::validatePhysicalInventoryCountDetailForArrayConstraintsFromSetPhysicalInventoryCountDetail($physicalInventoryCountDetail))) {
            throw new \InvalidArgumentException($physicalInventoryCountDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($physicalInventoryCountDetail) || (is_array($physicalInventoryCountDetail) && empty($physicalInventoryCountDetail))) {
            unset($this->PhysicalInventoryCountDetail);
        } else {
            $this->PhysicalInventoryCountDetail = $physicalInventoryCountDetail;
        }
        return $this;
    }
    /**
     * Add item to PhysicalInventoryCountDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PhysicalInventoryCountDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToPhysicalInventoryCountDetail(\App\API\SOAP\StructType\PhysicalInventoryCountDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\PhysicalInventoryCountDetail) {
            throw new \InvalidArgumentException(sprintf('The PhysicalInventoryCountDetail property can only contain items of type \App\API\SOAP\StructType\PhysicalInventoryCountDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhysicalInventoryCountDetail[] = $item;
        return $this;
    }
    /**
     * Get JournalVoucherDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\JournalVoucherDetail[]|null
     */
    public function getJournalVoucherDetail()
    {
        return isset($this->JournalVoucherDetail) ? $this->JournalVoucherDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJournalVoucherDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJournalVoucherDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJournalVoucherDetailForArrayConstraintsFromSetJournalVoucherDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsJournalVoucherDetailItem) {
            // validation for constraint: itemType
            if (!$detailsJournalVoucherDetailItem instanceof \App\API\SOAP\StructType\JournalVoucherDetail) {
                $invalidValues[] = is_object($detailsJournalVoucherDetailItem) ? get_class($detailsJournalVoucherDetailItem) : sprintf('%s(%s)', gettype($detailsJournalVoucherDetailItem), var_export($detailsJournalVoucherDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JournalVoucherDetail property can only contain items of type \App\API\SOAP\StructType\JournalVoucherDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JournalVoucherDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\JournalVoucherDetail[] $journalVoucherDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setJournalVoucherDetail(array $journalVoucherDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($journalVoucherDetailArrayErrorMessage = self::validateJournalVoucherDetailForArrayConstraintsFromSetJournalVoucherDetail($journalVoucherDetail))) {
            throw new \InvalidArgumentException($journalVoucherDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($journalVoucherDetail) || (is_array($journalVoucherDetail) && empty($journalVoucherDetail))) {
            unset($this->JournalVoucherDetail);
        } else {
            $this->JournalVoucherDetail = $journalVoucherDetail;
        }
        return $this;
    }
    /**
     * Add item to JournalVoucherDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\JournalVoucherDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToJournalVoucherDetail(\App\API\SOAP\StructType\JournalVoucherDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\JournalVoucherDetail) {
            throw new \InvalidArgumentException(sprintf('The JournalVoucherDetail property can only contain items of type \App\API\SOAP\StructType\JournalVoucherDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JournalVoucherDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesOrderDetail[]|null
     */
    public function getSalesOrderDetail()
    {
        return isset($this->SalesOrderDetail) ? $this->SalesOrderDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesOrderDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesOrderDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesOrderDetailForArrayConstraintsFromSetSalesOrderDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsSalesOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsSalesOrderDetailItem instanceof \App\API\SOAP\StructType\SalesOrderDetail) {
                $invalidValues[] = is_object($detailsSalesOrderDetailItem) ? get_class($detailsSalesOrderDetailItem) : sprintf('%s(%s)', gettype($detailsSalesOrderDetailItem), var_export($detailsSalesOrderDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesOrderDetail property can only contain items of type \App\API\SOAP\StructType\SalesOrderDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesOrderDetail[] $salesOrderDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setSalesOrderDetail(array $salesOrderDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($salesOrderDetailArrayErrorMessage = self::validateSalesOrderDetailForArrayConstraintsFromSetSalesOrderDetail($salesOrderDetail))) {
            throw new \InvalidArgumentException($salesOrderDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($salesOrderDetail) || (is_array($salesOrderDetail) && empty($salesOrderDetail))) {
            unset($this->SalesOrderDetail);
        } else {
            $this->SalesOrderDetail = $salesOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesOrderDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesOrderDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToSalesOrderDetail(\App\API\SOAP\StructType\SalesOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesOrderDetail property can only contain items of type \App\API\SOAP\StructType\SalesOrderDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get BillDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BillDetail[]|null
     */
    public function getBillDetail()
    {
        return isset($this->BillDetail) ? $this->BillDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBillDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillDetailForArrayConstraintsFromSetBillDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsBillDetailItem) {
            // validation for constraint: itemType
            if (!$detailsBillDetailItem instanceof \App\API\SOAP\StructType\BillDetail) {
                $invalidValues[] = is_object($detailsBillDetailItem) ? get_class($detailsBillDetailItem) : sprintf('%s(%s)', gettype($detailsBillDetailItem), var_export($detailsBillDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillDetail property can only contain items of type \App\API\SOAP\StructType\BillDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BillDetail[] $billDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setBillDetail(array $billDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($billDetailArrayErrorMessage = self::validateBillDetailForArrayConstraintsFromSetBillDetail($billDetail))) {
            throw new \InvalidArgumentException($billDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($billDetail) || (is_array($billDetail) && empty($billDetail))) {
            unset($this->BillDetail);
        } else {
            $this->BillDetail = $billDetail;
        }
        return $this;
    }
    /**
     * Add item to BillDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BillDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToBillDetail(\App\API\SOAP\StructType\BillDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\BillDetail) {
            throw new \InvalidArgumentException(sprintf('The BillDetail property can only contain items of type \App\API\SOAP\StructType\BillDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillDetail[] = $item;
        return $this;
    }
    /**
     * Get PurchaseReceiptDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\PurchaseReceiptDetail[]|null
     */
    public function getPurchaseReceiptDetail()
    {
        return isset($this->PurchaseReceiptDetail) ? $this->PurchaseReceiptDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseReceiptDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseReceiptDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseReceiptDetailForArrayConstraintsFromSetPurchaseReceiptDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsPurchaseReceiptDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPurchaseReceiptDetailItem instanceof \App\API\SOAP\StructType\PurchaseReceiptDetail) {
                $invalidValues[] = is_object($detailsPurchaseReceiptDetailItem) ? get_class($detailsPurchaseReceiptDetailItem) : sprintf('%s(%s)', gettype($detailsPurchaseReceiptDetailItem), var_export($detailsPurchaseReceiptDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseReceiptDetail property can only contain items of type \App\API\SOAP\StructType\PurchaseReceiptDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseReceiptDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PurchaseReceiptDetail[] $purchaseReceiptDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setPurchaseReceiptDetail(array $purchaseReceiptDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseReceiptDetailArrayErrorMessage = self::validatePurchaseReceiptDetailForArrayConstraintsFromSetPurchaseReceiptDetail($purchaseReceiptDetail))) {
            throw new \InvalidArgumentException($purchaseReceiptDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($purchaseReceiptDetail) || (is_array($purchaseReceiptDetail) && empty($purchaseReceiptDetail))) {
            unset($this->PurchaseReceiptDetail);
        } else {
            $this->PurchaseReceiptDetail = $purchaseReceiptDetail;
        }
        return $this;
    }
    /**
     * Add item to PurchaseReceiptDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PurchaseReceiptDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToPurchaseReceiptDetail(\App\API\SOAP\StructType\PurchaseReceiptDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\PurchaseReceiptDetail) {
            throw new \InvalidArgumentException(sprintf('The PurchaseReceiptDetail property can only contain items of type \App\API\SOAP\StructType\PurchaseReceiptDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseReceiptDetail[] = $item;
        return $this;
    }
    /**
     * Get CashSaleDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CashSaleDetail[]|null
     */
    public function getCashSaleDetail()
    {
        return isset($this->CashSaleDetail) ? $this->CashSaleDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCashSaleDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCashSaleDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCashSaleDetailForArrayConstraintsFromSetCashSaleDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsCashSaleDetailItem) {
            // validation for constraint: itemType
            if (!$detailsCashSaleDetailItem instanceof \App\API\SOAP\StructType\CashSaleDetail) {
                $invalidValues[] = is_object($detailsCashSaleDetailItem) ? get_class($detailsCashSaleDetailItem) : sprintf('%s(%s)', gettype($detailsCashSaleDetailItem), var_export($detailsCashSaleDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CashSaleDetail property can only contain items of type \App\API\SOAP\StructType\CashSaleDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CashSaleDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CashSaleDetail[] $cashSaleDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setCashSaleDetail(array $cashSaleDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($cashSaleDetailArrayErrorMessage = self::validateCashSaleDetailForArrayConstraintsFromSetCashSaleDetail($cashSaleDetail))) {
            throw new \InvalidArgumentException($cashSaleDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($cashSaleDetail) || (is_array($cashSaleDetail) && empty($cashSaleDetail))) {
            unset($this->CashSaleDetail);
        } else {
            $this->CashSaleDetail = $cashSaleDetail;
        }
        return $this;
    }
    /**
     * Add item to CashSaleDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CashSaleDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToCashSaleDetail(\App\API\SOAP\StructType\CashSaleDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\CashSaleDetail) {
            throw new \InvalidArgumentException(sprintf('The CashSaleDetail property can only contain items of type \App\API\SOAP\StructType\CashSaleDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CashSaleDetail[] = $item;
        return $this;
    }
    /**
     * Get CustomerPaymentMethodDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CustomerPaymentMethodDetail[]|null
     */
    public function getCustomerPaymentMethodDetail()
    {
        return isset($this->CustomerPaymentMethodDetail) ? $this->CustomerPaymentMethodDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerPaymentMethodDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerPaymentMethodDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerPaymentMethodDetailForArrayConstraintsFromSetCustomerPaymentMethodDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsCustomerPaymentMethodDetailItem) {
            // validation for constraint: itemType
            if (!$detailsCustomerPaymentMethodDetailItem instanceof \App\API\SOAP\StructType\CustomerPaymentMethodDetail) {
                $invalidValues[] = is_object($detailsCustomerPaymentMethodDetailItem) ? get_class($detailsCustomerPaymentMethodDetailItem) : sprintf('%s(%s)', gettype($detailsCustomerPaymentMethodDetailItem), var_export($detailsCustomerPaymentMethodDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerPaymentMethodDetail property can only contain items of type \App\API\SOAP\StructType\CustomerPaymentMethodDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerPaymentMethodDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CustomerPaymentMethodDetail[] $customerPaymentMethodDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setCustomerPaymentMethodDetail(array $customerPaymentMethodDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customerPaymentMethodDetailArrayErrorMessage = self::validateCustomerPaymentMethodDetailForArrayConstraintsFromSetCustomerPaymentMethodDetail($customerPaymentMethodDetail))) {
            throw new \InvalidArgumentException($customerPaymentMethodDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($customerPaymentMethodDetail) || (is_array($customerPaymentMethodDetail) && empty($customerPaymentMethodDetail))) {
            unset($this->CustomerPaymentMethodDetail);
        } else {
            $this->CustomerPaymentMethodDetail = $customerPaymentMethodDetail;
        }
        return $this;
    }
    /**
     * Add item to CustomerPaymentMethodDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CustomerPaymentMethodDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToCustomerPaymentMethodDetail(\App\API\SOAP\StructType\CustomerPaymentMethodDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\CustomerPaymentMethodDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomerPaymentMethodDetail property can only contain items of type \App\API\SOAP\StructType\CustomerPaymentMethodDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerPaymentMethodDetail[] = $item;
        return $this;
    }
    /**
     * Get FinancialPeriodDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\FinancialPeriodDetail[]|null
     */
    public function getFinancialPeriodDetail()
    {
        return isset($this->FinancialPeriodDetail) ? $this->FinancialPeriodDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFinancialPeriodDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinancialPeriodDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFinancialPeriodDetailForArrayConstraintsFromSetFinancialPeriodDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsFinancialPeriodDetailItem) {
            // validation for constraint: itemType
            if (!$detailsFinancialPeriodDetailItem instanceof \App\API\SOAP\StructType\FinancialPeriodDetail) {
                $invalidValues[] = is_object($detailsFinancialPeriodDetailItem) ? get_class($detailsFinancialPeriodDetailItem) : sprintf('%s(%s)', gettype($detailsFinancialPeriodDetailItem), var_export($detailsFinancialPeriodDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FinancialPeriodDetail property can only contain items of type \App\API\SOAP\StructType\FinancialPeriodDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FinancialPeriodDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\FinancialPeriodDetail[] $financialPeriodDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setFinancialPeriodDetail(array $financialPeriodDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($financialPeriodDetailArrayErrorMessage = self::validateFinancialPeriodDetailForArrayConstraintsFromSetFinancialPeriodDetail($financialPeriodDetail))) {
            throw new \InvalidArgumentException($financialPeriodDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($financialPeriodDetail) || (is_array($financialPeriodDetail) && empty($financialPeriodDetail))) {
            unset($this->FinancialPeriodDetail);
        } else {
            $this->FinancialPeriodDetail = $financialPeriodDetail;
        }
        return $this;
    }
    /**
     * Add item to FinancialPeriodDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\FinancialPeriodDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToFinancialPeriodDetail(\App\API\SOAP\StructType\FinancialPeriodDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\FinancialPeriodDetail) {
            throw new \InvalidArgumentException(sprintf('The FinancialPeriodDetail property can only contain items of type \App\API\SOAP\StructType\FinancialPeriodDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FinancialPeriodDetail[] = $item;
        return $this;
    }
    /**
     * Get TrialBalanceDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TrialBalanceDetail[]|null
     */
    public function getTrialBalanceDetail()
    {
        return isset($this->TrialBalanceDetail) ? $this->TrialBalanceDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTrialBalanceDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrialBalanceDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrialBalanceDetailForArrayConstraintsFromSetTrialBalanceDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsTrialBalanceDetailItem) {
            // validation for constraint: itemType
            if (!$detailsTrialBalanceDetailItem instanceof \App\API\SOAP\StructType\TrialBalanceDetail) {
                $invalidValues[] = is_object($detailsTrialBalanceDetailItem) ? get_class($detailsTrialBalanceDetailItem) : sprintf('%s(%s)', gettype($detailsTrialBalanceDetailItem), var_export($detailsTrialBalanceDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrialBalanceDetail property can only contain items of type \App\API\SOAP\StructType\TrialBalanceDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrialBalanceDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TrialBalanceDetail[] $trialBalanceDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setTrialBalanceDetail(array $trialBalanceDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($trialBalanceDetailArrayErrorMessage = self::validateTrialBalanceDetailForArrayConstraintsFromSetTrialBalanceDetail($trialBalanceDetail))) {
            throw new \InvalidArgumentException($trialBalanceDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($trialBalanceDetail) || (is_array($trialBalanceDetail) && empty($trialBalanceDetail))) {
            unset($this->TrialBalanceDetail);
        } else {
            $this->TrialBalanceDetail = $trialBalanceDetail;
        }
        return $this;
    }
    /**
     * Add item to TrialBalanceDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TrialBalanceDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToTrialBalanceDetail(\App\API\SOAP\StructType\TrialBalanceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\TrialBalanceDetail) {
            throw new \InvalidArgumentException(sprintf('The TrialBalanceDetail property can only contain items of type \App\API\SOAP\StructType\TrialBalanceDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrialBalanceDetail[] = $item;
        return $this;
    }
    /**
     * Get ShippingTermDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShippingTermDetail[]|null
     */
    public function getShippingTermDetail()
    {
        return isset($this->ShippingTermDetail) ? $this->ShippingTermDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingTermDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingTermDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingTermDetailForArrayConstraintsFromSetShippingTermDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsShippingTermDetailItem) {
            // validation for constraint: itemType
            if (!$detailsShippingTermDetailItem instanceof \App\API\SOAP\StructType\ShippingTermDetail) {
                $invalidValues[] = is_object($detailsShippingTermDetailItem) ? get_class($detailsShippingTermDetailItem) : sprintf('%s(%s)', gettype($detailsShippingTermDetailItem), var_export($detailsShippingTermDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShippingTermDetail property can only contain items of type \App\API\SOAP\StructType\ShippingTermDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShippingTermDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShippingTermDetail[] $shippingTermDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setShippingTermDetail(array $shippingTermDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingTermDetailArrayErrorMessage = self::validateShippingTermDetailForArrayConstraintsFromSetShippingTermDetail($shippingTermDetail))) {
            throw new \InvalidArgumentException($shippingTermDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($shippingTermDetail) || (is_array($shippingTermDetail) && empty($shippingTermDetail))) {
            unset($this->ShippingTermDetail);
        } else {
            $this->ShippingTermDetail = $shippingTermDetail;
        }
        return $this;
    }
    /**
     * Add item to ShippingTermDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShippingTermDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToShippingTermDetail(\App\API\SOAP\StructType\ShippingTermDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ShippingTermDetail) {
            throw new \InvalidArgumentException(sprintf('The ShippingTermDetail property can only contain items of type \App\API\SOAP\StructType\ShippingTermDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShippingTermDetail[] = $item;
        return $this;
    }
    /**
     * Get ProjectBillingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ProjectBillingDetails[]|null
     */
    public function getProjectBillingDetails()
    {
        return isset($this->ProjectBillingDetails) ? $this->ProjectBillingDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectBillingDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectBillingDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectBillingDetailsForArrayConstraintsFromSetProjectBillingDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsProjectBillingDetailsItem) {
            // validation for constraint: itemType
            if (!$detailsProjectBillingDetailsItem instanceof \App\API\SOAP\StructType\ProjectBillingDetails) {
                $invalidValues[] = is_object($detailsProjectBillingDetailsItem) ? get_class($detailsProjectBillingDetailsItem) : sprintf('%s(%s)', gettype($detailsProjectBillingDetailsItem), var_export($detailsProjectBillingDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProjectBillingDetails property can only contain items of type \App\API\SOAP\StructType\ProjectBillingDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProjectBillingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectBillingDetails[] $projectBillingDetails
     * @return \App\API\SOAP\StructType\Details
     */
    public function setProjectBillingDetails(array $projectBillingDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($projectBillingDetailsArrayErrorMessage = self::validateProjectBillingDetailsForArrayConstraintsFromSetProjectBillingDetails($projectBillingDetails))) {
            throw new \InvalidArgumentException($projectBillingDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($projectBillingDetails) || (is_array($projectBillingDetails) && empty($projectBillingDetails))) {
            unset($this->ProjectBillingDetails);
        } else {
            $this->ProjectBillingDetails = $projectBillingDetails;
        }
        return $this;
    }
    /**
     * Add item to ProjectBillingDetails value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectBillingDetails $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToProjectBillingDetails(\App\API\SOAP\StructType\ProjectBillingDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ProjectBillingDetails) {
            throw new \InvalidArgumentException(sprintf('The ProjectBillingDetails property can only contain items of type \App\API\SOAP\StructType\ProjectBillingDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProjectBillingDetails[] = $item;
        return $this;
    }
    /**
     * Get InvoiceDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\InvoiceDetail[]|null
     */
    public function getInvoiceDetail()
    {
        return isset($this->InvoiceDetail) ? $this->InvoiceDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceDetailForArrayConstraintsFromSetInvoiceDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsInvoiceDetailItem) {
            // validation for constraint: itemType
            if (!$detailsInvoiceDetailItem instanceof \App\API\SOAP\StructType\InvoiceDetail) {
                $invalidValues[] = is_object($detailsInvoiceDetailItem) ? get_class($detailsInvoiceDetailItem) : sprintf('%s(%s)', gettype($detailsInvoiceDetailItem), var_export($detailsInvoiceDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceDetail property can only contain items of type \App\API\SOAP\StructType\InvoiceDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InvoiceDetail[] $invoiceDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setInvoiceDetail(array $invoiceDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceDetailArrayErrorMessage = self::validateInvoiceDetailForArrayConstraintsFromSetInvoiceDetail($invoiceDetail))) {
            throw new \InvalidArgumentException($invoiceDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceDetail) || (is_array($invoiceDetail) && empty($invoiceDetail))) {
            unset($this->InvoiceDetail);
        } else {
            $this->InvoiceDetail = $invoiceDetail;
        }
        return $this;
    }
    /**
     * Add item to InvoiceDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InvoiceDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToInvoiceDetail(\App\API\SOAP\StructType\InvoiceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\InvoiceDetail) {
            throw new \InvalidArgumentException(sprintf('The InvoiceDetail property can only contain items of type \App\API\SOAP\StructType\InvoiceDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceDetail[] = $item;
        return $this;
    }
    /**
     * Get ManageFinancialPeriodsDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ManageFinancialPeriodsDetail[]|null
     */
    public function getManageFinancialPeriodsDetail()
    {
        return isset($this->ManageFinancialPeriodsDetail) ? $this->ManageFinancialPeriodsDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setManageFinancialPeriodsDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManageFinancialPeriodsDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManageFinancialPeriodsDetailForArrayConstraintsFromSetManageFinancialPeriodsDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsManageFinancialPeriodsDetailItem) {
            // validation for constraint: itemType
            if (!$detailsManageFinancialPeriodsDetailItem instanceof \App\API\SOAP\StructType\ManageFinancialPeriodsDetail) {
                $invalidValues[] = is_object($detailsManageFinancialPeriodsDetailItem) ? get_class($detailsManageFinancialPeriodsDetailItem) : sprintf('%s(%s)', gettype($detailsManageFinancialPeriodsDetailItem), var_export($detailsManageFinancialPeriodsDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ManageFinancialPeriodsDetail property can only contain items of type \App\API\SOAP\StructType\ManageFinancialPeriodsDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ManageFinancialPeriodsDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ManageFinancialPeriodsDetail[] $manageFinancialPeriodsDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setManageFinancialPeriodsDetail(array $manageFinancialPeriodsDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($manageFinancialPeriodsDetailArrayErrorMessage = self::validateManageFinancialPeriodsDetailForArrayConstraintsFromSetManageFinancialPeriodsDetail($manageFinancialPeriodsDetail))) {
            throw new \InvalidArgumentException($manageFinancialPeriodsDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($manageFinancialPeriodsDetail) || (is_array($manageFinancialPeriodsDetail) && empty($manageFinancialPeriodsDetail))) {
            unset($this->ManageFinancialPeriodsDetail);
        } else {
            $this->ManageFinancialPeriodsDetail = $manageFinancialPeriodsDetail;
        }
        return $this;
    }
    /**
     * Add item to ManageFinancialPeriodsDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ManageFinancialPeriodsDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToManageFinancialPeriodsDetail(\App\API\SOAP\StructType\ManageFinancialPeriodsDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ManageFinancialPeriodsDetail) {
            throw new \InvalidArgumentException(sprintf('The ManageFinancialPeriodsDetail property can only contain items of type \App\API\SOAP\StructType\ManageFinancialPeriodsDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ManageFinancialPeriodsDetail[] = $item;
        return $this;
    }
    /**
     * Get AdjustmentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AdjustmentDetail[]|null
     */
    public function getAdjustmentDetail()
    {
        return isset($this->AdjustmentDetail) ? $this->AdjustmentDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdjustmentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdjustmentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdjustmentDetailForArrayConstraintsFromSetAdjustmentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsAdjustmentDetailItem) {
            // validation for constraint: itemType
            if (!$detailsAdjustmentDetailItem instanceof \App\API\SOAP\StructType\AdjustmentDetail) {
                $invalidValues[] = is_object($detailsAdjustmentDetailItem) ? get_class($detailsAdjustmentDetailItem) : sprintf('%s(%s)', gettype($detailsAdjustmentDetailItem), var_export($detailsAdjustmentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdjustmentDetail property can only contain items of type \App\API\SOAP\StructType\AdjustmentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdjustmentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AdjustmentDetail[] $adjustmentDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setAdjustmentDetail(array $adjustmentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($adjustmentDetailArrayErrorMessage = self::validateAdjustmentDetailForArrayConstraintsFromSetAdjustmentDetail($adjustmentDetail))) {
            throw new \InvalidArgumentException($adjustmentDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($adjustmentDetail) || (is_array($adjustmentDetail) && empty($adjustmentDetail))) {
            unset($this->AdjustmentDetail);
        } else {
            $this->AdjustmentDetail = $adjustmentDetail;
        }
        return $this;
    }
    /**
     * Add item to AdjustmentDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AdjustmentDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToAdjustmentDetail(\App\API\SOAP\StructType\AdjustmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\AdjustmentDetail) {
            throw new \InvalidArgumentException(sprintf('The AdjustmentDetail property can only contain items of type \App\API\SOAP\StructType\AdjustmentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdjustmentDetail[] = $item;
        return $this;
    }
    /**
     * Get JournalTransactionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\JournalTransactionDetail[]|null
     */
    public function getJournalTransactionDetail()
    {
        return isset($this->JournalTransactionDetail) ? $this->JournalTransactionDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJournalTransactionDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJournalTransactionDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJournalTransactionDetailForArrayConstraintsFromSetJournalTransactionDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsJournalTransactionDetailItem) {
            // validation for constraint: itemType
            if (!$detailsJournalTransactionDetailItem instanceof \App\API\SOAP\StructType\JournalTransactionDetail) {
                $invalidValues[] = is_object($detailsJournalTransactionDetailItem) ? get_class($detailsJournalTransactionDetailItem) : sprintf('%s(%s)', gettype($detailsJournalTransactionDetailItem), var_export($detailsJournalTransactionDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JournalTransactionDetail property can only contain items of type \App\API\SOAP\StructType\JournalTransactionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JournalTransactionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\JournalTransactionDetail[] $journalTransactionDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setJournalTransactionDetail(array $journalTransactionDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($journalTransactionDetailArrayErrorMessage = self::validateJournalTransactionDetailForArrayConstraintsFromSetJournalTransactionDetail($journalTransactionDetail))) {
            throw new \InvalidArgumentException($journalTransactionDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($journalTransactionDetail) || (is_array($journalTransactionDetail) && empty($journalTransactionDetail))) {
            unset($this->JournalTransactionDetail);
        } else {
            $this->JournalTransactionDetail = $journalTransactionDetail;
        }
        return $this;
    }
    /**
     * Add item to JournalTransactionDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\JournalTransactionDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToJournalTransactionDetail(\App\API\SOAP\StructType\JournalTransactionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\JournalTransactionDetail) {
            throw new \InvalidArgumentException(sprintf('The JournalTransactionDetail property can only contain items of type \App\API\SOAP\StructType\JournalTransactionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JournalTransactionDetail[] = $item;
        return $this;
    }
    /**
     * Get InventoryReceiptDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\InventoryReceiptDetail[]|null
     */
    public function getInventoryReceiptDetail()
    {
        return isset($this->InventoryReceiptDetail) ? $this->InventoryReceiptDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryReceiptDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryReceiptDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryReceiptDetailForArrayConstraintsFromSetInventoryReceiptDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsInventoryReceiptDetailItem) {
            // validation for constraint: itemType
            if (!$detailsInventoryReceiptDetailItem instanceof \App\API\SOAP\StructType\InventoryReceiptDetail) {
                $invalidValues[] = is_object($detailsInventoryReceiptDetailItem) ? get_class($detailsInventoryReceiptDetailItem) : sprintf('%s(%s)', gettype($detailsInventoryReceiptDetailItem), var_export($detailsInventoryReceiptDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InventoryReceiptDetail property can only contain items of type \App\API\SOAP\StructType\InventoryReceiptDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InventoryReceiptDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventoryReceiptDetail[] $inventoryReceiptDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setInventoryReceiptDetail(array $inventoryReceiptDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryReceiptDetailArrayErrorMessage = self::validateInventoryReceiptDetailForArrayConstraintsFromSetInventoryReceiptDetail($inventoryReceiptDetail))) {
            throw new \InvalidArgumentException($inventoryReceiptDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($inventoryReceiptDetail) || (is_array($inventoryReceiptDetail) && empty($inventoryReceiptDetail))) {
            unset($this->InventoryReceiptDetail);
        } else {
            $this->InventoryReceiptDetail = $inventoryReceiptDetail;
        }
        return $this;
    }
    /**
     * Add item to InventoryReceiptDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventoryReceiptDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToInventoryReceiptDetail(\App\API\SOAP\StructType\InventoryReceiptDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\InventoryReceiptDetail) {
            throw new \InvalidArgumentException(sprintf('The InventoryReceiptDetail property can only contain items of type \App\API\SOAP\StructType\InventoryReceiptDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InventoryReceiptDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesInvoiceDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\SalesInvoiceDetail[]|null
     */
    public function getSalesInvoiceDetail()
    {
        return isset($this->SalesInvoiceDetail) ? $this->SalesInvoiceDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesInvoiceDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesInvoiceDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesInvoiceDetailForArrayConstraintsFromSetSalesInvoiceDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsSalesInvoiceDetailItem) {
            // validation for constraint: itemType
            if (!$detailsSalesInvoiceDetailItem instanceof \App\API\SOAP\StructType\SalesInvoiceDetail) {
                $invalidValues[] = is_object($detailsSalesInvoiceDetailItem) ? get_class($detailsSalesInvoiceDetailItem) : sprintf('%s(%s)', gettype($detailsSalesInvoiceDetailItem), var_export($detailsSalesInvoiceDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesInvoiceDetail property can only contain items of type \App\API\SOAP\StructType\SalesInvoiceDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesInvoiceDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesInvoiceDetail[] $salesInvoiceDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setSalesInvoiceDetail(array $salesInvoiceDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($salesInvoiceDetailArrayErrorMessage = self::validateSalesInvoiceDetailForArrayConstraintsFromSetSalesInvoiceDetail($salesInvoiceDetail))) {
            throw new \InvalidArgumentException($salesInvoiceDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($salesInvoiceDetail) || (is_array($salesInvoiceDetail) && empty($salesInvoiceDetail))) {
            unset($this->SalesInvoiceDetail);
        } else {
            $this->SalesInvoiceDetail = $salesInvoiceDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\SalesInvoiceDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToSalesInvoiceDetail(\App\API\SOAP\StructType\SalesInvoiceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\SalesInvoiceDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceDetail property can only contain items of type \App\API\SOAP\StructType\SalesInvoiceDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesInvoiceDetail[] = $item;
        return $this;
    }
    /**
     * Get ShipmentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShipmentDetail[]|null
     */
    public function getShipmentDetail()
    {
        return isset($this->ShipmentDetail) ? $this->ShipmentDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentDetailForArrayConstraintsFromSetShipmentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsShipmentDetailItem) {
            // validation for constraint: itemType
            if (!$detailsShipmentDetailItem instanceof \App\API\SOAP\StructType\ShipmentDetail) {
                $invalidValues[] = is_object($detailsShipmentDetailItem) ? get_class($detailsShipmentDetailItem) : sprintf('%s(%s)', gettype($detailsShipmentDetailItem), var_export($detailsShipmentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentDetail property can only contain items of type \App\API\SOAP\StructType\ShipmentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShipmentDetail[] $shipmentDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setShipmentDetail(array $shipmentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentDetailArrayErrorMessage = self::validateShipmentDetailForArrayConstraintsFromSetShipmentDetail($shipmentDetail))) {
            throw new \InvalidArgumentException($shipmentDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($shipmentDetail) || (is_array($shipmentDetail) && empty($shipmentDetail))) {
            unset($this->ShipmentDetail);
        } else {
            $this->ShipmentDetail = $shipmentDetail;
        }
        return $this;
    }
    /**
     * Add item to ShipmentDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ShipmentDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToShipmentDetail(\App\API\SOAP\StructType\ShipmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ShipmentDetail) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDetail property can only contain items of type \App\API\SOAP\StructType\ShipmentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentDetail[] = $item;
        return $this;
    }
    /**
     * Get TaxCategoryTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TaxCategoryTaxDetail[]|null
     */
    public function getTaxCategoryTaxDetail()
    {
        return isset($this->TaxCategoryTaxDetail) ? $this->TaxCategoryTaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCategoryTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCategoryTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxCategoryTaxDetailForArrayConstraintsFromSetTaxCategoryTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsTaxCategoryTaxDetailItem) {
            // validation for constraint: itemType
            if (!$detailsTaxCategoryTaxDetailItem instanceof \App\API\SOAP\StructType\TaxCategoryTaxDetail) {
                $invalidValues[] = is_object($detailsTaxCategoryTaxDetailItem) ? get_class($detailsTaxCategoryTaxDetailItem) : sprintf('%s(%s)', gettype($detailsTaxCategoryTaxDetailItem), var_export($detailsTaxCategoryTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCategoryTaxDetail property can only contain items of type \App\API\SOAP\StructType\TaxCategoryTaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCategoryTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TaxCategoryTaxDetail[] $taxCategoryTaxDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setTaxCategoryTaxDetail(array $taxCategoryTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($taxCategoryTaxDetailArrayErrorMessage = self::validateTaxCategoryTaxDetailForArrayConstraintsFromSetTaxCategoryTaxDetail($taxCategoryTaxDetail))) {
            throw new \InvalidArgumentException($taxCategoryTaxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($taxCategoryTaxDetail) || (is_array($taxCategoryTaxDetail) && empty($taxCategoryTaxDetail))) {
            unset($this->TaxCategoryTaxDetail);
        } else {
            $this->TaxCategoryTaxDetail = $taxCategoryTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to TaxCategoryTaxDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TaxCategoryTaxDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToTaxCategoryTaxDetail(\App\API\SOAP\StructType\TaxCategoryTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\TaxCategoryTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxCategoryTaxDetail property can only contain items of type \App\API\SOAP\StructType\TaxCategoryTaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCategoryTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get FinancialYearPeriodDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\FinancialYearPeriodDetail[]|null
     */
    public function getFinancialYearPeriodDetail()
    {
        return isset($this->FinancialYearPeriodDetail) ? $this->FinancialYearPeriodDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFinancialYearPeriodDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinancialYearPeriodDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFinancialYearPeriodDetailForArrayConstraintsFromSetFinancialYearPeriodDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsFinancialYearPeriodDetailItem) {
            // validation for constraint: itemType
            if (!$detailsFinancialYearPeriodDetailItem instanceof \App\API\SOAP\StructType\FinancialYearPeriodDetail) {
                $invalidValues[] = is_object($detailsFinancialYearPeriodDetailItem) ? get_class($detailsFinancialYearPeriodDetailItem) : sprintf('%s(%s)', gettype($detailsFinancialYearPeriodDetailItem), var_export($detailsFinancialYearPeriodDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FinancialYearPeriodDetail property can only contain items of type \App\API\SOAP\StructType\FinancialYearPeriodDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FinancialYearPeriodDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\FinancialYearPeriodDetail[] $financialYearPeriodDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setFinancialYearPeriodDetail(array $financialYearPeriodDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($financialYearPeriodDetailArrayErrorMessage = self::validateFinancialYearPeriodDetailForArrayConstraintsFromSetFinancialYearPeriodDetail($financialYearPeriodDetail))) {
            throw new \InvalidArgumentException($financialYearPeriodDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($financialYearPeriodDetail) || (is_array($financialYearPeriodDetail) && empty($financialYearPeriodDetail))) {
            unset($this->FinancialYearPeriodDetail);
        } else {
            $this->FinancialYearPeriodDetail = $financialYearPeriodDetail;
        }
        return $this;
    }
    /**
     * Add item to FinancialYearPeriodDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\FinancialYearPeriodDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToFinancialYearPeriodDetail(\App\API\SOAP\StructType\FinancialYearPeriodDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\FinancialYearPeriodDetail) {
            throw new \InvalidArgumentException(sprintf('The FinancialYearPeriodDetail property can only contain items of type \App\API\SOAP\StructType\FinancialYearPeriodDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FinancialYearPeriodDetail[] = $item;
        return $this;
    }
    /**
     * Get ProjectTransactionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ProjectTransactionDetail[]|null
     */
    public function getProjectTransactionDetail()
    {
        return isset($this->ProjectTransactionDetail) ? $this->ProjectTransactionDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectTransactionDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectTransactionDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectTransactionDetailForArrayConstraintsFromSetProjectTransactionDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsProjectTransactionDetailItem) {
            // validation for constraint: itemType
            if (!$detailsProjectTransactionDetailItem instanceof \App\API\SOAP\StructType\ProjectTransactionDetail) {
                $invalidValues[] = is_object($detailsProjectTransactionDetailItem) ? get_class($detailsProjectTransactionDetailItem) : sprintf('%s(%s)', gettype($detailsProjectTransactionDetailItem), var_export($detailsProjectTransactionDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProjectTransactionDetail property can only contain items of type \App\API\SOAP\StructType\ProjectTransactionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProjectTransactionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectTransactionDetail[] $projectTransactionDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setProjectTransactionDetail(array $projectTransactionDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($projectTransactionDetailArrayErrorMessage = self::validateProjectTransactionDetailForArrayConstraintsFromSetProjectTransactionDetail($projectTransactionDetail))) {
            throw new \InvalidArgumentException($projectTransactionDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($projectTransactionDetail) || (is_array($projectTransactionDetail) && empty($projectTransactionDetail))) {
            unset($this->ProjectTransactionDetail);
        } else {
            $this->ProjectTransactionDetail = $projectTransactionDetail;
        }
        return $this;
    }
    /**
     * Add item to ProjectTransactionDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ProjectTransactionDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToProjectTransactionDetail(\App\API\SOAP\StructType\ProjectTransactionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ProjectTransactionDetail) {
            throw new \InvalidArgumentException(sprintf('The ProjectTransactionDetail property can only contain items of type \App\API\SOAP\StructType\ProjectTransactionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProjectTransactionDetail[] = $item;
        return $this;
    }
    /**
     * Get TransferOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\TransferOrderDetail[]|null
     */
    public function getTransferOrderDetail()
    {
        return isset($this->TransferOrderDetail) ? $this->TransferOrderDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTransferOrderDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransferOrderDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransferOrderDetailForArrayConstraintsFromSetTransferOrderDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsTransferOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsTransferOrderDetailItem instanceof \App\API\SOAP\StructType\TransferOrderDetail) {
                $invalidValues[] = is_object($detailsTransferOrderDetailItem) ? get_class($detailsTransferOrderDetailItem) : sprintf('%s(%s)', gettype($detailsTransferOrderDetailItem), var_export($detailsTransferOrderDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransferOrderDetail property can only contain items of type \App\API\SOAP\StructType\TransferOrderDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransferOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TransferOrderDetail[] $transferOrderDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setTransferOrderDetail(array $transferOrderDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($transferOrderDetailArrayErrorMessage = self::validateTransferOrderDetailForArrayConstraintsFromSetTransferOrderDetail($transferOrderDetail))) {
            throw new \InvalidArgumentException($transferOrderDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($transferOrderDetail) || (is_array($transferOrderDetail) && empty($transferOrderDetail))) {
            unset($this->TransferOrderDetail);
        } else {
            $this->TransferOrderDetail = $transferOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to TransferOrderDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\TransferOrderDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToTransferOrderDetail(\App\API\SOAP\StructType\TransferOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\TransferOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The TransferOrderDetail property can only contain items of type \App\API\SOAP\StructType\TransferOrderDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransferOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get PurchaseOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\PurchaseOrderDetail[]|null
     */
    public function getPurchaseOrderDetail()
    {
        return isset($this->PurchaseOrderDetail) ? $this->PurchaseOrderDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseOrderDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseOrderDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseOrderDetailForArrayConstraintsFromSetPurchaseOrderDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsPurchaseOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPurchaseOrderDetailItem instanceof \App\API\SOAP\StructType\PurchaseOrderDetail) {
                $invalidValues[] = is_object($detailsPurchaseOrderDetailItem) ? get_class($detailsPurchaseOrderDetailItem) : sprintf('%s(%s)', gettype($detailsPurchaseOrderDetailItem), var_export($detailsPurchaseOrderDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseOrderDetail property can only contain items of type \App\API\SOAP\StructType\PurchaseOrderDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PurchaseOrderDetail[] $purchaseOrderDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setPurchaseOrderDetail(array $purchaseOrderDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseOrderDetailArrayErrorMessage = self::validatePurchaseOrderDetailForArrayConstraintsFromSetPurchaseOrderDetail($purchaseOrderDetail))) {
            throw new \InvalidArgumentException($purchaseOrderDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($purchaseOrderDetail) || (is_array($purchaseOrderDetail) && empty($purchaseOrderDetail))) {
            unset($this->PurchaseOrderDetail);
        } else {
            $this->PurchaseOrderDetail = $purchaseOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to PurchaseOrderDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PurchaseOrderDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToPurchaseOrderDetail(\App\API\SOAP\StructType\PurchaseOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\PurchaseOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The PurchaseOrderDetail property can only contain items of type \App\API\SOAP\StructType\PurchaseOrderDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get PhysicalInventoryReviewDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\PhysicalInventoryReviewDetail[]|null
     */
    public function getPhysicalInventoryReviewDetail()
    {
        return isset($this->PhysicalInventoryReviewDetail) ? $this->PhysicalInventoryReviewDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPhysicalInventoryReviewDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhysicalInventoryReviewDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhysicalInventoryReviewDetailForArrayConstraintsFromSetPhysicalInventoryReviewDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailsPhysicalInventoryReviewDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPhysicalInventoryReviewDetailItem instanceof \App\API\SOAP\StructType\PhysicalInventoryReviewDetail) {
                $invalidValues[] = is_object($detailsPhysicalInventoryReviewDetailItem) ? get_class($detailsPhysicalInventoryReviewDetailItem) : sprintf('%s(%s)', gettype($detailsPhysicalInventoryReviewDetailItem), var_export($detailsPhysicalInventoryReviewDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhysicalInventoryReviewDetail property can only contain items of type \App\API\SOAP\StructType\PhysicalInventoryReviewDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhysicalInventoryReviewDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PhysicalInventoryReviewDetail[] $physicalInventoryReviewDetail
     * @return \App\API\SOAP\StructType\Details
     */
    public function setPhysicalInventoryReviewDetail(array $physicalInventoryReviewDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($physicalInventoryReviewDetailArrayErrorMessage = self::validatePhysicalInventoryReviewDetailForArrayConstraintsFromSetPhysicalInventoryReviewDetail($physicalInventoryReviewDetail))) {
            throw new \InvalidArgumentException($physicalInventoryReviewDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($physicalInventoryReviewDetail) || (is_array($physicalInventoryReviewDetail) && empty($physicalInventoryReviewDetail))) {
            unset($this->PhysicalInventoryReviewDetail);
        } else {
            $this->PhysicalInventoryReviewDetail = $physicalInventoryReviewDetail;
        }
        return $this;
    }
    /**
     * Add item to PhysicalInventoryReviewDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\PhysicalInventoryReviewDetail $item
     * @return \App\API\SOAP\StructType\Details
     */
    public function addToPhysicalInventoryReviewDetail(\App\API\SOAP\StructType\PhysicalInventoryReviewDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\PhysicalInventoryReviewDetail) {
            throw new \InvalidArgumentException(sprintf('The PhysicalInventoryReviewDetail property can only contain items of type \App\API\SOAP\StructType\PhysicalInventoryReviewDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhysicalInventoryReviewDetail[] = $item;
        return $this;
    }
}
