<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Delegates StructType
 * @subpackage Structs
 */
class Delegates extends AbstractStructBase
{
    /**
     * The EmployeeDelegate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\EmployeeDelegate[]
     */
    public $EmployeeDelegate;
    /**
     * Constructor method for Delegates
     * @uses Delegates::setEmployeeDelegate()
     * @param \App\API\SOAP\StructType\EmployeeDelegate[] $employeeDelegate
     */
    public function __construct(array $employeeDelegate = array())
    {
        $this
            ->setEmployeeDelegate($employeeDelegate);
    }
    /**
     * Get EmployeeDelegate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\EmployeeDelegate[]|null
     */
    public function getEmployeeDelegate()
    {
        return isset($this->EmployeeDelegate) ? $this->EmployeeDelegate : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeDelegate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeDelegate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeDelegateForArrayConstraintsFromSetEmployeeDelegate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $delegatesEmployeeDelegateItem) {
            // validation for constraint: itemType
            if (!$delegatesEmployeeDelegateItem instanceof \App\API\SOAP\StructType\EmployeeDelegate) {
                $invalidValues[] = is_object($delegatesEmployeeDelegateItem) ? get_class($delegatesEmployeeDelegateItem) : sprintf('%s(%s)', gettype($delegatesEmployeeDelegateItem), var_export($delegatesEmployeeDelegateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployeeDelegate property can only contain items of type \App\API\SOAP\StructType\EmployeeDelegate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployeeDelegate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\EmployeeDelegate[] $employeeDelegate
     * @return \App\API\SOAP\StructType\Delegates
     */
    public function setEmployeeDelegate(array $employeeDelegate = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeDelegateArrayErrorMessage = self::validateEmployeeDelegateForArrayConstraintsFromSetEmployeeDelegate($employeeDelegate))) {
            throw new \InvalidArgumentException($employeeDelegateArrayErrorMessage, __LINE__);
        }
        if (is_null($employeeDelegate) || (is_array($employeeDelegate) && empty($employeeDelegate))) {
            unset($this->EmployeeDelegate);
        } else {
            $this->EmployeeDelegate = $employeeDelegate;
        }
        return $this;
    }
    /**
     * Add item to EmployeeDelegate value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\EmployeeDelegate $item
     * @return \App\API\SOAP\StructType\Delegates
     */
    public function addToEmployeeDelegate(\App\API\SOAP\StructType\EmployeeDelegate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\EmployeeDelegate) {
            throw new \InvalidArgumentException(sprintf('The EmployeeDelegate property can only contain items of type \App\API\SOAP\StructType\EmployeeDelegate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmployeeDelegate[] = $item;
        return $this;
    }
}
