<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DecimalSearch StructType
 * @subpackage Structs
 */
class DecimalSearch extends DecimalValue
{
    /**
     * The Condition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Condition;
    /**
     * The Value2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Value2;
    /**
     * Constructor method for DecimalSearch
     * @uses DecimalSearch::setCondition()
     * @uses DecimalSearch::setValue2()
     * @param string $condition
     * @param float $value2
     */
    public function __construct($condition = null, $value2 = null)
    {
        $this
            ->setCondition($condition)
            ->setValue2($value2);
    }
    /**
     * Get Condition value
     * @return string
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @uses \App\API\SOAP\EnumType\DecimalCondition::valueIsValid()
     * @uses \App\API\SOAP\EnumType\DecimalCondition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $condition
     * @return \App\API\SOAP\StructType\DecimalSearch
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: enumeration
        if (!\App\API\SOAP\EnumType\DecimalCondition::valueIsValid($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\API\SOAP\EnumType\DecimalCondition', is_array($condition) ? implode(', ', $condition) : var_export($condition, true), implode(', ', \App\API\SOAP\EnumType\DecimalCondition::getValidValues())), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Get Value2 value
     * @return float
     */
    public function getValue2()
    {
        return $this->Value2;
    }
    /**
     * Set Value2 value
     * @param float $value2
     * @return \App\API\SOAP\StructType\DecimalSearch
     */
    public function setValue2($value2 = null)
    {
        // validation for constraint: float
        if (!is_null($value2) && !(is_float($value2) || is_numeric($value2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value2, true), gettype($value2)), __LINE__);
        }
        $this->Value2 = $value2;
        return $this;
    }
}
