<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPriceClasses StructType
 * @subpackage Structs
 */
class CustomerPriceClasses extends AbstractStructBase
{
    /**
     * The DiscountCustomerPriceClassesDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail[]
     */
    public $DiscountCustomerPriceClassesDetail;
    /**
     * Constructor method for CustomerPriceClasses
     * @uses CustomerPriceClasses::setDiscountCustomerPriceClassesDetail()
     * @param \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail[] $discountCustomerPriceClassesDetail
     */
    public function __construct(array $discountCustomerPriceClassesDetail = array())
    {
        $this
            ->setDiscountCustomerPriceClassesDetail($discountCustomerPriceClassesDetail);
    }
    /**
     * Get DiscountCustomerPriceClassesDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail[]|null
     */
    public function getDiscountCustomerPriceClassesDetail()
    {
        return isset($this->DiscountCustomerPriceClassesDetail) ? $this->DiscountCustomerPriceClassesDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountCustomerPriceClassesDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountCustomerPriceClassesDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountCustomerPriceClassesDetailForArrayConstraintsFromSetDiscountCustomerPriceClassesDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerPriceClassesDiscountCustomerPriceClassesDetailItem) {
            // validation for constraint: itemType
            if (!$customerPriceClassesDiscountCustomerPriceClassesDetailItem instanceof \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail) {
                $invalidValues[] = is_object($customerPriceClassesDiscountCustomerPriceClassesDetailItem) ? get_class($customerPriceClassesDiscountCustomerPriceClassesDetailItem) : sprintf('%s(%s)', gettype($customerPriceClassesDiscountCustomerPriceClassesDetailItem), var_export($customerPriceClassesDiscountCustomerPriceClassesDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountCustomerPriceClassesDetail property can only contain items of type \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountCustomerPriceClassesDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail[] $discountCustomerPriceClassesDetail
     * @return \App\API\SOAP\StructType\CustomerPriceClasses
     */
    public function setDiscountCustomerPriceClassesDetail(array $discountCustomerPriceClassesDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($discountCustomerPriceClassesDetailArrayErrorMessage = self::validateDiscountCustomerPriceClassesDetailForArrayConstraintsFromSetDiscountCustomerPriceClassesDetail($discountCustomerPriceClassesDetail))) {
            throw new \InvalidArgumentException($discountCustomerPriceClassesDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($discountCustomerPriceClassesDetail) || (is_array($discountCustomerPriceClassesDetail) && empty($discountCustomerPriceClassesDetail))) {
            unset($this->DiscountCustomerPriceClassesDetail);
        } else {
            $this->DiscountCustomerPriceClassesDetail = $discountCustomerPriceClassesDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountCustomerPriceClassesDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail $item
     * @return \App\API\SOAP\StructType\CustomerPriceClasses
     */
    public function addToDiscountCustomerPriceClassesDetail(\App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountCustomerPriceClassesDetail property can only contain items of type \App\API\SOAP\StructType\DiscountCustomerPriceClassesDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountCustomerPriceClassesDetail[] = $item;
        return $this;
    }
}
