<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends Entity
{
    /**
     * The AccountRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccountRef;
    /**
     * The ApplyOverdueCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ApplyOverdueCharges;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Attributes
     */
    public $Attributes;
    /**
     * The AutoApplyPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $AutoApplyPayments;
    /**
     * The BillingAddressSameAsMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $BillingAddressSameAsMain;
    /**
     * The BillingContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Contact
     */
    public $BillingContact;
    /**
     * The BillingContactSameAsMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $BillingContactSameAsMain;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Contacts
     */
    public $Contacts;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CreditVerificationRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CreditVerificationRules
     */
    public $CreditVerificationRules;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyRateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyRateType;
    /**
     * The CustomerClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerClass;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerName;
    /**
     * The EnableCurrencyOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $EnableCurrencyOverride;
    /**
     * The EnableRateOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $EnableRateOverride;
    /**
     * The EnableWriteOffs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $EnableWriteOffs;
    /**
     * The FOBPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LeadTimedays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShortValue
     */
    public $LeadTimedays;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $LocationName;
    /**
     * The MainContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Contact
     */
    public $MainContact;
    /**
     * The MultiCurrencyStatements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $MultiCurrencyStatements;
    /**
     * The OrderPriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShortValue
     */
    public $OrderPriority;
    /**
     * The ParentRecord
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ParentRecord;
    /**
     * The PaymentInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\PaymentInstructions
     */
    public $PaymentInstructions;
    /**
     * The PriceClassID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PriceClassID;
    /**
     * The PrintDunningLetters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $PrintDunningLetters;
    /**
     * The PrintInvoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $PrintInvoices;
    /**
     * The PrintStatements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $PrintStatements;
    /**
     * The ResidentialDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ResidentialDelivery;
    /**
     * The Salespersons
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Salespersons
     */
    public $Salespersons;
    /**
     * The SaturdayDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $SaturdayDelivery;
    /**
     * The SendDunningLettersbyEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $SendDunningLettersbyEmail;
    /**
     * The SendInvoicesbyEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $SendInvoicesbyEmail;
    /**
     * The SendStatementsbyEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $SendStatementsbyEmail;
    /**
     * The ShippingAddressSameAsMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShippingAddressSameAsMain;
    /**
     * The ShippingBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShippingBranch;
    /**
     * The ShippingContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Contact
     */
    public $ShippingContact;
    /**
     * The ShippingContactSameAsMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShippingContactSameAsMain;
    /**
     * The ShippingRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The ShippingTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShippingZoneID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShippingZoneID;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The StatementCycleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $StatementCycleID;
    /**
     * The StatementType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $StatementType;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxRegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxRegistrationID;
    /**
     * The TaxZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxZone;
    /**
     * The Terms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Terms;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * The WriteOffLimit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $WriteOffLimit;
    /**
     * Constructor method for Customer
     * @uses Customer::setAccountRef()
     * @uses Customer::setApplyOverdueCharges()
     * @uses Customer::setAttributes()
     * @uses Customer::setAutoApplyPayments()
     * @uses Customer::setBillingAddressSameAsMain()
     * @uses Customer::setBillingContact()
     * @uses Customer::setBillingContactSameAsMain()
     * @uses Customer::setContacts()
     * @uses Customer::setCreatedDateTime()
     * @uses Customer::setCreditVerificationRules()
     * @uses Customer::setCurrencyID()
     * @uses Customer::setCurrencyRateType()
     * @uses Customer::setCustomerClass()
     * @uses Customer::setCustomerID()
     * @uses Customer::setCustomerName()
     * @uses Customer::setEnableCurrencyOverride()
     * @uses Customer::setEnableRateOverride()
     * @uses Customer::setEnableWriteOffs()
     * @uses Customer::setFOBPoint()
     * @uses Customer::setLastModifiedDateTime()
     * @uses Customer::setLeadTimedays()
     * @uses Customer::setLocationName()
     * @uses Customer::setMainContact()
     * @uses Customer::setMultiCurrencyStatements()
     * @uses Customer::setOrderPriority()
     * @uses Customer::setParentRecord()
     * @uses Customer::setPaymentInstructions()
     * @uses Customer::setPriceClassID()
     * @uses Customer::setPrintDunningLetters()
     * @uses Customer::setPrintInvoices()
     * @uses Customer::setPrintStatements()
     * @uses Customer::setResidentialDelivery()
     * @uses Customer::setSalespersons()
     * @uses Customer::setSaturdayDelivery()
     * @uses Customer::setSendDunningLettersbyEmail()
     * @uses Customer::setSendInvoicesbyEmail()
     * @uses Customer::setSendStatementsbyEmail()
     * @uses Customer::setShippingAddressSameAsMain()
     * @uses Customer::setShippingBranch()
     * @uses Customer::setShippingContact()
     * @uses Customer::setShippingContactSameAsMain()
     * @uses Customer::setShippingRule()
     * @uses Customer::setShippingTerms()
     * @uses Customer::setShippingZoneID()
     * @uses Customer::setShipVia()
     * @uses Customer::setStatementCycleID()
     * @uses Customer::setStatementType()
     * @uses Customer::setStatus()
     * @uses Customer::setTaxRegistrationID()
     * @uses Customer::setTaxZone()
     * @uses Customer::setTerms()
     * @uses Customer::setWarehouseID()
     * @uses Customer::setWriteOffLimit()
     * @param \App\API\SOAP\StructType\StringValue $accountRef
     * @param \App\API\SOAP\StructType\BooleanValue $applyOverdueCharges
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @param \App\API\SOAP\StructType\BooleanValue $autoApplyPayments
     * @param \App\API\SOAP\StructType\BooleanValue $billingAddressSameAsMain
     * @param \App\API\SOAP\StructType\Contact $billingContact
     * @param \App\API\SOAP\StructType\BooleanValue $billingContactSameAsMain
     * @param \App\API\SOAP\StructType\Contacts $contacts
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @param \App\API\SOAP\StructType\CreditVerificationRules $creditVerificationRules
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\StringValue $currencyRateType
     * @param \App\API\SOAP\StructType\StringValue $customerClass
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @param \App\API\SOAP\StructType\StringValue $customerName
     * @param \App\API\SOAP\StructType\BooleanValue $enableCurrencyOverride
     * @param \App\API\SOAP\StructType\BooleanValue $enableRateOverride
     * @param \App\API\SOAP\StructType\BooleanValue $enableWriteOffs
     * @param \App\API\SOAP\StructType\StringValue $fOBPoint
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @param \App\API\SOAP\StructType\ShortValue $leadTimedays
     * @param \App\API\SOAP\StructType\StringValue $locationName
     * @param \App\API\SOAP\StructType\Contact $mainContact
     * @param \App\API\SOAP\StructType\BooleanValue $multiCurrencyStatements
     * @param \App\API\SOAP\StructType\ShortValue $orderPriority
     * @param \App\API\SOAP\StructType\StringValue $parentRecord
     * @param \App\API\SOAP\StructType\PaymentInstructions $paymentInstructions
     * @param \App\API\SOAP\StructType\StringValue $priceClassID
     * @param \App\API\SOAP\StructType\BooleanValue $printDunningLetters
     * @param \App\API\SOAP\StructType\BooleanValue $printInvoices
     * @param \App\API\SOAP\StructType\BooleanValue $printStatements
     * @param \App\API\SOAP\StructType\BooleanValue $residentialDelivery
     * @param \App\API\SOAP\StructType\Salespersons $salespersons
     * @param \App\API\SOAP\StructType\BooleanValue $saturdayDelivery
     * @param \App\API\SOAP\StructType\BooleanValue $sendDunningLettersbyEmail
     * @param \App\API\SOAP\StructType\BooleanValue $sendInvoicesbyEmail
     * @param \App\API\SOAP\StructType\BooleanValue $sendStatementsbyEmail
     * @param \App\API\SOAP\StructType\BooleanValue $shippingAddressSameAsMain
     * @param \App\API\SOAP\StructType\StringValue $shippingBranch
     * @param \App\API\SOAP\StructType\Contact $shippingContact
     * @param \App\API\SOAP\StructType\BooleanValue $shippingContactSameAsMain
     * @param \App\API\SOAP\StructType\StringValue $shippingRule
     * @param \App\API\SOAP\StructType\StringValue $shippingTerms
     * @param \App\API\SOAP\StructType\StringValue $shippingZoneID
     * @param \App\API\SOAP\StructType\StringValue $shipVia
     * @param \App\API\SOAP\StructType\StringValue $statementCycleID
     * @param \App\API\SOAP\StructType\StringValue $statementType
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $taxRegistrationID
     * @param \App\API\SOAP\StructType\StringValue $taxZone
     * @param \App\API\SOAP\StructType\StringValue $terms
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     * @param \App\API\SOAP\StructType\DecimalValue $writeOffLimit
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $accountRef = null, \App\API\SOAP\StructType\BooleanValue $applyOverdueCharges = null, \App\API\SOAP\StructType\Attributes $attributes = null, \App\API\SOAP\StructType\BooleanValue $autoApplyPayments = null, \App\API\SOAP\StructType\BooleanValue $billingAddressSameAsMain = null, \App\API\SOAP\StructType\Contact $billingContact = null, \App\API\SOAP\StructType\BooleanValue $billingContactSameAsMain = null, \App\API\SOAP\StructType\Contacts $contacts = null, \App\API\SOAP\StructType\DateTimeValue $createdDateTime = null, \App\API\SOAP\StructType\CreditVerificationRules $creditVerificationRules = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\StringValue $currencyRateType = null, \App\API\SOAP\StructType\StringValue $customerClass = null, \App\API\SOAP\StructType\StringValue $customerID = null, \App\API\SOAP\StructType\StringValue $customerName = null, \App\API\SOAP\StructType\BooleanValue $enableCurrencyOverride = null, \App\API\SOAP\StructType\BooleanValue $enableRateOverride = null, \App\API\SOAP\StructType\BooleanValue $enableWriteOffs = null, \App\API\SOAP\StructType\StringValue $fOBPoint = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null, \App\API\SOAP\StructType\ShortValue $leadTimedays = null, \App\API\SOAP\StructType\StringValue $locationName = null, \App\API\SOAP\StructType\Contact $mainContact = null, \App\API\SOAP\StructType\BooleanValue $multiCurrencyStatements = null, \App\API\SOAP\StructType\ShortValue $orderPriority = null, \App\API\SOAP\StructType\StringValue $parentRecord = null, \App\API\SOAP\StructType\PaymentInstructions $paymentInstructions = null, \App\API\SOAP\StructType\StringValue $priceClassID = null, \App\API\SOAP\StructType\BooleanValue $printDunningLetters = null, \App\API\SOAP\StructType\BooleanValue $printInvoices = null, \App\API\SOAP\StructType\BooleanValue $printStatements = null, \App\API\SOAP\StructType\BooleanValue $residentialDelivery = null, \App\API\SOAP\StructType\Salespersons $salespersons = null, \App\API\SOAP\StructType\BooleanValue $saturdayDelivery = null, \App\API\SOAP\StructType\BooleanValue $sendDunningLettersbyEmail = null, \App\API\SOAP\StructType\BooleanValue $sendInvoicesbyEmail = null, \App\API\SOAP\StructType\BooleanValue $sendStatementsbyEmail = null, \App\API\SOAP\StructType\BooleanValue $shippingAddressSameAsMain = null, \App\API\SOAP\StructType\StringValue $shippingBranch = null, \App\API\SOAP\StructType\Contact $shippingContact = null, \App\API\SOAP\StructType\BooleanValue $shippingContactSameAsMain = null, \App\API\SOAP\StructType\StringValue $shippingRule = null, \App\API\SOAP\StructType\StringValue $shippingTerms = null, \App\API\SOAP\StructType\StringValue $shippingZoneID = null, \App\API\SOAP\StructType\StringValue $shipVia = null, \App\API\SOAP\StructType\StringValue $statementCycleID = null, \App\API\SOAP\StructType\StringValue $statementType = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $taxRegistrationID = null, \App\API\SOAP\StructType\StringValue $taxZone = null, \App\API\SOAP\StructType\StringValue $terms = null, \App\API\SOAP\StructType\StringValue $warehouseID = null, \App\API\SOAP\StructType\DecimalValue $writeOffLimit = null)
    {
        $this
            ->setAccountRef($accountRef)
            ->setApplyOverdueCharges($applyOverdueCharges)
            ->setAttributes($attributes)
            ->setAutoApplyPayments($autoApplyPayments)
            ->setBillingAddressSameAsMain($billingAddressSameAsMain)
            ->setBillingContact($billingContact)
            ->setBillingContactSameAsMain($billingContactSameAsMain)
            ->setContacts($contacts)
            ->setCreatedDateTime($createdDateTime)
            ->setCreditVerificationRules($creditVerificationRules)
            ->setCurrencyID($currencyID)
            ->setCurrencyRateType($currencyRateType)
            ->setCustomerClass($customerClass)
            ->setCustomerID($customerID)
            ->setCustomerName($customerName)
            ->setEnableCurrencyOverride($enableCurrencyOverride)
            ->setEnableRateOverride($enableRateOverride)
            ->setEnableWriteOffs($enableWriteOffs)
            ->setFOBPoint($fOBPoint)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLeadTimedays($leadTimedays)
            ->setLocationName($locationName)
            ->setMainContact($mainContact)
            ->setMultiCurrencyStatements($multiCurrencyStatements)
            ->setOrderPriority($orderPriority)
            ->setParentRecord($parentRecord)
            ->setPaymentInstructions($paymentInstructions)
            ->setPriceClassID($priceClassID)
            ->setPrintDunningLetters($printDunningLetters)
            ->setPrintInvoices($printInvoices)
            ->setPrintStatements($printStatements)
            ->setResidentialDelivery($residentialDelivery)
            ->setSalespersons($salespersons)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setSendDunningLettersbyEmail($sendDunningLettersbyEmail)
            ->setSendInvoicesbyEmail($sendInvoicesbyEmail)
            ->setSendStatementsbyEmail($sendStatementsbyEmail)
            ->setShippingAddressSameAsMain($shippingAddressSameAsMain)
            ->setShippingBranch($shippingBranch)
            ->setShippingContact($shippingContact)
            ->setShippingContactSameAsMain($shippingContactSameAsMain)
            ->setShippingRule($shippingRule)
            ->setShippingTerms($shippingTerms)
            ->setShippingZoneID($shippingZoneID)
            ->setShipVia($shipVia)
            ->setStatementCycleID($statementCycleID)
            ->setStatementType($statementType)
            ->setStatus($status)
            ->setTaxRegistrationID($taxRegistrationID)
            ->setTaxZone($taxZone)
            ->setTerms($terms)
            ->setWarehouseID($warehouseID)
            ->setWriteOffLimit($writeOffLimit);
    }
    /**
     * Get AccountRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccountRef()
    {
        return isset($this->AccountRef) ? $this->AccountRef : null;
    }
    /**
     * Set AccountRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accountRef
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setAccountRef(\App\API\SOAP\StructType\StringValue $accountRef = null)
    {
        if (is_null($accountRef) || (is_array($accountRef) && empty($accountRef))) {
            unset($this->AccountRef);
        } else {
            $this->AccountRef = $accountRef;
        }
        return $this;
    }
    /**
     * Get ApplyOverdueCharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getApplyOverdueCharges()
    {
        return isset($this->ApplyOverdueCharges) ? $this->ApplyOverdueCharges : null;
    }
    /**
     * Set ApplyOverdueCharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $applyOverdueCharges
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setApplyOverdueCharges(\App\API\SOAP\StructType\BooleanValue $applyOverdueCharges = null)
    {
        if (is_null($applyOverdueCharges) || (is_array($applyOverdueCharges) && empty($applyOverdueCharges))) {
            unset($this->ApplyOverdueCharges);
        } else {
            $this->ApplyOverdueCharges = $applyOverdueCharges;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setAttributes(\App\API\SOAP\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get AutoApplyPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getAutoApplyPayments()
    {
        return isset($this->AutoApplyPayments) ? $this->AutoApplyPayments : null;
    }
    /**
     * Set AutoApplyPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $autoApplyPayments
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setAutoApplyPayments(\App\API\SOAP\StructType\BooleanValue $autoApplyPayments = null)
    {
        if (is_null($autoApplyPayments) || (is_array($autoApplyPayments) && empty($autoApplyPayments))) {
            unset($this->AutoApplyPayments);
        } else {
            $this->AutoApplyPayments = $autoApplyPayments;
        }
        return $this;
    }
    /**
     * Get BillingAddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillingAddressSameAsMain()
    {
        return isset($this->BillingAddressSameAsMain) ? $this->BillingAddressSameAsMain : null;
    }
    /**
     * Set BillingAddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billingAddressSameAsMain
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setBillingAddressSameAsMain(\App\API\SOAP\StructType\BooleanValue $billingAddressSameAsMain = null)
    {
        if (is_null($billingAddressSameAsMain) || (is_array($billingAddressSameAsMain) && empty($billingAddressSameAsMain))) {
            unset($this->BillingAddressSameAsMain);
        } else {
            $this->BillingAddressSameAsMain = $billingAddressSameAsMain;
        }
        return $this;
    }
    /**
     * Get BillingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Contact|null
     */
    public function getBillingContact()
    {
        return isset($this->BillingContact) ? $this->BillingContact : null;
    }
    /**
     * Set BillingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Contact $billingContact
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setBillingContact(\App\API\SOAP\StructType\Contact $billingContact = null)
    {
        if (is_null($billingContact) || (is_array($billingContact) && empty($billingContact))) {
            unset($this->BillingContact);
        } else {
            $this->BillingContact = $billingContact;
        }
        return $this;
    }
    /**
     * Get BillingContactSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillingContactSameAsMain()
    {
        return isset($this->BillingContactSameAsMain) ? $this->BillingContactSameAsMain : null;
    }
    /**
     * Set BillingContactSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billingContactSameAsMain
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setBillingContactSameAsMain(\App\API\SOAP\StructType\BooleanValue $billingContactSameAsMain = null)
    {
        if (is_null($billingContactSameAsMain) || (is_array($billingContactSameAsMain) && empty($billingContactSameAsMain))) {
            unset($this->BillingContactSameAsMain);
        } else {
            $this->BillingContactSameAsMain = $billingContactSameAsMain;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Contacts $contacts
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setContacts(\App\API\SOAP\StructType\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $createdDateTime
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setCreatedDateTime(\App\API\SOAP\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CreditVerificationRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CreditVerificationRules|null
     */
    public function getCreditVerificationRules()
    {
        return isset($this->CreditVerificationRules) ? $this->CreditVerificationRules : null;
    }
    /**
     * Set CreditVerificationRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\CreditVerificationRules $creditVerificationRules
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setCreditVerificationRules(\App\API\SOAP\StructType\CreditVerificationRules $creditVerificationRules = null)
    {
        if (is_null($creditVerificationRules) || (is_array($creditVerificationRules) && empty($creditVerificationRules))) {
            unset($this->CreditVerificationRules);
        } else {
            $this->CreditVerificationRules = $creditVerificationRules;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyRateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyRateType()
    {
        return isset($this->CurrencyRateType) ? $this->CurrencyRateType : null;
    }
    /**
     * Set CurrencyRateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyRateType
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setCurrencyRateType(\App\API\SOAP\StructType\StringValue $currencyRateType = null)
    {
        if (is_null($currencyRateType) || (is_array($currencyRateType) && empty($currencyRateType))) {
            unset($this->CurrencyRateType);
        } else {
            $this->CurrencyRateType = $currencyRateType;
        }
        return $this;
    }
    /**
     * Get CustomerClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerClass()
    {
        return isset($this->CustomerClass) ? $this->CustomerClass : null;
    }
    /**
     * Set CustomerClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerClass
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setCustomerClass(\App\API\SOAP\StructType\StringValue $customerClass = null)
    {
        if (is_null($customerClass) || (is_array($customerClass) && empty($customerClass))) {
            unset($this->CustomerClass);
        } else {
            $this->CustomerClass = $customerClass;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerID
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setCustomerID(\App\API\SOAP\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerName()
    {
        return isset($this->CustomerName) ? $this->CustomerName : null;
    }
    /**
     * Set CustomerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerName
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setCustomerName(\App\API\SOAP\StructType\StringValue $customerName = null)
    {
        if (is_null($customerName) || (is_array($customerName) && empty($customerName))) {
            unset($this->CustomerName);
        } else {
            $this->CustomerName = $customerName;
        }
        return $this;
    }
    /**
     * Get EnableCurrencyOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getEnableCurrencyOverride()
    {
        return isset($this->EnableCurrencyOverride) ? $this->EnableCurrencyOverride : null;
    }
    /**
     * Set EnableCurrencyOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $enableCurrencyOverride
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setEnableCurrencyOverride(\App\API\SOAP\StructType\BooleanValue $enableCurrencyOverride = null)
    {
        if (is_null($enableCurrencyOverride) || (is_array($enableCurrencyOverride) && empty($enableCurrencyOverride))) {
            unset($this->EnableCurrencyOverride);
        } else {
            $this->EnableCurrencyOverride = $enableCurrencyOverride;
        }
        return $this;
    }
    /**
     * Get EnableRateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getEnableRateOverride()
    {
        return isset($this->EnableRateOverride) ? $this->EnableRateOverride : null;
    }
    /**
     * Set EnableRateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $enableRateOverride
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setEnableRateOverride(\App\API\SOAP\StructType\BooleanValue $enableRateOverride = null)
    {
        if (is_null($enableRateOverride) || (is_array($enableRateOverride) && empty($enableRateOverride))) {
            unset($this->EnableRateOverride);
        } else {
            $this->EnableRateOverride = $enableRateOverride;
        }
        return $this;
    }
    /**
     * Get EnableWriteOffs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getEnableWriteOffs()
    {
        return isset($this->EnableWriteOffs) ? $this->EnableWriteOffs : null;
    }
    /**
     * Set EnableWriteOffs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $enableWriteOffs
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setEnableWriteOffs(\App\API\SOAP\StructType\BooleanValue $enableWriteOffs = null)
    {
        if (is_null($enableWriteOffs) || (is_array($enableWriteOffs) && empty($enableWriteOffs))) {
            unset($this->EnableWriteOffs);
        } else {
            $this->EnableWriteOffs = $enableWriteOffs;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $fOBPoint
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setFOBPoint(\App\API\SOAP\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LeadTimedays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShortValue|null
     */
    public function getLeadTimedays()
    {
        return isset($this->LeadTimedays) ? $this->LeadTimedays : null;
    }
    /**
     * Set LeadTimedays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ShortValue $leadTimedays
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setLeadTimedays(\App\API\SOAP\StructType\ShortValue $leadTimedays = null)
    {
        if (is_null($leadTimedays) || (is_array($leadTimedays) && empty($leadTimedays))) {
            unset($this->LeadTimedays);
        } else {
            $this->LeadTimedays = $leadTimedays;
        }
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $locationName
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setLocationName(\App\API\SOAP\StructType\StringValue $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get MainContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Contact|null
     */
    public function getMainContact()
    {
        return isset($this->MainContact) ? $this->MainContact : null;
    }
    /**
     * Set MainContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Contact $mainContact
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setMainContact(\App\API\SOAP\StructType\Contact $mainContact = null)
    {
        if (is_null($mainContact) || (is_array($mainContact) && empty($mainContact))) {
            unset($this->MainContact);
        } else {
            $this->MainContact = $mainContact;
        }
        return $this;
    }
    /**
     * Get MultiCurrencyStatements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getMultiCurrencyStatements()
    {
        return isset($this->MultiCurrencyStatements) ? $this->MultiCurrencyStatements : null;
    }
    /**
     * Set MultiCurrencyStatements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $multiCurrencyStatements
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setMultiCurrencyStatements(\App\API\SOAP\StructType\BooleanValue $multiCurrencyStatements = null)
    {
        if (is_null($multiCurrencyStatements) || (is_array($multiCurrencyStatements) && empty($multiCurrencyStatements))) {
            unset($this->MultiCurrencyStatements);
        } else {
            $this->MultiCurrencyStatements = $multiCurrencyStatements;
        }
        return $this;
    }
    /**
     * Get OrderPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShortValue|null
     */
    public function getOrderPriority()
    {
        return isset($this->OrderPriority) ? $this->OrderPriority : null;
    }
    /**
     * Set OrderPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ShortValue $orderPriority
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setOrderPriority(\App\API\SOAP\StructType\ShortValue $orderPriority = null)
    {
        if (is_null($orderPriority) || (is_array($orderPriority) && empty($orderPriority))) {
            unset($this->OrderPriority);
        } else {
            $this->OrderPriority = $orderPriority;
        }
        return $this;
    }
    /**
     * Get ParentRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getParentRecord()
    {
        return isset($this->ParentRecord) ? $this->ParentRecord : null;
    }
    /**
     * Set ParentRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $parentRecord
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setParentRecord(\App\API\SOAP\StructType\StringValue $parentRecord = null)
    {
        if (is_null($parentRecord) || (is_array($parentRecord) && empty($parentRecord))) {
            unset($this->ParentRecord);
        } else {
            $this->ParentRecord = $parentRecord;
        }
        return $this;
    }
    /**
     * Get PaymentInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\PaymentInstructions|null
     */
    public function getPaymentInstructions()
    {
        return isset($this->PaymentInstructions) ? $this->PaymentInstructions : null;
    }
    /**
     * Set PaymentInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\PaymentInstructions $paymentInstructions
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setPaymentInstructions(\App\API\SOAP\StructType\PaymentInstructions $paymentInstructions = null)
    {
        if (is_null($paymentInstructions) || (is_array($paymentInstructions) && empty($paymentInstructions))) {
            unset($this->PaymentInstructions);
        } else {
            $this->PaymentInstructions = $paymentInstructions;
        }
        return $this;
    }
    /**
     * Get PriceClassID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPriceClassID()
    {
        return isset($this->PriceClassID) ? $this->PriceClassID : null;
    }
    /**
     * Set PriceClassID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $priceClassID
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setPriceClassID(\App\API\SOAP\StructType\StringValue $priceClassID = null)
    {
        if (is_null($priceClassID) || (is_array($priceClassID) && empty($priceClassID))) {
            unset($this->PriceClassID);
        } else {
            $this->PriceClassID = $priceClassID;
        }
        return $this;
    }
    /**
     * Get PrintDunningLetters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getPrintDunningLetters()
    {
        return isset($this->PrintDunningLetters) ? $this->PrintDunningLetters : null;
    }
    /**
     * Set PrintDunningLetters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $printDunningLetters
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setPrintDunningLetters(\App\API\SOAP\StructType\BooleanValue $printDunningLetters = null)
    {
        if (is_null($printDunningLetters) || (is_array($printDunningLetters) && empty($printDunningLetters))) {
            unset($this->PrintDunningLetters);
        } else {
            $this->PrintDunningLetters = $printDunningLetters;
        }
        return $this;
    }
    /**
     * Get PrintInvoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getPrintInvoices()
    {
        return isset($this->PrintInvoices) ? $this->PrintInvoices : null;
    }
    /**
     * Set PrintInvoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $printInvoices
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setPrintInvoices(\App\API\SOAP\StructType\BooleanValue $printInvoices = null)
    {
        if (is_null($printInvoices) || (is_array($printInvoices) && empty($printInvoices))) {
            unset($this->PrintInvoices);
        } else {
            $this->PrintInvoices = $printInvoices;
        }
        return $this;
    }
    /**
     * Get PrintStatements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getPrintStatements()
    {
        return isset($this->PrintStatements) ? $this->PrintStatements : null;
    }
    /**
     * Set PrintStatements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $printStatements
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setPrintStatements(\App\API\SOAP\StructType\BooleanValue $printStatements = null)
    {
        if (is_null($printStatements) || (is_array($printStatements) && empty($printStatements))) {
            unset($this->PrintStatements);
        } else {
            $this->PrintStatements = $printStatements;
        }
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getResidentialDelivery()
    {
        return isset($this->ResidentialDelivery) ? $this->ResidentialDelivery : null;
    }
    /**
     * Set ResidentialDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $residentialDelivery
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setResidentialDelivery(\App\API\SOAP\StructType\BooleanValue $residentialDelivery = null)
    {
        if (is_null($residentialDelivery) || (is_array($residentialDelivery) && empty($residentialDelivery))) {
            unset($this->ResidentialDelivery);
        } else {
            $this->ResidentialDelivery = $residentialDelivery;
        }
        return $this;
    }
    /**
     * Get Salespersons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Salespersons|null
     */
    public function getSalespersons()
    {
        return isset($this->Salespersons) ? $this->Salespersons : null;
    }
    /**
     * Set Salespersons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Salespersons $salespersons
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setSalespersons(\App\API\SOAP\StructType\Salespersons $salespersons = null)
    {
        if (is_null($salespersons) || (is_array($salespersons) && empty($salespersons))) {
            unset($this->Salespersons);
        } else {
            $this->Salespersons = $salespersons;
        }
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSaturdayDelivery()
    {
        return isset($this->SaturdayDelivery) ? $this->SaturdayDelivery : null;
    }
    /**
     * Set SaturdayDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $saturdayDelivery
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setSaturdayDelivery(\App\API\SOAP\StructType\BooleanValue $saturdayDelivery = null)
    {
        if (is_null($saturdayDelivery) || (is_array($saturdayDelivery) && empty($saturdayDelivery))) {
            unset($this->SaturdayDelivery);
        } else {
            $this->SaturdayDelivery = $saturdayDelivery;
        }
        return $this;
    }
    /**
     * Get SendDunningLettersbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSendDunningLettersbyEmail()
    {
        return isset($this->SendDunningLettersbyEmail) ? $this->SendDunningLettersbyEmail : null;
    }
    /**
     * Set SendDunningLettersbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $sendDunningLettersbyEmail
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setSendDunningLettersbyEmail(\App\API\SOAP\StructType\BooleanValue $sendDunningLettersbyEmail = null)
    {
        if (is_null($sendDunningLettersbyEmail) || (is_array($sendDunningLettersbyEmail) && empty($sendDunningLettersbyEmail))) {
            unset($this->SendDunningLettersbyEmail);
        } else {
            $this->SendDunningLettersbyEmail = $sendDunningLettersbyEmail;
        }
        return $this;
    }
    /**
     * Get SendInvoicesbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSendInvoicesbyEmail()
    {
        return isset($this->SendInvoicesbyEmail) ? $this->SendInvoicesbyEmail : null;
    }
    /**
     * Set SendInvoicesbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $sendInvoicesbyEmail
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setSendInvoicesbyEmail(\App\API\SOAP\StructType\BooleanValue $sendInvoicesbyEmail = null)
    {
        if (is_null($sendInvoicesbyEmail) || (is_array($sendInvoicesbyEmail) && empty($sendInvoicesbyEmail))) {
            unset($this->SendInvoicesbyEmail);
        } else {
            $this->SendInvoicesbyEmail = $sendInvoicesbyEmail;
        }
        return $this;
    }
    /**
     * Get SendStatementsbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSendStatementsbyEmail()
    {
        return isset($this->SendStatementsbyEmail) ? $this->SendStatementsbyEmail : null;
    }
    /**
     * Set SendStatementsbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $sendStatementsbyEmail
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setSendStatementsbyEmail(\App\API\SOAP\StructType\BooleanValue $sendStatementsbyEmail = null)
    {
        if (is_null($sendStatementsbyEmail) || (is_array($sendStatementsbyEmail) && empty($sendStatementsbyEmail))) {
            unset($this->SendStatementsbyEmail);
        } else {
            $this->SendStatementsbyEmail = $sendStatementsbyEmail;
        }
        return $this;
    }
    /**
     * Get ShippingAddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShippingAddressSameAsMain()
    {
        return isset($this->ShippingAddressSameAsMain) ? $this->ShippingAddressSameAsMain : null;
    }
    /**
     * Set ShippingAddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shippingAddressSameAsMain
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setShippingAddressSameAsMain(\App\API\SOAP\StructType\BooleanValue $shippingAddressSameAsMain = null)
    {
        if (is_null($shippingAddressSameAsMain) || (is_array($shippingAddressSameAsMain) && empty($shippingAddressSameAsMain))) {
            unset($this->ShippingAddressSameAsMain);
        } else {
            $this->ShippingAddressSameAsMain = $shippingAddressSameAsMain;
        }
        return $this;
    }
    /**
     * Get ShippingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShippingBranch()
    {
        return isset($this->ShippingBranch) ? $this->ShippingBranch : null;
    }
    /**
     * Set ShippingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shippingBranch
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setShippingBranch(\App\API\SOAP\StructType\StringValue $shippingBranch = null)
    {
        if (is_null($shippingBranch) || (is_array($shippingBranch) && empty($shippingBranch))) {
            unset($this->ShippingBranch);
        } else {
            $this->ShippingBranch = $shippingBranch;
        }
        return $this;
    }
    /**
     * Get ShippingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Contact|null
     */
    public function getShippingContact()
    {
        return isset($this->ShippingContact) ? $this->ShippingContact : null;
    }
    /**
     * Set ShippingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Contact $shippingContact
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setShippingContact(\App\API\SOAP\StructType\Contact $shippingContact = null)
    {
        if (is_null($shippingContact) || (is_array($shippingContact) && empty($shippingContact))) {
            unset($this->ShippingContact);
        } else {
            $this->ShippingContact = $shippingContact;
        }
        return $this;
    }
    /**
     * Get ShippingContactSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShippingContactSameAsMain()
    {
        return isset($this->ShippingContactSameAsMain) ? $this->ShippingContactSameAsMain : null;
    }
    /**
     * Set ShippingContactSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shippingContactSameAsMain
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setShippingContactSameAsMain(\App\API\SOAP\StructType\BooleanValue $shippingContactSameAsMain = null)
    {
        if (is_null($shippingContactSameAsMain) || (is_array($shippingContactSameAsMain) && empty($shippingContactSameAsMain))) {
            unset($this->ShippingContactSameAsMain);
        } else {
            $this->ShippingContactSameAsMain = $shippingContactSameAsMain;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shippingRule
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setShippingRule(\App\API\SOAP\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shippingTerms
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setShippingTerms(\App\API\SOAP\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShippingZoneID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShippingZoneID()
    {
        return isset($this->ShippingZoneID) ? $this->ShippingZoneID : null;
    }
    /**
     * Set ShippingZoneID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shippingZoneID
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setShippingZoneID(\App\API\SOAP\StructType\StringValue $shippingZoneID = null)
    {
        if (is_null($shippingZoneID) || (is_array($shippingZoneID) && empty($shippingZoneID))) {
            unset($this->ShippingZoneID);
        } else {
            $this->ShippingZoneID = $shippingZoneID;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $shipVia
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setShipVia(\App\API\SOAP\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get StatementCycleID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatementCycleID()
    {
        return isset($this->StatementCycleID) ? $this->StatementCycleID : null;
    }
    /**
     * Set StatementCycleID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $statementCycleID
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setStatementCycleID(\App\API\SOAP\StructType\StringValue $statementCycleID = null)
    {
        if (is_null($statementCycleID) || (is_array($statementCycleID) && empty($statementCycleID))) {
            unset($this->StatementCycleID);
        } else {
            $this->StatementCycleID = $statementCycleID;
        }
        return $this;
    }
    /**
     * Get StatementType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatementType()
    {
        return isset($this->StatementType) ? $this->StatementType : null;
    }
    /**
     * Set StatementType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $statementType
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setStatementType(\App\API\SOAP\StructType\StringValue $statementType = null)
    {
        if (is_null($statementType) || (is_array($statementType) && empty($statementType))) {
            unset($this->StatementType);
        } else {
            $this->StatementType = $statementType;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxRegistrationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxRegistrationID()
    {
        return isset($this->TaxRegistrationID) ? $this->TaxRegistrationID : null;
    }
    /**
     * Set TaxRegistrationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxRegistrationID
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setTaxRegistrationID(\App\API\SOAP\StructType\StringValue $taxRegistrationID = null)
    {
        if (is_null($taxRegistrationID) || (is_array($taxRegistrationID) && empty($taxRegistrationID))) {
            unset($this->TaxRegistrationID);
        } else {
            $this->TaxRegistrationID = $taxRegistrationID;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxZone
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setTaxZone(\App\API\SOAP\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get Terms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTerms()
    {
        return isset($this->Terms) ? $this->Terms : null;
    }
    /**
     * Set Terms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $terms
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setTerms(\App\API\SOAP\StructType\StringValue $terms = null)
    {
        if (is_null($terms) || (is_array($terms) && empty($terms))) {
            unset($this->Terms);
        } else {
            $this->Terms = $terms;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $warehouseID
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setWarehouseID(\App\API\SOAP\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Get WriteOffLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getWriteOffLimit()
    {
        return isset($this->WriteOffLimit) ? $this->WriteOffLimit : null;
    }
    /**
     * Set WriteOffLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $writeOffLimit
     * @return \App\API\SOAP\StructType\Customer
     */
    public function setWriteOffLimit(\App\API\SOAP\StructType\DecimalValue $writeOffLimit = null)
    {
        if (is_null($writeOffLimit) || (is_array($writeOffLimit) && empty($writeOffLimit))) {
            unset($this->WriteOffLimit);
        } else {
            $this->WriteOffLimit = $writeOffLimit;
        }
        return $this;
    }
}
