<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomField StructType
 * @subpackage Structs
 */
abstract class CustomField extends AbstractStructBase
{
    /**
     * The viewName
     * @var string
     */
    public $viewName;
    /**
     * The fieldName
     * @var string
     */
    public $fieldName;
    /**
     * Constructor method for CustomField
     * @uses CustomField::setViewName()
     * @uses CustomField::setFieldName()
     * @param string $viewName
     * @param string $fieldName
     */
    public function __construct($viewName = null, $fieldName = null)
    {
        $this
            ->setViewName($viewName)
            ->setFieldName($fieldName);
    }
    /**
     * Get viewName value
     * @return string|null
     */
    public function getViewName()
    {
        return $this->viewName;
    }
    /**
     * Set viewName value
     * @param string $viewName
     * @return \App\API\SOAP\StructType\CustomField
     */
    public function setViewName($viewName = null)
    {
        // validation for constraint: string
        if (!is_null($viewName) && !is_string($viewName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewName, true), gettype($viewName)), __LINE__);
        }
        $this->viewName = $viewName;
        return $this;
    }
    /**
     * Get fieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->fieldName;
    }
    /**
     * Set fieldName value
     * @param string $fieldName
     * @return \App\API\SOAP\StructType\CustomField
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        $this->fieldName = $fieldName;
        return $this;
    }
}
