<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrossReferences StructType
 * @subpackage Structs
 */
class CrossReferences extends AbstractStructBase
{
    /**
     * The InventoryItemCrossReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\InventoryItemCrossReference[]
     */
    public $InventoryItemCrossReference;
    /**
     * Constructor method for CrossReferences
     * @uses CrossReferences::setInventoryItemCrossReference()
     * @param \App\API\SOAP\StructType\InventoryItemCrossReference[] $inventoryItemCrossReference
     */
    public function __construct(array $inventoryItemCrossReference = array())
    {
        $this
            ->setInventoryItemCrossReference($inventoryItemCrossReference);
    }
    /**
     * Get InventoryItemCrossReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\InventoryItemCrossReference[]|null
     */
    public function getInventoryItemCrossReference()
    {
        return isset($this->InventoryItemCrossReference) ? $this->InventoryItemCrossReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInventoryItemCrossReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryItemCrossReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryItemCrossReferenceForArrayConstraintsFromSetInventoryItemCrossReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crossReferencesInventoryItemCrossReferenceItem) {
            // validation for constraint: itemType
            if (!$crossReferencesInventoryItemCrossReferenceItem instanceof \App\API\SOAP\StructType\InventoryItemCrossReference) {
                $invalidValues[] = is_object($crossReferencesInventoryItemCrossReferenceItem) ? get_class($crossReferencesInventoryItemCrossReferenceItem) : sprintf('%s(%s)', gettype($crossReferencesInventoryItemCrossReferenceItem), var_export($crossReferencesInventoryItemCrossReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InventoryItemCrossReference property can only contain items of type \App\API\SOAP\StructType\InventoryItemCrossReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InventoryItemCrossReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventoryItemCrossReference[] $inventoryItemCrossReference
     * @return \App\API\SOAP\StructType\CrossReferences
     */
    public function setInventoryItemCrossReference(array $inventoryItemCrossReference = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryItemCrossReferenceArrayErrorMessage = self::validateInventoryItemCrossReferenceForArrayConstraintsFromSetInventoryItemCrossReference($inventoryItemCrossReference))) {
            throw new \InvalidArgumentException($inventoryItemCrossReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($inventoryItemCrossReference) || (is_array($inventoryItemCrossReference) && empty($inventoryItemCrossReference))) {
            unset($this->InventoryItemCrossReference);
        } else {
            $this->InventoryItemCrossReference = $inventoryItemCrossReference;
        }
        return $this;
    }
    /**
     * Add item to InventoryItemCrossReference value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\InventoryItemCrossReference $item
     * @return \App\API\SOAP\StructType\CrossReferences
     */
    public function addToInventoryItemCrossReference(\App\API\SOAP\StructType\InventoryItemCrossReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\InventoryItemCrossReference) {
            throw new \InvalidArgumentException(sprintf('The InventoryItemCrossReference property can only contain items of type \App\API\SOAP\StructType\InventoryItemCrossReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InventoryItemCrossReference[] = $item;
        return $this;
    }
}
