<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardProcessingInfo StructType
 * @subpackage Structs
 */
class CreditCardProcessingInfo extends AbstractStructBase
{
    /**
     * The CreditCardProcessingDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\CreditCardProcessingDetail[]
     */
    public $CreditCardProcessingDetail;
    /**
     * Constructor method for CreditCardProcessingInfo
     * @uses CreditCardProcessingInfo::setCreditCardProcessingDetail()
     * @param \App\API\SOAP\StructType\CreditCardProcessingDetail[] $creditCardProcessingDetail
     */
    public function __construct(array $creditCardProcessingDetail = array())
    {
        $this
            ->setCreditCardProcessingDetail($creditCardProcessingDetail);
    }
    /**
     * Get CreditCardProcessingDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\CreditCardProcessingDetail[]|null
     */
    public function getCreditCardProcessingDetail()
    {
        return isset($this->CreditCardProcessingDetail) ? $this->CreditCardProcessingDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCreditCardProcessingDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreditCardProcessingDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditCardProcessingDetailForArrayConstraintsFromSetCreditCardProcessingDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditCardProcessingInfoCreditCardProcessingDetailItem) {
            // validation for constraint: itemType
            if (!$creditCardProcessingInfoCreditCardProcessingDetailItem instanceof \App\API\SOAP\StructType\CreditCardProcessingDetail) {
                $invalidValues[] = is_object($creditCardProcessingInfoCreditCardProcessingDetailItem) ? get_class($creditCardProcessingInfoCreditCardProcessingDetailItem) : sprintf('%s(%s)', gettype($creditCardProcessingInfoCreditCardProcessingDetailItem), var_export($creditCardProcessingInfoCreditCardProcessingDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CreditCardProcessingDetail property can only contain items of type \App\API\SOAP\StructType\CreditCardProcessingDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CreditCardProcessingDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CreditCardProcessingDetail[] $creditCardProcessingDetail
     * @return \App\API\SOAP\StructType\CreditCardProcessingInfo
     */
    public function setCreditCardProcessingDetail(array $creditCardProcessingDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($creditCardProcessingDetailArrayErrorMessage = self::validateCreditCardProcessingDetailForArrayConstraintsFromSetCreditCardProcessingDetail($creditCardProcessingDetail))) {
            throw new \InvalidArgumentException($creditCardProcessingDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($creditCardProcessingDetail) || (is_array($creditCardProcessingDetail) && empty($creditCardProcessingDetail))) {
            unset($this->CreditCardProcessingDetail);
        } else {
            $this->CreditCardProcessingDetail = $creditCardProcessingDetail;
        }
        return $this;
    }
    /**
     * Add item to CreditCardProcessingDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\CreditCardProcessingDetail $item
     * @return \App\API\SOAP\StructType\CreditCardProcessingInfo
     */
    public function addToCreditCardProcessingDetail(\App\API\SOAP\StructType\CreditCardProcessingDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\CreditCardProcessingDetail) {
            throw new \InvalidArgumentException(sprintf('The CreditCardProcessingDetail property can only contain items of type \App\API\SOAP\StructType\CreditCardProcessingDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CreditCardProcessingDetail[] = $item;
        return $this;
    }
}
