<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardProcessingDetail StructType
 * @subpackage Structs
 */
class CreditCardProcessingDetail extends Entity
{
    /**
     * The TransactionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TransactionAmount;
    /**
     * The TransactionStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TransactionStatus;
    /**
     * Constructor method for CreditCardProcessingDetail
     * @uses CreditCardProcessingDetail::setTransactionAmount()
     * @uses CreditCardProcessingDetail::setTransactionStatus()
     * @param \App\API\SOAP\StructType\DecimalValue $transactionAmount
     * @param \App\API\SOAP\StructType\StringValue $transactionStatus
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $transactionAmount = null, \App\API\SOAP\StructType\StringValue $transactionStatus = null)
    {
        $this
            ->setTransactionAmount($transactionAmount)
            ->setTransactionStatus($transactionStatus);
    }
    /**
     * Get TransactionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTransactionAmount()
    {
        return isset($this->TransactionAmount) ? $this->TransactionAmount : null;
    }
    /**
     * Set TransactionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $transactionAmount
     * @return \App\API\SOAP\StructType\CreditCardProcessingDetail
     */
    public function setTransactionAmount(\App\API\SOAP\StructType\DecimalValue $transactionAmount = null)
    {
        if (is_null($transactionAmount) || (is_array($transactionAmount) && empty($transactionAmount))) {
            unset($this->TransactionAmount);
        } else {
            $this->TransactionAmount = $transactionAmount;
        }
        return $this;
    }
    /**
     * Get TransactionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTransactionStatus()
    {
        return isset($this->TransactionStatus) ? $this->TransactionStatus : null;
    }
    /**
     * Set TransactionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $transactionStatus
     * @return \App\API\SOAP\StructType\CreditCardProcessingDetail
     */
    public function setTransactionStatus(\App\API\SOAP\StructType\StringValue $transactionStatus = null)
    {
        if (is_null($transactionStatus) || (is_array($transactionStatus) && empty($transactionStatus))) {
            unset($this->TransactionStatus);
        } else {
            $this->TransactionStatus = $transactionStatus;
        }
        return $this;
    }
}
