<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRoles StructType
 * @subpackage Structs
 */
class ContactRoles extends Entity
{
    /**
     * The RoleDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $RoleDescription;
    /**
     * The RoleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $RoleName;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Selected;
    /**
     * The UserType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $UserType;
    /**
     * Constructor method for ContactRoles
     * @uses ContactRoles::setRoleDescription()
     * @uses ContactRoles::setRoleName()
     * @uses ContactRoles::setSelected()
     * @uses ContactRoles::setUserType()
     * @param \App\API\SOAP\StructType\StringValue $roleDescription
     * @param \App\API\SOAP\StructType\StringValue $roleName
     * @param \App\API\SOAP\StructType\BooleanValue $selected
     * @param \App\API\SOAP\StructType\IntValue $userType
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $roleDescription = null, \App\API\SOAP\StructType\StringValue $roleName = null, \App\API\SOAP\StructType\BooleanValue $selected = null, \App\API\SOAP\StructType\IntValue $userType = null)
    {
        $this
            ->setRoleDescription($roleDescription)
            ->setRoleName($roleName)
            ->setSelected($selected)
            ->setUserType($userType);
    }
    /**
     * Get RoleDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getRoleDescription()
    {
        return isset($this->RoleDescription) ? $this->RoleDescription : null;
    }
    /**
     * Set RoleDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $roleDescription
     * @return \App\API\SOAP\StructType\ContactRoles
     */
    public function setRoleDescription(\App\API\SOAP\StructType\StringValue $roleDescription = null)
    {
        if (is_null($roleDescription) || (is_array($roleDescription) && empty($roleDescription))) {
            unset($this->RoleDescription);
        } else {
            $this->RoleDescription = $roleDescription;
        }
        return $this;
    }
    /**
     * Get RoleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getRoleName()
    {
        return isset($this->RoleName) ? $this->RoleName : null;
    }
    /**
     * Set RoleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $roleName
     * @return \App\API\SOAP\StructType\ContactRoles
     */
    public function setRoleName(\App\API\SOAP\StructType\StringValue $roleName = null)
    {
        if (is_null($roleName) || (is_array($roleName) && empty($roleName))) {
            unset($this->RoleName);
        } else {
            $this->RoleName = $roleName;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $selected
     * @return \App\API\SOAP\StructType\ContactRoles
     */
    public function setSelected(\App\API\SOAP\StructType\BooleanValue $selected = null)
    {
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get UserType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getUserType()
    {
        return isset($this->UserType) ? $this->UserType : null;
    }
    /**
     * Set UserType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $userType
     * @return \App\API\SOAP\StructType\ContactRoles
     */
    public function setUserType(\App\API\SOAP\StructType\IntValue $userType = null)
    {
        if (is_null($userType) || (is_array($userType) && empty($userType))) {
            unset($this->UserType);
        } else {
            $this->UserType = $userType;
        }
        return $this;
    }
}
