<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyFinancialPeriod StructType
 * @subpackage Structs
 */
class CompanyFinancialPeriod extends Entity
{
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Company;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Details
     */
    public $Details;
    /**
     * The FinancialYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $FinancialYear;
    /**
     * The NbrOfPeriods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShortValue
     */
    public $NbrOfPeriods;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * Constructor method for CompanyFinancialPeriod
     * @uses CompanyFinancialPeriod::setCompany()
     * @uses CompanyFinancialPeriod::setDetails()
     * @uses CompanyFinancialPeriod::setFinancialYear()
     * @uses CompanyFinancialPeriod::setNbrOfPeriods()
     * @uses CompanyFinancialPeriod::setStartDate()
     * @param \App\API\SOAP\StructType\StringValue $company
     * @param \App\API\SOAP\StructType\Details $details
     * @param \App\API\SOAP\StructType\StringValue $financialYear
     * @param \App\API\SOAP\StructType\ShortValue $nbrOfPeriods
     * @param \App\API\SOAP\StructType\DateTimeValue $startDate
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $company = null, \App\API\SOAP\StructType\Details $details = null, \App\API\SOAP\StructType\StringValue $financialYear = null, \App\API\SOAP\StructType\ShortValue $nbrOfPeriods = null, \App\API\SOAP\StructType\DateTimeValue $startDate = null)
    {
        $this
            ->setCompany($company)
            ->setDetails($details)
            ->setFinancialYear($financialYear)
            ->setNbrOfPeriods($nbrOfPeriods)
            ->setStartDate($startDate);
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $company
     * @return \App\API\SOAP\StructType\CompanyFinancialPeriod
     */
    public function setCompany(\App\API\SOAP\StructType\StringValue $company = null)
    {
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Details $details
     * @return \App\API\SOAP\StructType\CompanyFinancialPeriod
     */
    public function setDetails(\App\API\SOAP\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get FinancialYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getFinancialYear()
    {
        return isset($this->FinancialYear) ? $this->FinancialYear : null;
    }
    /**
     * Set FinancialYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $financialYear
     * @return \App\API\SOAP\StructType\CompanyFinancialPeriod
     */
    public function setFinancialYear(\App\API\SOAP\StructType\StringValue $financialYear = null)
    {
        if (is_null($financialYear) || (is_array($financialYear) && empty($financialYear))) {
            unset($this->FinancialYear);
        } else {
            $this->FinancialYear = $financialYear;
        }
        return $this;
    }
    /**
     * Get NbrOfPeriods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShortValue|null
     */
    public function getNbrOfPeriods()
    {
        return isset($this->NbrOfPeriods) ? $this->NbrOfPeriods : null;
    }
    /**
     * Set NbrOfPeriods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ShortValue $nbrOfPeriods
     * @return \App\API\SOAP\StructType\CompanyFinancialPeriod
     */
    public function setNbrOfPeriods(\App\API\SOAP\StructType\ShortValue $nbrOfPeriods = null)
    {
        if (is_null($nbrOfPeriods) || (is_array($nbrOfPeriods) && empty($nbrOfPeriods))) {
            unset($this->NbrOfPeriods);
        } else {
            $this->NbrOfPeriods = $nbrOfPeriods;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $startDate
     * @return \App\API\SOAP\StructType\CompanyFinancialPeriod
     */
    public function setStartDate(\App\API\SOAP\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
}
