<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Check StructType
 * @subpackage Structs
 */
class Check extends Entity
{
    /**
     * The ApplicationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $ApplicationDate;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CashAccount;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Details
     */
    public $Details;
    /**
     * The History
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\History
     */
    public $History;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $PaymentAmount;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * The UnappliedBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnappliedBalance;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Vendor;
    /**
     * Constructor method for Check
     * @uses Check::setApplicationDate()
     * @uses Check::setCashAccount()
     * @uses Check::setCurrencyID()
     * @uses Check::setDescription()
     * @uses Check::setDetails()
     * @uses Check::setHistory()
     * @uses Check::setHold()
     * @uses Check::setPaymentAmount()
     * @uses Check::setPaymentMethod()
     * @uses Check::setPaymentRef()
     * @uses Check::setReferenceNbr()
     * @uses Check::setStatus()
     * @uses Check::setType()
     * @uses Check::setUnappliedBalance()
     * @uses Check::setVendor()
     * @param \App\API\SOAP\StructType\DateTimeValue $applicationDate
     * @param \App\API\SOAP\StructType\StringValue $cashAccount
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\Details $details
     * @param \App\API\SOAP\StructType\History $history
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @param \App\API\SOAP\StructType\DecimalValue $paymentAmount
     * @param \App\API\SOAP\StructType\StringValue $paymentMethod
     * @param \App\API\SOAP\StructType\StringValue $paymentRef
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $type
     * @param \App\API\SOAP\StructType\DecimalValue $unappliedBalance
     * @param \App\API\SOAP\StructType\StringValue $vendor
     */
    public function __construct(\App\API\SOAP\StructType\DateTimeValue $applicationDate = null, \App\API\SOAP\StructType\StringValue $cashAccount = null, \App\API\SOAP\StructType\StringValue $currencyID = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\Details $details = null, \App\API\SOAP\StructType\History $history = null, \App\API\SOAP\StructType\BooleanValue $hold = null, \App\API\SOAP\StructType\DecimalValue $paymentAmount = null, \App\API\SOAP\StructType\StringValue $paymentMethod = null, \App\API\SOAP\StructType\StringValue $paymentRef = null, \App\API\SOAP\StructType\StringValue $referenceNbr = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $type = null, \App\API\SOAP\StructType\DecimalValue $unappliedBalance = null, \App\API\SOAP\StructType\StringValue $vendor = null)
    {
        $this
            ->setApplicationDate($applicationDate)
            ->setCashAccount($cashAccount)
            ->setCurrencyID($currencyID)
            ->setDescription($description)
            ->setDetails($details)
            ->setHistory($history)
            ->setHold($hold)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentRef($paymentRef)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setType($type)
            ->setUnappliedBalance($unappliedBalance)
            ->setVendor($vendor);
    }
    /**
     * Get ApplicationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getApplicationDate()
    {
        return isset($this->ApplicationDate) ? $this->ApplicationDate : null;
    }
    /**
     * Set ApplicationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $applicationDate
     * @return \App\API\SOAP\StructType\Check
     */
    public function setApplicationDate(\App\API\SOAP\StructType\DateTimeValue $applicationDate = null)
    {
        if (is_null($applicationDate) || (is_array($applicationDate) && empty($applicationDate))) {
            unset($this->ApplicationDate);
        } else {
            $this->ApplicationDate = $applicationDate;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $cashAccount
     * @return \App\API\SOAP\StructType\Check
     */
    public function setCashAccount(\App\API\SOAP\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $currencyID
     * @return \App\API\SOAP\StructType\Check
     */
    public function setCurrencyID(\App\API\SOAP\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\Check
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Details $details
     * @return \App\API\SOAP\StructType\Check
     */
    public function setDetails(\App\API\SOAP\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get History value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\History|null
     */
    public function getHistory()
    {
        return isset($this->History) ? $this->History : null;
    }
    /**
     * Set History value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\History $history
     * @return \App\API\SOAP\StructType\Check
     */
    public function setHistory(\App\API\SOAP\StructType\History $history = null)
    {
        if (is_null($history) || (is_array($history) && empty($history))) {
            unset($this->History);
        } else {
            $this->History = $history;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $hold
     * @return \App\API\SOAP\StructType\Check
     */
    public function setHold(\App\API\SOAP\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get PaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getPaymentAmount()
    {
        return isset($this->PaymentAmount) ? $this->PaymentAmount : null;
    }
    /**
     * Set PaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $paymentAmount
     * @return \App\API\SOAP\StructType\Check
     */
    public function setPaymentAmount(\App\API\SOAP\StructType\DecimalValue $paymentAmount = null)
    {
        if (is_null($paymentAmount) || (is_array($paymentAmount) && empty($paymentAmount))) {
            unset($this->PaymentAmount);
        } else {
            $this->PaymentAmount = $paymentAmount;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentMethod
     * @return \App\API\SOAP\StructType\Check
     */
    public function setPaymentMethod(\App\API\SOAP\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $paymentRef
     * @return \App\API\SOAP\StructType\Check
     */
    public function setPaymentRef(\App\API\SOAP\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $referenceNbr
     * @return \App\API\SOAP\StructType\Check
     */
    public function setReferenceNbr(\App\API\SOAP\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\Check
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\Check
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UnappliedBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnappliedBalance()
    {
        return isset($this->UnappliedBalance) ? $this->UnappliedBalance : null;
    }
    /**
     * Set UnappliedBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unappliedBalance
     * @return \App\API\SOAP\StructType\Check
     */
    public function setUnappliedBalance(\App\API\SOAP\StructType\DecimalValue $unappliedBalance = null)
    {
        if (is_null($unappliedBalance) || (is_array($unappliedBalance) && empty($unappliedBalance))) {
            unset($this->UnappliedBalance);
        } else {
            $this->UnappliedBalance = $unappliedBalance;
        }
        return $this;
    }
    /**
     * Get Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getVendor()
    {
        return isset($this->Vendor) ? $this->Vendor : null;
    }
    /**
     * Set Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $vendor
     * @return \App\API\SOAP\StructType\Check
     */
    public function setVendor(\App\API\SOAP\StructType\StringValue $vendor = null)
    {
        if (is_null($vendor) || (is_array($vendor) && empty($vendor))) {
            unset($this->Vendor);
        } else {
            $this->Vendor = $vendor;
        }
        return $this;
    }
}
