<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierPluginParameter StructType
 * @subpackage Structs
 */
class CarrierPluginParameter extends Entity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The PluginID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $PluginID;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Value;
    /**
     * Constructor method for CarrierPluginParameter
     * @uses CarrierPluginParameter::setDescription()
     * @uses CarrierPluginParameter::setPluginID()
     * @uses CarrierPluginParameter::setValue()
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\StringValue $pluginID
     * @param \App\API\SOAP\StructType\StringValue $value
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\StringValue $pluginID = null, \App\API\SOAP\StructType\StringValue $value = null)
    {
        $this
            ->setDescription($description)
            ->setPluginID($pluginID)
            ->setValue($value);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\CarrierPluginParameter
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get PluginID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPluginID()
    {
        return isset($this->PluginID) ? $this->PluginID : null;
    }
    /**
     * Set PluginID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $pluginID
     * @return \App\API\SOAP\StructType\CarrierPluginParameter
     */
    public function setPluginID(\App\API\SOAP\StructType\StringValue $pluginID = null)
    {
        if (is_null($pluginID) || (is_array($pluginID) && empty($pluginID))) {
            unset($this->PluginID);
        } else {
            $this->PluginID = $pluginID;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $value
     * @return \App\API\SOAP\StructType\CarrierPluginParameter
     */
    public function setValue(\App\API\SOAP\StructType\StringValue $value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
