<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessAccount StructType
 * @subpackage Structs
 */
class BusinessAccount extends Entity
{
    /**
     * The AccountRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $AccountRef;
    /**
     * The Activities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Activities
     */
    public $Activities;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Attributes
     */
    public $Attributes;
    /**
     * The BusinessAccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $BusinessAccountID;
    /**
     * The Campaigns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Campaigns
     */
    public $Campaigns;
    /**
     * The Cases
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Cases
     */
    public $Cases;
    /**
     * The ClassID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ClassID;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Contacts
     */
    public $Contacts;
    /**
     * The Contracts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Contracts
     */
    public $Contracts;
    /**
     * The DefaultLocationSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BusinessAccountDefaultLocationSetting
     */
    public $DefaultLocationSettings;
    /**
     * The Duplicate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Duplicate;
    /**
     * The Duplicates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Duplicates
     */
    public $Duplicates;
    /**
     * The LastIncomingActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastIncomingActivity;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LastOutgoingActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $LastOutgoingActivity;
    /**
     * The Locations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Locations
     */
    public $Locations;
    /**
     * The MainAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Address
     */
    public $MainAddress;
    /**
     * The MainAddressValidated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $MainAddressValidated;
    /**
     * The MainContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BusinessAccountMainContact
     */
    public $MainContact;
    /**
     * The MarketingLists
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\MarketingLists
     */
    public $MarketingLists;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Name;
    /**
     * The Opportunities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Opportunities
     */
    public $Opportunities;
    /**
     * The Orders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Orders
     */
    public $Orders;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Owner;
    /**
     * The OwnerEmployeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $OwnerEmployeeName;
    /**
     * The ParentAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ParentAccount;
    /**
     * The Relations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Relations
     */
    public $Relations;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Address
     */
    public $ShippingAddress;
    /**
     * The ShippingAddressSameAsMain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShippingAddressSameAsMain;
    /**
     * The ShippingAddressValidated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $ShippingAddressValidated;
    /**
     * The ShippingContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BusinessAccountShippingContact
     */
    public $ShippingContact;
    /**
     * The SourceCampaign
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $SourceCampaign;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Type;
    /**
     * The Workgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Workgroup;
    /**
     * The WorkgroupDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $WorkgroupDescription;
    /**
     * Constructor method for BusinessAccount
     * @uses BusinessAccount::setAccountRef()
     * @uses BusinessAccount::setActivities()
     * @uses BusinessAccount::setAttributes()
     * @uses BusinessAccount::setBusinessAccountID()
     * @uses BusinessAccount::setCampaigns()
     * @uses BusinessAccount::setCases()
     * @uses BusinessAccount::setClassID()
     * @uses BusinessAccount::setContacts()
     * @uses BusinessAccount::setContracts()
     * @uses BusinessAccount::setDefaultLocationSettings()
     * @uses BusinessAccount::setDuplicate()
     * @uses BusinessAccount::setDuplicates()
     * @uses BusinessAccount::setLastIncomingActivity()
     * @uses BusinessAccount::setLastModifiedDateTime()
     * @uses BusinessAccount::setLastOutgoingActivity()
     * @uses BusinessAccount::setLocations()
     * @uses BusinessAccount::setMainAddress()
     * @uses BusinessAccount::setMainAddressValidated()
     * @uses BusinessAccount::setMainContact()
     * @uses BusinessAccount::setMarketingLists()
     * @uses BusinessAccount::setName()
     * @uses BusinessAccount::setOpportunities()
     * @uses BusinessAccount::setOrders()
     * @uses BusinessAccount::setOwner()
     * @uses BusinessAccount::setOwnerEmployeeName()
     * @uses BusinessAccount::setParentAccount()
     * @uses BusinessAccount::setRelations()
     * @uses BusinessAccount::setShippingAddress()
     * @uses BusinessAccount::setShippingAddressSameAsMain()
     * @uses BusinessAccount::setShippingAddressValidated()
     * @uses BusinessAccount::setShippingContact()
     * @uses BusinessAccount::setSourceCampaign()
     * @uses BusinessAccount::setStatus()
     * @uses BusinessAccount::setType()
     * @uses BusinessAccount::setWorkgroup()
     * @uses BusinessAccount::setWorkgroupDescription()
     * @param \App\API\SOAP\StructType\StringValue $accountRef
     * @param \App\API\SOAP\StructType\Activities $activities
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @param \App\API\SOAP\StructType\StringValue $businessAccountID
     * @param \App\API\SOAP\StructType\Campaigns $campaigns
     * @param \App\API\SOAP\StructType\Cases $cases
     * @param \App\API\SOAP\StructType\StringValue $classID
     * @param \App\API\SOAP\StructType\Contacts $contacts
     * @param \App\API\SOAP\StructType\Contracts $contracts
     * @param \App\API\SOAP\StructType\BusinessAccountDefaultLocationSetting $defaultLocationSettings
     * @param \App\API\SOAP\StructType\StringValue $duplicate
     * @param \App\API\SOAP\StructType\Duplicates $duplicates
     * @param \App\API\SOAP\StructType\DateTimeValue $lastIncomingActivity
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @param \App\API\SOAP\StructType\DateTimeValue $lastOutgoingActivity
     * @param \App\API\SOAP\StructType\Locations $locations
     * @param \App\API\SOAP\StructType\Address $mainAddress
     * @param \App\API\SOAP\StructType\BooleanValue $mainAddressValidated
     * @param \App\API\SOAP\StructType\BusinessAccountMainContact $mainContact
     * @param \App\API\SOAP\StructType\MarketingLists $marketingLists
     * @param \App\API\SOAP\StructType\StringValue $name
     * @param \App\API\SOAP\StructType\Opportunities $opportunities
     * @param \App\API\SOAP\StructType\Orders $orders
     * @param \App\API\SOAP\StructType\StringValue $owner
     * @param \App\API\SOAP\StructType\StringValue $ownerEmployeeName
     * @param \App\API\SOAP\StructType\StringValue $parentAccount
     * @param \App\API\SOAP\StructType\Relations $relations
     * @param \App\API\SOAP\StructType\Address $shippingAddress
     * @param \App\API\SOAP\StructType\BooleanValue $shippingAddressSameAsMain
     * @param \App\API\SOAP\StructType\BooleanValue $shippingAddressValidated
     * @param \App\API\SOAP\StructType\BusinessAccountShippingContact $shippingContact
     * @param \App\API\SOAP\StructType\StringValue $sourceCampaign
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $type
     * @param \App\API\SOAP\StructType\StringValue $workgroup
     * @param \App\API\SOAP\StructType\StringValue $workgroupDescription
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $accountRef = null, \App\API\SOAP\StructType\Activities $activities = null, \App\API\SOAP\StructType\Attributes $attributes = null, \App\API\SOAP\StructType\StringValue $businessAccountID = null, \App\API\SOAP\StructType\Campaigns $campaigns = null, \App\API\SOAP\StructType\Cases $cases = null, \App\API\SOAP\StructType\StringValue $classID = null, \App\API\SOAP\StructType\Contacts $contacts = null, \App\API\SOAP\StructType\Contracts $contracts = null, \App\API\SOAP\StructType\BusinessAccountDefaultLocationSetting $defaultLocationSettings = null, \App\API\SOAP\StructType\StringValue $duplicate = null, \App\API\SOAP\StructType\Duplicates $duplicates = null, \App\API\SOAP\StructType\DateTimeValue $lastIncomingActivity = null, \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null, \App\API\SOAP\StructType\DateTimeValue $lastOutgoingActivity = null, \App\API\SOAP\StructType\Locations $locations = null, \App\API\SOAP\StructType\Address $mainAddress = null, \App\API\SOAP\StructType\BooleanValue $mainAddressValidated = null, \App\API\SOAP\StructType\BusinessAccountMainContact $mainContact = null, \App\API\SOAP\StructType\MarketingLists $marketingLists = null, \App\API\SOAP\StructType\StringValue $name = null, \App\API\SOAP\StructType\Opportunities $opportunities = null, \App\API\SOAP\StructType\Orders $orders = null, \App\API\SOAP\StructType\StringValue $owner = null, \App\API\SOAP\StructType\StringValue $ownerEmployeeName = null, \App\API\SOAP\StructType\StringValue $parentAccount = null, \App\API\SOAP\StructType\Relations $relations = null, \App\API\SOAP\StructType\Address $shippingAddress = null, \App\API\SOAP\StructType\BooleanValue $shippingAddressSameAsMain = null, \App\API\SOAP\StructType\BooleanValue $shippingAddressValidated = null, \App\API\SOAP\StructType\BusinessAccountShippingContact $shippingContact = null, \App\API\SOAP\StructType\StringValue $sourceCampaign = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $type = null, \App\API\SOAP\StructType\StringValue $workgroup = null, \App\API\SOAP\StructType\StringValue $workgroupDescription = null)
    {
        $this
            ->setAccountRef($accountRef)
            ->setActivities($activities)
            ->setAttributes($attributes)
            ->setBusinessAccountID($businessAccountID)
            ->setCampaigns($campaigns)
            ->setCases($cases)
            ->setClassID($classID)
            ->setContacts($contacts)
            ->setContracts($contracts)
            ->setDefaultLocationSettings($defaultLocationSettings)
            ->setDuplicate($duplicate)
            ->setDuplicates($duplicates)
            ->setLastIncomingActivity($lastIncomingActivity)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLastOutgoingActivity($lastOutgoingActivity)
            ->setLocations($locations)
            ->setMainAddress($mainAddress)
            ->setMainAddressValidated($mainAddressValidated)
            ->setMainContact($mainContact)
            ->setMarketingLists($marketingLists)
            ->setName($name)
            ->setOpportunities($opportunities)
            ->setOrders($orders)
            ->setOwner($owner)
            ->setOwnerEmployeeName($ownerEmployeeName)
            ->setParentAccount($parentAccount)
            ->setRelations($relations)
            ->setShippingAddress($shippingAddress)
            ->setShippingAddressSameAsMain($shippingAddressSameAsMain)
            ->setShippingAddressValidated($shippingAddressValidated)
            ->setShippingContact($shippingContact)
            ->setSourceCampaign($sourceCampaign)
            ->setStatus($status)
            ->setType($type)
            ->setWorkgroup($workgroup)
            ->setWorkgroupDescription($workgroupDescription);
    }
    /**
     * Get AccountRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccountRef()
    {
        return isset($this->AccountRef) ? $this->AccountRef : null;
    }
    /**
     * Set AccountRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $accountRef
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setAccountRef(\App\API\SOAP\StructType\StringValue $accountRef = null)
    {
        if (is_null($accountRef) || (is_array($accountRef) && empty($accountRef))) {
            unset($this->AccountRef);
        } else {
            $this->AccountRef = $accountRef;
        }
        return $this;
    }
    /**
     * Get Activities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Activities|null
     */
    public function getActivities()
    {
        return isset($this->Activities) ? $this->Activities : null;
    }
    /**
     * Set Activities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Activities $activities
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setActivities(\App\API\SOAP\StructType\Activities $activities = null)
    {
        if (is_null($activities) || (is_array($activities) && empty($activities))) {
            unset($this->Activities);
        } else {
            $this->Activities = $activities;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Attributes $attributes
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setAttributes(\App\API\SOAP\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get BusinessAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBusinessAccountID()
    {
        return isset($this->BusinessAccountID) ? $this->BusinessAccountID : null;
    }
    /**
     * Set BusinessAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $businessAccountID
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setBusinessAccountID(\App\API\SOAP\StructType\StringValue $businessAccountID = null)
    {
        if (is_null($businessAccountID) || (is_array($businessAccountID) && empty($businessAccountID))) {
            unset($this->BusinessAccountID);
        } else {
            $this->BusinessAccountID = $businessAccountID;
        }
        return $this;
    }
    /**
     * Get Campaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Campaigns|null
     */
    public function getCampaigns()
    {
        return isset($this->Campaigns) ? $this->Campaigns : null;
    }
    /**
     * Set Campaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Campaigns $campaigns
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setCampaigns(\App\API\SOAP\StructType\Campaigns $campaigns = null)
    {
        if (is_null($campaigns) || (is_array($campaigns) && empty($campaigns))) {
            unset($this->Campaigns);
        } else {
            $this->Campaigns = $campaigns;
        }
        return $this;
    }
    /**
     * Get Cases value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Cases|null
     */
    public function getCases()
    {
        return isset($this->Cases) ? $this->Cases : null;
    }
    /**
     * Set Cases value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Cases $cases
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setCases(\App\API\SOAP\StructType\Cases $cases = null)
    {
        if (is_null($cases) || (is_array($cases) && empty($cases))) {
            unset($this->Cases);
        } else {
            $this->Cases = $cases;
        }
        return $this;
    }
    /**
     * Get ClassID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getClassID()
    {
        return isset($this->ClassID) ? $this->ClassID : null;
    }
    /**
     * Set ClassID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $classID
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setClassID(\App\API\SOAP\StructType\StringValue $classID = null)
    {
        if (is_null($classID) || (is_array($classID) && empty($classID))) {
            unset($this->ClassID);
        } else {
            $this->ClassID = $classID;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Contacts $contacts
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setContacts(\App\API\SOAP\StructType\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get Contracts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Contracts|null
     */
    public function getContracts()
    {
        return isset($this->Contracts) ? $this->Contracts : null;
    }
    /**
     * Set Contracts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Contracts $contracts
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setContracts(\App\API\SOAP\StructType\Contracts $contracts = null)
    {
        if (is_null($contracts) || (is_array($contracts) && empty($contracts))) {
            unset($this->Contracts);
        } else {
            $this->Contracts = $contracts;
        }
        return $this;
    }
    /**
     * Get DefaultLocationSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BusinessAccountDefaultLocationSetting|null
     */
    public function getDefaultLocationSettings()
    {
        return isset($this->DefaultLocationSettings) ? $this->DefaultLocationSettings : null;
    }
    /**
     * Set DefaultLocationSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BusinessAccountDefaultLocationSetting $defaultLocationSettings
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setDefaultLocationSettings(\App\API\SOAP\StructType\BusinessAccountDefaultLocationSetting $defaultLocationSettings = null)
    {
        if (is_null($defaultLocationSettings) || (is_array($defaultLocationSettings) && empty($defaultLocationSettings))) {
            unset($this->DefaultLocationSettings);
        } else {
            $this->DefaultLocationSettings = $defaultLocationSettings;
        }
        return $this;
    }
    /**
     * Get Duplicate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDuplicate()
    {
        return isset($this->Duplicate) ? $this->Duplicate : null;
    }
    /**
     * Set Duplicate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $duplicate
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setDuplicate(\App\API\SOAP\StructType\StringValue $duplicate = null)
    {
        if (is_null($duplicate) || (is_array($duplicate) && empty($duplicate))) {
            unset($this->Duplicate);
        } else {
            $this->Duplicate = $duplicate;
        }
        return $this;
    }
    /**
     * Get Duplicates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Duplicates|null
     */
    public function getDuplicates()
    {
        return isset($this->Duplicates) ? $this->Duplicates : null;
    }
    /**
     * Set Duplicates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Duplicates $duplicates
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setDuplicates(\App\API\SOAP\StructType\Duplicates $duplicates = null)
    {
        if (is_null($duplicates) || (is_array($duplicates) && empty($duplicates))) {
            unset($this->Duplicates);
        } else {
            $this->Duplicates = $duplicates;
        }
        return $this;
    }
    /**
     * Get LastIncomingActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastIncomingActivity()
    {
        return isset($this->LastIncomingActivity) ? $this->LastIncomingActivity : null;
    }
    /**
     * Set LastIncomingActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastIncomingActivity
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setLastIncomingActivity(\App\API\SOAP\StructType\DateTimeValue $lastIncomingActivity = null)
    {
        if (is_null($lastIncomingActivity) || (is_array($lastIncomingActivity) && empty($lastIncomingActivity))) {
            unset($this->LastIncomingActivity);
        } else {
            $this->LastIncomingActivity = $lastIncomingActivity;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setLastModifiedDateTime(\App\API\SOAP\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LastOutgoingActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getLastOutgoingActivity()
    {
        return isset($this->LastOutgoingActivity) ? $this->LastOutgoingActivity : null;
    }
    /**
     * Set LastOutgoingActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $lastOutgoingActivity
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setLastOutgoingActivity(\App\API\SOAP\StructType\DateTimeValue $lastOutgoingActivity = null)
    {
        if (is_null($lastOutgoingActivity) || (is_array($lastOutgoingActivity) && empty($lastOutgoingActivity))) {
            unset($this->LastOutgoingActivity);
        } else {
            $this->LastOutgoingActivity = $lastOutgoingActivity;
        }
        return $this;
    }
    /**
     * Get Locations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Locations|null
     */
    public function getLocations()
    {
        return isset($this->Locations) ? $this->Locations : null;
    }
    /**
     * Set Locations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Locations $locations
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setLocations(\App\API\SOAP\StructType\Locations $locations = null)
    {
        if (is_null($locations) || (is_array($locations) && empty($locations))) {
            unset($this->Locations);
        } else {
            $this->Locations = $locations;
        }
        return $this;
    }
    /**
     * Get MainAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Address|null
     */
    public function getMainAddress()
    {
        return isset($this->MainAddress) ? $this->MainAddress : null;
    }
    /**
     * Set MainAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Address $mainAddress
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setMainAddress(\App\API\SOAP\StructType\Address $mainAddress = null)
    {
        if (is_null($mainAddress) || (is_array($mainAddress) && empty($mainAddress))) {
            unset($this->MainAddress);
        } else {
            $this->MainAddress = $mainAddress;
        }
        return $this;
    }
    /**
     * Get MainAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getMainAddressValidated()
    {
        return isset($this->MainAddressValidated) ? $this->MainAddressValidated : null;
    }
    /**
     * Set MainAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $mainAddressValidated
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setMainAddressValidated(\App\API\SOAP\StructType\BooleanValue $mainAddressValidated = null)
    {
        if (is_null($mainAddressValidated) || (is_array($mainAddressValidated) && empty($mainAddressValidated))) {
            unset($this->MainAddressValidated);
        } else {
            $this->MainAddressValidated = $mainAddressValidated;
        }
        return $this;
    }
    /**
     * Get MainContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BusinessAccountMainContact|null
     */
    public function getMainContact()
    {
        return isset($this->MainContact) ? $this->MainContact : null;
    }
    /**
     * Set MainContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BusinessAccountMainContact $mainContact
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setMainContact(\App\API\SOAP\StructType\BusinessAccountMainContact $mainContact = null)
    {
        if (is_null($mainContact) || (is_array($mainContact) && empty($mainContact))) {
            unset($this->MainContact);
        } else {
            $this->MainContact = $mainContact;
        }
        return $this;
    }
    /**
     * Get MarketingLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\MarketingLists|null
     */
    public function getMarketingLists()
    {
        return isset($this->MarketingLists) ? $this->MarketingLists : null;
    }
    /**
     * Set MarketingLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\MarketingLists $marketingLists
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setMarketingLists(\App\API\SOAP\StructType\MarketingLists $marketingLists = null)
    {
        if (is_null($marketingLists) || (is_array($marketingLists) && empty($marketingLists))) {
            unset($this->MarketingLists);
        } else {
            $this->MarketingLists = $marketingLists;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $name
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setName(\App\API\SOAP\StructType\StringValue $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Opportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Opportunities|null
     */
    public function getOpportunities()
    {
        return isset($this->Opportunities) ? $this->Opportunities : null;
    }
    /**
     * Set Opportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Opportunities $opportunities
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setOpportunities(\App\API\SOAP\StructType\Opportunities $opportunities = null)
    {
        if (is_null($opportunities) || (is_array($opportunities) && empty($opportunities))) {
            unset($this->Opportunities);
        } else {
            $this->Opportunities = $opportunities;
        }
        return $this;
    }
    /**
     * Get Orders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Orders|null
     */
    public function getOrders()
    {
        return isset($this->Orders) ? $this->Orders : null;
    }
    /**
     * Set Orders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Orders $orders
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setOrders(\App\API\SOAP\StructType\Orders $orders = null)
    {
        if (is_null($orders) || (is_array($orders) && empty($orders))) {
            unset($this->Orders);
        } else {
            $this->Orders = $orders;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $owner
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setOwner(\App\API\SOAP\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerEmployeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getOwnerEmployeeName()
    {
        return isset($this->OwnerEmployeeName) ? $this->OwnerEmployeeName : null;
    }
    /**
     * Set OwnerEmployeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $ownerEmployeeName
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setOwnerEmployeeName(\App\API\SOAP\StructType\StringValue $ownerEmployeeName = null)
    {
        if (is_null($ownerEmployeeName) || (is_array($ownerEmployeeName) && empty($ownerEmployeeName))) {
            unset($this->OwnerEmployeeName);
        } else {
            $this->OwnerEmployeeName = $ownerEmployeeName;
        }
        return $this;
    }
    /**
     * Get ParentAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getParentAccount()
    {
        return isset($this->ParentAccount) ? $this->ParentAccount : null;
    }
    /**
     * Set ParentAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $parentAccount
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setParentAccount(\App\API\SOAP\StructType\StringValue $parentAccount = null)
    {
        if (is_null($parentAccount) || (is_array($parentAccount) && empty($parentAccount))) {
            unset($this->ParentAccount);
        } else {
            $this->ParentAccount = $parentAccount;
        }
        return $this;
    }
    /**
     * Get Relations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Relations|null
     */
    public function getRelations()
    {
        return isset($this->Relations) ? $this->Relations : null;
    }
    /**
     * Set Relations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Relations $relations
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setRelations(\App\API\SOAP\StructType\Relations $relations = null)
    {
        if (is_null($relations) || (is_array($relations) && empty($relations))) {
            unset($this->Relations);
        } else {
            $this->Relations = $relations;
        }
        return $this;
    }
    /**
     * Get ShippingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Address|null
     */
    public function getShippingAddress()
    {
        return isset($this->ShippingAddress) ? $this->ShippingAddress : null;
    }
    /**
     * Set ShippingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Address $shippingAddress
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setShippingAddress(\App\API\SOAP\StructType\Address $shippingAddress = null)
    {
        if (is_null($shippingAddress) || (is_array($shippingAddress) && empty($shippingAddress))) {
            unset($this->ShippingAddress);
        } else {
            $this->ShippingAddress = $shippingAddress;
        }
        return $this;
    }
    /**
     * Get ShippingAddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShippingAddressSameAsMain()
    {
        return isset($this->ShippingAddressSameAsMain) ? $this->ShippingAddressSameAsMain : null;
    }
    /**
     * Set ShippingAddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shippingAddressSameAsMain
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setShippingAddressSameAsMain(\App\API\SOAP\StructType\BooleanValue $shippingAddressSameAsMain = null)
    {
        if (is_null($shippingAddressSameAsMain) || (is_array($shippingAddressSameAsMain) && empty($shippingAddressSameAsMain))) {
            unset($this->ShippingAddressSameAsMain);
        } else {
            $this->ShippingAddressSameAsMain = $shippingAddressSameAsMain;
        }
        return $this;
    }
    /**
     * Get ShippingAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getShippingAddressValidated()
    {
        return isset($this->ShippingAddressValidated) ? $this->ShippingAddressValidated : null;
    }
    /**
     * Set ShippingAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $shippingAddressValidated
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setShippingAddressValidated(\App\API\SOAP\StructType\BooleanValue $shippingAddressValidated = null)
    {
        if (is_null($shippingAddressValidated) || (is_array($shippingAddressValidated) && empty($shippingAddressValidated))) {
            unset($this->ShippingAddressValidated);
        } else {
            $this->ShippingAddressValidated = $shippingAddressValidated;
        }
        return $this;
    }
    /**
     * Get ShippingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BusinessAccountShippingContact|null
     */
    public function getShippingContact()
    {
        return isset($this->ShippingContact) ? $this->ShippingContact : null;
    }
    /**
     * Set ShippingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BusinessAccountShippingContact $shippingContact
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setShippingContact(\App\API\SOAP\StructType\BusinessAccountShippingContact $shippingContact = null)
    {
        if (is_null($shippingContact) || (is_array($shippingContact) && empty($shippingContact))) {
            unset($this->ShippingContact);
        } else {
            $this->ShippingContact = $shippingContact;
        }
        return $this;
    }
    /**
     * Get SourceCampaign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSourceCampaign()
    {
        return isset($this->SourceCampaign) ? $this->SourceCampaign : null;
    }
    /**
     * Set SourceCampaign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $sourceCampaign
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setSourceCampaign(\App\API\SOAP\StructType\StringValue $sourceCampaign = null)
    {
        if (is_null($sourceCampaign) || (is_array($sourceCampaign) && empty($sourceCampaign))) {
            unset($this->SourceCampaign);
        } else {
            $this->SourceCampaign = $sourceCampaign;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $type
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setType(\App\API\SOAP\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Workgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWorkgroup()
    {
        return isset($this->Workgroup) ? $this->Workgroup : null;
    }
    /**
     * Set Workgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $workgroup
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setWorkgroup(\App\API\SOAP\StructType\StringValue $workgroup = null)
    {
        if (is_null($workgroup) || (is_array($workgroup) && empty($workgroup))) {
            unset($this->Workgroup);
        } else {
            $this->Workgroup = $workgroup;
        }
        return $this;
    }
    /**
     * Get WorkgroupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWorkgroupDescription()
    {
        return isset($this->WorkgroupDescription) ? $this->WorkgroupDescription : null;
    }
    /**
     * Set WorkgroupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $workgroupDescription
     * @return \App\API\SOAP\StructType\BusinessAccount
     */
    public function setWorkgroupDescription(\App\API\SOAP\StructType\StringValue $workgroupDescription = null)
    {
        if (is_null($workgroupDescription) || (is_array($workgroupDescription) && empty($workgroupDescription))) {
            unset($this->WorkgroupDescription);
        } else {
            $this->WorkgroupDescription = $workgroupDescription;
        }
        return $this;
    }
}
