<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Boxes StructType
 * @subpackage Structs
 */
class Boxes extends AbstractStructBase
{
    /**
     * The BoxStockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BoxStockItem[]
     */
    public $BoxStockItem;
    /**
     * Constructor method for Boxes
     * @uses Boxes::setBoxStockItem()
     * @param \App\API\SOAP\StructType\BoxStockItem[] $boxStockItem
     */
    public function __construct(array $boxStockItem = array())
    {
        $this
            ->setBoxStockItem($boxStockItem);
    }
    /**
     * Get BoxStockItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BoxStockItem[]|null
     */
    public function getBoxStockItem()
    {
        return isset($this->BoxStockItem) ? $this->BoxStockItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBoxStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBoxStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBoxStockItemForArrayConstraintsFromSetBoxStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $boxesBoxStockItemItem) {
            // validation for constraint: itemType
            if (!$boxesBoxStockItemItem instanceof \App\API\SOAP\StructType\BoxStockItem) {
                $invalidValues[] = is_object($boxesBoxStockItemItem) ? get_class($boxesBoxStockItemItem) : sprintf('%s(%s)', gettype($boxesBoxStockItemItem), var_export($boxesBoxStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BoxStockItem property can only contain items of type \App\API\SOAP\StructType\BoxStockItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BoxStockItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BoxStockItem[] $boxStockItem
     * @return \App\API\SOAP\StructType\Boxes
     */
    public function setBoxStockItem(array $boxStockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($boxStockItemArrayErrorMessage = self::validateBoxStockItemForArrayConstraintsFromSetBoxStockItem($boxStockItem))) {
            throw new \InvalidArgumentException($boxStockItemArrayErrorMessage, __LINE__);
        }
        if (is_null($boxStockItem) || (is_array($boxStockItem) && empty($boxStockItem))) {
            unset($this->BoxStockItem);
        } else {
            $this->BoxStockItem = $boxStockItem;
        }
        return $this;
    }
    /**
     * Add item to BoxStockItem value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BoxStockItem $item
     * @return \App\API\SOAP\StructType\Boxes
     */
    public function addToBoxStockItem(\App\API\SOAP\StructType\BoxStockItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\BoxStockItem) {
            throw new \InvalidArgumentException(sprintf('The BoxStockItem property can only contain items of type \App\API\SOAP\StructType\BoxStockItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BoxStockItem[] = $item;
        return $this;
    }
}
