<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BilledTransactions StructType
 * @subpackage Structs
 */
class BilledTransactions extends AbstractStructBase
{
    /**
     * The ContractUsageTransactionDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ContractUsageTransactionDetail[]
     */
    public $ContractUsageTransactionDetail;
    /**
     * Constructor method for BilledTransactions
     * @uses BilledTransactions::setContractUsageTransactionDetail()
     * @param \App\API\SOAP\StructType\ContractUsageTransactionDetail[] $contractUsageTransactionDetail
     */
    public function __construct(array $contractUsageTransactionDetail = array())
    {
        $this
            ->setContractUsageTransactionDetail($contractUsageTransactionDetail);
    }
    /**
     * Get ContractUsageTransactionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ContractUsageTransactionDetail[]|null
     */
    public function getContractUsageTransactionDetail()
    {
        return isset($this->ContractUsageTransactionDetail) ? $this->ContractUsageTransactionDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContractUsageTransactionDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContractUsageTransactionDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractUsageTransactionDetailForArrayConstraintsFromSetContractUsageTransactionDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billedTransactionsContractUsageTransactionDetailItem) {
            // validation for constraint: itemType
            if (!$billedTransactionsContractUsageTransactionDetailItem instanceof \App\API\SOAP\StructType\ContractUsageTransactionDetail) {
                $invalidValues[] = is_object($billedTransactionsContractUsageTransactionDetailItem) ? get_class($billedTransactionsContractUsageTransactionDetailItem) : sprintf('%s(%s)', gettype($billedTransactionsContractUsageTransactionDetailItem), var_export($billedTransactionsContractUsageTransactionDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContractUsageTransactionDetail property can only contain items of type \App\API\SOAP\StructType\ContractUsageTransactionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContractUsageTransactionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ContractUsageTransactionDetail[] $contractUsageTransactionDetail
     * @return \App\API\SOAP\StructType\BilledTransactions
     */
    public function setContractUsageTransactionDetail(array $contractUsageTransactionDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($contractUsageTransactionDetailArrayErrorMessage = self::validateContractUsageTransactionDetailForArrayConstraintsFromSetContractUsageTransactionDetail($contractUsageTransactionDetail))) {
            throw new \InvalidArgumentException($contractUsageTransactionDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($contractUsageTransactionDetail) || (is_array($contractUsageTransactionDetail) && empty($contractUsageTransactionDetail))) {
            unset($this->ContractUsageTransactionDetail);
        } else {
            $this->ContractUsageTransactionDetail = $contractUsageTransactionDetail;
        }
        return $this;
    }
    /**
     * Add item to ContractUsageTransactionDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ContractUsageTransactionDetail $item
     * @return \App\API\SOAP\StructType\BilledTransactions
     */
    public function addToContractUsageTransactionDetail(\App\API\SOAP\StructType\ContractUsageTransactionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ContractUsageTransactionDetail) {
            throw new \InvalidArgumentException(sprintf('The ContractUsageTransactionDetail property can only contain items of type \App\API\SOAP\StructType\ContractUsageTransactionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContractUsageTransactionDetail[] = $item;
        return $this;
    }
}
