<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillToSettings StructType
 * @subpackage Structs
 */
class BillToSettings extends Entity
{
    /**
     * The BillToAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\Address
     */
    public $BillToAddress;
    /**
     * The BillToAddressOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $BillToAddressOverride;
    /**
     * The BillToContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DocContact
     */
    public $BillToContact;
    /**
     * The BillToContactOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $BillToContactOverride;
    /**
     * The CustomerLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CustomerLocation;
    /**
     * Constructor method for BillToSettings
     * @uses BillToSettings::setBillToAddress()
     * @uses BillToSettings::setBillToAddressOverride()
     * @uses BillToSettings::setBillToContact()
     * @uses BillToSettings::setBillToContactOverride()
     * @uses BillToSettings::setCustomerLocation()
     * @param \App\API\SOAP\StructType\Address $billToAddress
     * @param \App\API\SOAP\StructType\BooleanValue $billToAddressOverride
     * @param \App\API\SOAP\StructType\DocContact $billToContact
     * @param \App\API\SOAP\StructType\BooleanValue $billToContactOverride
     * @param \App\API\SOAP\StructType\StringValue $customerLocation
     */
    public function __construct(\App\API\SOAP\StructType\Address $billToAddress = null, \App\API\SOAP\StructType\BooleanValue $billToAddressOverride = null, \App\API\SOAP\StructType\DocContact $billToContact = null, \App\API\SOAP\StructType\BooleanValue $billToContactOverride = null, \App\API\SOAP\StructType\StringValue $customerLocation = null)
    {
        $this
            ->setBillToAddress($billToAddress)
            ->setBillToAddressOverride($billToAddressOverride)
            ->setBillToContact($billToContact)
            ->setBillToContactOverride($billToContactOverride)
            ->setCustomerLocation($customerLocation);
    }
    /**
     * Get BillToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\Address|null
     */
    public function getBillToAddress()
    {
        return isset($this->BillToAddress) ? $this->BillToAddress : null;
    }
    /**
     * Set BillToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\Address $billToAddress
     * @return \App\API\SOAP\StructType\BillToSettings
     */
    public function setBillToAddress(\App\API\SOAP\StructType\Address $billToAddress = null)
    {
        if (is_null($billToAddress) || (is_array($billToAddress) && empty($billToAddress))) {
            unset($this->BillToAddress);
        } else {
            $this->BillToAddress = $billToAddress;
        }
        return $this;
    }
    /**
     * Get BillToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillToAddressOverride()
    {
        return isset($this->BillToAddressOverride) ? $this->BillToAddressOverride : null;
    }
    /**
     * Set BillToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billToAddressOverride
     * @return \App\API\SOAP\StructType\BillToSettings
     */
    public function setBillToAddressOverride(\App\API\SOAP\StructType\BooleanValue $billToAddressOverride = null)
    {
        if (is_null($billToAddressOverride) || (is_array($billToAddressOverride) && empty($billToAddressOverride))) {
            unset($this->BillToAddressOverride);
        } else {
            $this->BillToAddressOverride = $billToAddressOverride;
        }
        return $this;
    }
    /**
     * Get BillToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DocContact|null
     */
    public function getBillToContact()
    {
        return isset($this->BillToContact) ? $this->BillToContact : null;
    }
    /**
     * Set BillToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DocContact $billToContact
     * @return \App\API\SOAP\StructType\BillToSettings
     */
    public function setBillToContact(\App\API\SOAP\StructType\DocContact $billToContact = null)
    {
        if (is_null($billToContact) || (is_array($billToContact) && empty($billToContact))) {
            unset($this->BillToContact);
        } else {
            $this->BillToContact = $billToContact;
        }
        return $this;
    }
    /**
     * Get BillToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getBillToContactOverride()
    {
        return isset($this->BillToContactOverride) ? $this->BillToContactOverride : null;
    }
    /**
     * Set BillToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $billToContactOverride
     * @return \App\API\SOAP\StructType\BillToSettings
     */
    public function setBillToContactOverride(\App\API\SOAP\StructType\BooleanValue $billToContactOverride = null)
    {
        if (is_null($billToContactOverride) || (is_array($billToContactOverride) && empty($billToContactOverride))) {
            unset($this->BillToContactOverride);
        } else {
            $this->BillToContactOverride = $billToContactOverride;
        }
        return $this;
    }
    /**
     * Get CustomerLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCustomerLocation()
    {
        return isset($this->CustomerLocation) ? $this->CustomerLocation : null;
    }
    /**
     * Set CustomerLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $customerLocation
     * @return \App\API\SOAP\StructType\BillToSettings
     */
    public function setCustomerLocation(\App\API\SOAP\StructType\StringValue $customerLocation = null)
    {
        if (is_null($customerLocation) || (is_array($customerLocation) && empty($customerLocation))) {
            unset($this->CustomerLocation);
        } else {
            $this->CustomerLocation = $customerLocation;
        }
        return $this;
    }
}
