<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillTaxDetail StructType
 * @subpackage Structs
 */
class BillTaxDetail extends Entity
{
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxAmount;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $TaxRate;
    /**
     * Constructor method for BillTaxDetail
     * @uses BillTaxDetail::setTaxableAmount()
     * @uses BillTaxDetail::setTaxAmount()
     * @uses BillTaxDetail::setTaxID()
     * @uses BillTaxDetail::setTaxRate()
     * @param \App\API\SOAP\StructType\DecimalValue $taxableAmount
     * @param \App\API\SOAP\StructType\DecimalValue $taxAmount
     * @param \App\API\SOAP\StructType\StringValue $taxID
     * @param \App\API\SOAP\StructType\DecimalValue $taxRate
     */
    public function __construct(\App\API\SOAP\StructType\DecimalValue $taxableAmount = null, \App\API\SOAP\StructType\DecimalValue $taxAmount = null, \App\API\SOAP\StructType\StringValue $taxID = null, \App\API\SOAP\StructType\DecimalValue $taxRate = null)
    {
        $this
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate);
    }
    /**
     * Get TaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxableAmount()
    {
        return isset($this->TaxableAmount) ? $this->TaxableAmount : null;
    }
    /**
     * Set TaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxableAmount
     * @return \App\API\SOAP\StructType\BillTaxDetail
     */
    public function setTaxableAmount(\App\API\SOAP\StructType\DecimalValue $taxableAmount = null)
    {
        if (is_null($taxableAmount) || (is_array($taxableAmount) && empty($taxableAmount))) {
            unset($this->TaxableAmount);
        } else {
            $this->TaxableAmount = $taxableAmount;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxAmount
     * @return \App\API\SOAP\StructType\BillTaxDetail
     */
    public function setTaxAmount(\App\API\SOAP\StructType\DecimalValue $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxID
     * @return \App\API\SOAP\StructType\BillTaxDetail
     */
    public function setTaxID(\App\API\SOAP\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getTaxRate()
    {
        return isset($this->TaxRate) ? $this->TaxRate : null;
    }
    /**
     * Set TaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $taxRate
     * @return \App\API\SOAP\StructType\BillTaxDetail
     */
    public function setTaxRate(\App\API\SOAP\StructType\DecimalValue $taxRate = null)
    {
        if (is_null($taxRate) || (is_array($taxRate) && empty($taxRate))) {
            unset($this->TaxRate);
        } else {
            $this->TaxRate = $taxRate;
        }
        return $this;
    }
}
