<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillDetail StructType
 * @subpackage Structs
 */
class BillDetail extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Account;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Branch;
    /**
     * The CalculateDiscountsOnImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $CalculateDiscountsOnImport;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $CostCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The ExtendedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $ExtendedCost;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The NonBillable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $NonBillable;
    /**
     * The POLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $POLine;
    /**
     * The POOrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $POOrderNbr;
    /**
     * The POOrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $POOrderType;
    /**
     * The POReceiptLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\IntValue
     */
    public $POReceiptLine;
    /**
     * The POReceiptNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $POReceiptNbr;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Project;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Subaccount;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TransactionDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $TransactionDescription;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for BillDetail
     * @uses BillDetail::setAccount()
     * @uses BillDetail::setAmount()
     * @uses BillDetail::setBranch()
     * @uses BillDetail::setCalculateDiscountsOnImport()
     * @uses BillDetail::setCostCode()
     * @uses BillDetail::setDescription()
     * @uses BillDetail::setExtendedCost()
     * @uses BillDetail::setInventoryID()
     * @uses BillDetail::setNonBillable()
     * @uses BillDetail::setPOLine()
     * @uses BillDetail::setPOOrderNbr()
     * @uses BillDetail::setPOOrderType()
     * @uses BillDetail::setPOReceiptLine()
     * @uses BillDetail::setPOReceiptNbr()
     * @uses BillDetail::setProject()
     * @uses BillDetail::setProjectTask()
     * @uses BillDetail::setQty()
     * @uses BillDetail::setSubaccount()
     * @uses BillDetail::setTaxCategory()
     * @uses BillDetail::setTransactionDescription()
     * @uses BillDetail::setUnitCost()
     * @uses BillDetail::setUOM()
     * @param \App\API\SOAP\StructType\StringValue $account
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @param \App\API\SOAP\StructType\BooleanValue $calculateDiscountsOnImport
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\DecimalValue $extendedCost
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @param \App\API\SOAP\StructType\BooleanValue $nonBillable
     * @param \App\API\SOAP\StructType\IntValue $pOLine
     * @param \App\API\SOAP\StructType\StringValue $pOOrderNbr
     * @param \App\API\SOAP\StructType\StringValue $pOOrderType
     * @param \App\API\SOAP\StructType\IntValue $pOReceiptLine
     * @param \App\API\SOAP\StructType\StringValue $pOReceiptNbr
     * @param \App\API\SOAP\StructType\StringValue $project
     * @param \App\API\SOAP\StructType\StringValue $projectTask
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @param \App\API\SOAP\StructType\StringValue $subaccount
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @param \App\API\SOAP\StructType\StringValue $transactionDescription
     * @param \App\API\SOAP\StructType\DecimalValue $unitCost
     * @param \App\API\SOAP\StructType\StringValue $uOM
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $account = null, \App\API\SOAP\StructType\DecimalValue $amount = null, \App\API\SOAP\StructType\StringValue $branch = null, \App\API\SOAP\StructType\BooleanValue $calculateDiscountsOnImport = null, \App\API\SOAP\StructType\StringValue $costCode = null, \App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\DecimalValue $extendedCost = null, \App\API\SOAP\StructType\StringValue $inventoryID = null, \App\API\SOAP\StructType\BooleanValue $nonBillable = null, \App\API\SOAP\StructType\IntValue $pOLine = null, \App\API\SOAP\StructType\StringValue $pOOrderNbr = null, \App\API\SOAP\StructType\StringValue $pOOrderType = null, \App\API\SOAP\StructType\IntValue $pOReceiptLine = null, \App\API\SOAP\StructType\StringValue $pOReceiptNbr = null, \App\API\SOAP\StructType\StringValue $project = null, \App\API\SOAP\StructType\StringValue $projectTask = null, \App\API\SOAP\StructType\DecimalValue $qty = null, \App\API\SOAP\StructType\StringValue $subaccount = null, \App\API\SOAP\StructType\StringValue $taxCategory = null, \App\API\SOAP\StructType\StringValue $transactionDescription = null, \App\API\SOAP\StructType\DecimalValue $unitCost = null, \App\API\SOAP\StructType\StringValue $uOM = null)
    {
        $this
            ->setAccount($account)
            ->setAmount($amount)
            ->setBranch($branch)
            ->setCalculateDiscountsOnImport($calculateDiscountsOnImport)
            ->setCostCode($costCode)
            ->setDescription($description)
            ->setExtendedCost($extendedCost)
            ->setInventoryID($inventoryID)
            ->setNonBillable($nonBillable)
            ->setPOLine($pOLine)
            ->setPOOrderNbr($pOOrderNbr)
            ->setPOOrderType($pOOrderType)
            ->setPOReceiptLine($pOReceiptLine)
            ->setPOReceiptNbr($pOReceiptNbr)
            ->setProject($project)
            ->setProjectTask($projectTask)
            ->setQty($qty)
            ->setSubaccount($subaccount)
            ->setTaxCategory($taxCategory)
            ->setTransactionDescription($transactionDescription)
            ->setUnitCost($unitCost)
            ->setUOM($uOM);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $account
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setAccount(\App\API\SOAP\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $amount
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setAmount(\App\API\SOAP\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $branch
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setBranch(\App\API\SOAP\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CalculateDiscountsOnImport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getCalculateDiscountsOnImport()
    {
        return isset($this->CalculateDiscountsOnImport) ? $this->CalculateDiscountsOnImport : null;
    }
    /**
     * Set CalculateDiscountsOnImport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $calculateDiscountsOnImport
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setCalculateDiscountsOnImport(\App\API\SOAP\StructType\BooleanValue $calculateDiscountsOnImport = null)
    {
        if (is_null($calculateDiscountsOnImport) || (is_array($calculateDiscountsOnImport) && empty($calculateDiscountsOnImport))) {
            unset($this->CalculateDiscountsOnImport);
        } else {
            $this->CalculateDiscountsOnImport = $calculateDiscountsOnImport;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $costCode
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setCostCode(\App\API\SOAP\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExtendedCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getExtendedCost()
    {
        return isset($this->ExtendedCost) ? $this->ExtendedCost : null;
    }
    /**
     * Set ExtendedCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $extendedCost
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setExtendedCost(\App\API\SOAP\StructType\DecimalValue $extendedCost = null)
    {
        if (is_null($extendedCost) || (is_array($extendedCost) && empty($extendedCost))) {
            unset($this->ExtendedCost);
        } else {
            $this->ExtendedCost = $extendedCost;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $inventoryID
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setInventoryID(\App\API\SOAP\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get NonBillable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getNonBillable()
    {
        return isset($this->NonBillable) ? $this->NonBillable : null;
    }
    /**
     * Set NonBillable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $nonBillable
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setNonBillable(\App\API\SOAP\StructType\BooleanValue $nonBillable = null)
    {
        if (is_null($nonBillable) || (is_array($nonBillable) && empty($nonBillable))) {
            unset($this->NonBillable);
        } else {
            $this->NonBillable = $nonBillable;
        }
        return $this;
    }
    /**
     * Get POLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getPOLine()
    {
        return isset($this->POLine) ? $this->POLine : null;
    }
    /**
     * Set POLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $pOLine
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setPOLine(\App\API\SOAP\StructType\IntValue $pOLine = null)
    {
        if (is_null($pOLine) || (is_array($pOLine) && empty($pOLine))) {
            unset($this->POLine);
        } else {
            $this->POLine = $pOLine;
        }
        return $this;
    }
    /**
     * Get POOrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPOOrderNbr()
    {
        return isset($this->POOrderNbr) ? $this->POOrderNbr : null;
    }
    /**
     * Set POOrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $pOOrderNbr
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setPOOrderNbr(\App\API\SOAP\StructType\StringValue $pOOrderNbr = null)
    {
        if (is_null($pOOrderNbr) || (is_array($pOOrderNbr) && empty($pOOrderNbr))) {
            unset($this->POOrderNbr);
        } else {
            $this->POOrderNbr = $pOOrderNbr;
        }
        return $this;
    }
    /**
     * Get POOrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPOOrderType()
    {
        return isset($this->POOrderType) ? $this->POOrderType : null;
    }
    /**
     * Set POOrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $pOOrderType
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setPOOrderType(\App\API\SOAP\StructType\StringValue $pOOrderType = null)
    {
        if (is_null($pOOrderType) || (is_array($pOOrderType) && empty($pOOrderType))) {
            unset($this->POOrderType);
        } else {
            $this->POOrderType = $pOOrderType;
        }
        return $this;
    }
    /**
     * Get POReceiptLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\IntValue|null
     */
    public function getPOReceiptLine()
    {
        return isset($this->POReceiptLine) ? $this->POReceiptLine : null;
    }
    /**
     * Set POReceiptLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\IntValue $pOReceiptLine
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setPOReceiptLine(\App\API\SOAP\StructType\IntValue $pOReceiptLine = null)
    {
        if (is_null($pOReceiptLine) || (is_array($pOReceiptLine) && empty($pOReceiptLine))) {
            unset($this->POReceiptLine);
        } else {
            $this->POReceiptLine = $pOReceiptLine;
        }
        return $this;
    }
    /**
     * Get POReceiptNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getPOReceiptNbr()
    {
        return isset($this->POReceiptNbr) ? $this->POReceiptNbr : null;
    }
    /**
     * Set POReceiptNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $pOReceiptNbr
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setPOReceiptNbr(\App\API\SOAP\StructType\StringValue $pOReceiptNbr = null)
    {
        if (is_null($pOReceiptNbr) || (is_array($pOReceiptNbr) && empty($pOReceiptNbr))) {
            unset($this->POReceiptNbr);
        } else {
            $this->POReceiptNbr = $pOReceiptNbr;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $project
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setProject(\App\API\SOAP\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $projectTask
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setProjectTask(\App\API\SOAP\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $qty
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setQty(\App\API\SOAP\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $subaccount
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setSubaccount(\App\API\SOAP\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $taxCategory
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setTaxCategory(\App\API\SOAP\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TransactionDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getTransactionDescription()
    {
        return isset($this->TransactionDescription) ? $this->TransactionDescription : null;
    }
    /**
     * Set TransactionDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $transactionDescription
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setTransactionDescription(\App\API\SOAP\StructType\StringValue $transactionDescription = null)
    {
        if (is_null($transactionDescription) || (is_array($transactionDescription) && empty($transactionDescription))) {
            unset($this->TransactionDescription);
        } else {
            $this->TransactionDescription = $transactionDescription;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DecimalValue $unitCost
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setUnitCost(\App\API\SOAP\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $uOM
     * @return \App\API\SOAP\StructType\BillDetail
     */
    public function setUOM(\App\API\SOAP\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
