<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attributes StructType
 * @subpackage Structs
 */
class Attributes extends AbstractStructBase
{
    /**
     * The BusinessAccountClassAttributeDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail[]
     */
    public $BusinessAccountClassAttributeDetail;
    /**
     * The AttributeDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AttributeDetail[]
     */
    public $AttributeDetail;
    /**
     * The AttributeValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AttributeValue[]
     */
    public $AttributeValue;
    /**
     * The NonStockItemAttribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\NonStockItemAttribute[]
     */
    public $NonStockItemAttribute;
    /**
     * The ItemClassAtrribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ItemClassAtrribute[]
     */
    public $ItemClassAtrribute;
    /**
     * Constructor method for Attributes
     * @uses Attributes::setBusinessAccountClassAttributeDetail()
     * @uses Attributes::setAttributeDetail()
     * @uses Attributes::setAttributeValue()
     * @uses Attributes::setNonStockItemAttribute()
     * @uses Attributes::setItemClassAtrribute()
     * @param \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail[] $businessAccountClassAttributeDetail
     * @param \App\API\SOAP\StructType\AttributeDetail[] $attributeDetail
     * @param \App\API\SOAP\StructType\AttributeValue[] $attributeValue
     * @param \App\API\SOAP\StructType\NonStockItemAttribute[] $nonStockItemAttribute
     * @param \App\API\SOAP\StructType\ItemClassAtrribute[] $itemClassAtrribute
     */
    public function __construct(array $businessAccountClassAttributeDetail = array(), array $attributeDetail = array(), array $attributeValue = array(), array $nonStockItemAttribute = array(), array $itemClassAtrribute = array())
    {
        $this
            ->setBusinessAccountClassAttributeDetail($businessAccountClassAttributeDetail)
            ->setAttributeDetail($attributeDetail)
            ->setAttributeValue($attributeValue)
            ->setNonStockItemAttribute($nonStockItemAttribute)
            ->setItemClassAtrribute($itemClassAtrribute);
    }
    /**
     * Get BusinessAccountClassAttributeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail[]|null
     */
    public function getBusinessAccountClassAttributeDetail()
    {
        return isset($this->BusinessAccountClassAttributeDetail) ? $this->BusinessAccountClassAttributeDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountClassAttributeDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountClassAttributeDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountClassAttributeDetailForArrayConstraintsFromSetBusinessAccountClassAttributeDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributesBusinessAccountClassAttributeDetailItem) {
            // validation for constraint: itemType
            if (!$attributesBusinessAccountClassAttributeDetailItem instanceof \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail) {
                $invalidValues[] = is_object($attributesBusinessAccountClassAttributeDetailItem) ? get_class($attributesBusinessAccountClassAttributeDetailItem) : sprintf('%s(%s)', gettype($attributesBusinessAccountClassAttributeDetailItem), var_export($attributesBusinessAccountClassAttributeDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountClassAttributeDetail property can only contain items of type \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountClassAttributeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail[] $businessAccountClassAttributeDetail
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function setBusinessAccountClassAttributeDetail(array $businessAccountClassAttributeDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountClassAttributeDetailArrayErrorMessage = self::validateBusinessAccountClassAttributeDetailForArrayConstraintsFromSetBusinessAccountClassAttributeDetail($businessAccountClassAttributeDetail))) {
            throw new \InvalidArgumentException($businessAccountClassAttributeDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountClassAttributeDetail) || (is_array($businessAccountClassAttributeDetail) && empty($businessAccountClassAttributeDetail))) {
            unset($this->BusinessAccountClassAttributeDetail);
        } else {
            $this->BusinessAccountClassAttributeDetail = $businessAccountClassAttributeDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountClassAttributeDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail $item
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function addToBusinessAccountClassAttributeDetail(\App\API\SOAP\StructType\BusinessAccountClassAttributeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountClassAttributeDetail property can only contain items of type \App\API\SOAP\StructType\BusinessAccountClassAttributeDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountClassAttributeDetail[] = $item;
        return $this;
    }
    /**
     * Get AttributeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AttributeDetail[]|null
     */
    public function getAttributeDetail()
    {
        return isset($this->AttributeDetail) ? $this->AttributeDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttributeDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttributeDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeDetailForArrayConstraintsFromSetAttributeDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributesAttributeDetailItem) {
            // validation for constraint: itemType
            if (!$attributesAttributeDetailItem instanceof \App\API\SOAP\StructType\AttributeDetail) {
                $invalidValues[] = is_object($attributesAttributeDetailItem) ? get_class($attributesAttributeDetailItem) : sprintf('%s(%s)', gettype($attributesAttributeDetailItem), var_export($attributesAttributeDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttributeDetail property can only contain items of type \App\API\SOAP\StructType\AttributeDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttributeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AttributeDetail[] $attributeDetail
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function setAttributeDetail(array $attributeDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeDetailArrayErrorMessage = self::validateAttributeDetailForArrayConstraintsFromSetAttributeDetail($attributeDetail))) {
            throw new \InvalidArgumentException($attributeDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($attributeDetail) || (is_array($attributeDetail) && empty($attributeDetail))) {
            unset($this->AttributeDetail);
        } else {
            $this->AttributeDetail = $attributeDetail;
        }
        return $this;
    }
    /**
     * Add item to AttributeDetail value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AttributeDetail $item
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function addToAttributeDetail(\App\API\SOAP\StructType\AttributeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\AttributeDetail) {
            throw new \InvalidArgumentException(sprintf('The AttributeDetail property can only contain items of type \App\API\SOAP\StructType\AttributeDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttributeDetail[] = $item;
        return $this;
    }
    /**
     * Get AttributeValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AttributeValue[]|null
     */
    public function getAttributeValue()
    {
        return isset($this->AttributeValue) ? $this->AttributeValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttributeValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttributeValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeValueForArrayConstraintsFromSetAttributeValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributesAttributeValueItem) {
            // validation for constraint: itemType
            if (!$attributesAttributeValueItem instanceof \App\API\SOAP\StructType\AttributeValue) {
                $invalidValues[] = is_object($attributesAttributeValueItem) ? get_class($attributesAttributeValueItem) : sprintf('%s(%s)', gettype($attributesAttributeValueItem), var_export($attributesAttributeValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttributeValue property can only contain items of type \App\API\SOAP\StructType\AttributeValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttributeValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AttributeValue[] $attributeValue
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function setAttributeValue(array $attributeValue = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeValueArrayErrorMessage = self::validateAttributeValueForArrayConstraintsFromSetAttributeValue($attributeValue))) {
            throw new \InvalidArgumentException($attributeValueArrayErrorMessage, __LINE__);
        }
        if (is_null($attributeValue) || (is_array($attributeValue) && empty($attributeValue))) {
            unset($this->AttributeValue);
        } else {
            $this->AttributeValue = $attributeValue;
        }
        return $this;
    }
    /**
     * Add item to AttributeValue value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AttributeValue $item
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function addToAttributeValue(\App\API\SOAP\StructType\AttributeValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\AttributeValue) {
            throw new \InvalidArgumentException(sprintf('The AttributeValue property can only contain items of type \App\API\SOAP\StructType\AttributeValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttributeValue[] = $item;
        return $this;
    }
    /**
     * Get NonStockItemAttribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\NonStockItemAttribute[]|null
     */
    public function getNonStockItemAttribute()
    {
        return isset($this->NonStockItemAttribute) ? $this->NonStockItemAttribute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNonStockItemAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNonStockItemAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNonStockItemAttributeForArrayConstraintsFromSetNonStockItemAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributesNonStockItemAttributeItem) {
            // validation for constraint: itemType
            if (!$attributesNonStockItemAttributeItem instanceof \App\API\SOAP\StructType\NonStockItemAttribute) {
                $invalidValues[] = is_object($attributesNonStockItemAttributeItem) ? get_class($attributesNonStockItemAttributeItem) : sprintf('%s(%s)', gettype($attributesNonStockItemAttributeItem), var_export($attributesNonStockItemAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NonStockItemAttribute property can only contain items of type \App\API\SOAP\StructType\NonStockItemAttribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NonStockItemAttribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\NonStockItemAttribute[] $nonStockItemAttribute
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function setNonStockItemAttribute(array $nonStockItemAttribute = array())
    {
        // validation for constraint: array
        if ('' !== ($nonStockItemAttributeArrayErrorMessage = self::validateNonStockItemAttributeForArrayConstraintsFromSetNonStockItemAttribute($nonStockItemAttribute))) {
            throw new \InvalidArgumentException($nonStockItemAttributeArrayErrorMessage, __LINE__);
        }
        if (is_null($nonStockItemAttribute) || (is_array($nonStockItemAttribute) && empty($nonStockItemAttribute))) {
            unset($this->NonStockItemAttribute);
        } else {
            $this->NonStockItemAttribute = $nonStockItemAttribute;
        }
        return $this;
    }
    /**
     * Add item to NonStockItemAttribute value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\NonStockItemAttribute $item
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function addToNonStockItemAttribute(\App\API\SOAP\StructType\NonStockItemAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\NonStockItemAttribute) {
            throw new \InvalidArgumentException(sprintf('The NonStockItemAttribute property can only contain items of type \App\API\SOAP\StructType\NonStockItemAttribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NonStockItemAttribute[] = $item;
        return $this;
    }
    /**
     * Get ItemClassAtrribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ItemClassAtrribute[]|null
     */
    public function getItemClassAtrribute()
    {
        return isset($this->ItemClassAtrribute) ? $this->ItemClassAtrribute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemClassAtrribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemClassAtrribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemClassAtrributeForArrayConstraintsFromSetItemClassAtrribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributesItemClassAtrributeItem) {
            // validation for constraint: itemType
            if (!$attributesItemClassAtrributeItem instanceof \App\API\SOAP\StructType\ItemClassAtrribute) {
                $invalidValues[] = is_object($attributesItemClassAtrributeItem) ? get_class($attributesItemClassAtrributeItem) : sprintf('%s(%s)', gettype($attributesItemClassAtrributeItem), var_export($attributesItemClassAtrributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemClassAtrribute property can only contain items of type \App\API\SOAP\StructType\ItemClassAtrribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemClassAtrribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ItemClassAtrribute[] $itemClassAtrribute
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function setItemClassAtrribute(array $itemClassAtrribute = array())
    {
        // validation for constraint: array
        if ('' !== ($itemClassAtrributeArrayErrorMessage = self::validateItemClassAtrributeForArrayConstraintsFromSetItemClassAtrribute($itemClassAtrribute))) {
            throw new \InvalidArgumentException($itemClassAtrributeArrayErrorMessage, __LINE__);
        }
        if (is_null($itemClassAtrribute) || (is_array($itemClassAtrribute) && empty($itemClassAtrribute))) {
            unset($this->ItemClassAtrribute);
        } else {
            $this->ItemClassAtrribute = $itemClassAtrribute;
        }
        return $this;
    }
    /**
     * Add item to ItemClassAtrribute value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\ItemClassAtrribute $item
     * @return \App\API\SOAP\StructType\Attributes
     */
    public function addToItemClassAtrribute(\App\API\SOAP\StructType\ItemClassAtrribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\ItemClassAtrribute) {
            throw new \InvalidArgumentException(sprintf('The ItemClassAtrribute property can only contain items of type \App\API\SOAP\StructType\ItemClassAtrribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemClassAtrribute[] = $item;
        return $this;
    }
}
