<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeDefinitionValue StructType
 * @subpackage Structs
 */
class AttributeDefinitionValue extends Entity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Description;
    /**
     * The Disabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\BooleanValue
     */
    public $Disabled;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\ShortValue
     */
    public $SortOrder;
    /**
     * The ValueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ValueID;
    /**
     * Constructor method for AttributeDefinitionValue
     * @uses AttributeDefinitionValue::setDescription()
     * @uses AttributeDefinitionValue::setDisabled()
     * @uses AttributeDefinitionValue::setSortOrder()
     * @uses AttributeDefinitionValue::setValueID()
     * @param \App\API\SOAP\StructType\StringValue $description
     * @param \App\API\SOAP\StructType\BooleanValue $disabled
     * @param \App\API\SOAP\StructType\ShortValue $sortOrder
     * @param \App\API\SOAP\StructType\StringValue $valueID
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $description = null, \App\API\SOAP\StructType\BooleanValue $disabled = null, \App\API\SOAP\StructType\ShortValue $sortOrder = null, \App\API\SOAP\StructType\StringValue $valueID = null)
    {
        $this
            ->setDescription($description)
            ->setDisabled($disabled)
            ->setSortOrder($sortOrder)
            ->setValueID($valueID);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $description
     * @return \App\API\SOAP\StructType\AttributeDefinitionValue
     */
    public function setDescription(\App\API\SOAP\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Disabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\BooleanValue|null
     */
    public function getDisabled()
    {
        return isset($this->Disabled) ? $this->Disabled : null;
    }
    /**
     * Set Disabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\BooleanValue $disabled
     * @return \App\API\SOAP\StructType\AttributeDefinitionValue
     */
    public function setDisabled(\App\API\SOAP\StructType\BooleanValue $disabled = null)
    {
        if (is_null($disabled) || (is_array($disabled) && empty($disabled))) {
            unset($this->Disabled);
        } else {
            $this->Disabled = $disabled;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\ShortValue|null
     */
    public function getSortOrder()
    {
        return isset($this->SortOrder) ? $this->SortOrder : null;
    }
    /**
     * Set SortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\ShortValue $sortOrder
     * @return \App\API\SOAP\StructType\AttributeDefinitionValue
     */
    public function setSortOrder(\App\API\SOAP\StructType\ShortValue $sortOrder = null)
    {
        if (is_null($sortOrder) || (is_array($sortOrder) && empty($sortOrder))) {
            unset($this->SortOrder);
        } else {
            $this->SortOrder = $sortOrder;
        }
        return $this;
    }
    /**
     * Get ValueID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getValueID()
    {
        return isset($this->ValueID) ? $this->ValueID : null;
    }
    /**
     * Set ValueID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $valueID
     * @return \App\API\SOAP\StructType\AttributeDefinitionValue
     */
    public function setValueID(\App\API\SOAP\StructType\StringValue $valueID = null)
    {
        if (is_null($valueID) || (is_array($valueID) && empty($valueID))) {
            unset($this->ValueID);
        } else {
            $this->ValueID = $valueID;
        }
        return $this;
    }
}
