<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attribute StructType
 * @subpackage Structs
 */
class Attribute extends AbstractStructBase
{
    /**
     * The AttributeValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\AttributeValue[]
     */
    public $AttributeValue;
    /**
     * Constructor method for Attribute
     * @uses Attribute::setAttributeValue()
     * @param \App\API\SOAP\StructType\AttributeValue[] $attributeValue
     */
    public function __construct(array $attributeValue = array())
    {
        $this
            ->setAttributeValue($attributeValue);
    }
    /**
     * Get AttributeValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\AttributeValue[]|null
     */
    public function getAttributeValue()
    {
        return isset($this->AttributeValue) ? $this->AttributeValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttributeValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttributeValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeValueForArrayConstraintsFromSetAttributeValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributeAttributeValueItem) {
            // validation for constraint: itemType
            if (!$attributeAttributeValueItem instanceof \App\API\SOAP\StructType\AttributeValue) {
                $invalidValues[] = is_object($attributeAttributeValueItem) ? get_class($attributeAttributeValueItem) : sprintf('%s(%s)', gettype($attributeAttributeValueItem), var_export($attributeAttributeValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttributeValue property can only contain items of type \App\API\SOAP\StructType\AttributeValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttributeValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AttributeValue[] $attributeValue
     * @return \App\API\SOAP\StructType\Attribute
     */
    public function setAttributeValue(array $attributeValue = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeValueArrayErrorMessage = self::validateAttributeValueForArrayConstraintsFromSetAttributeValue($attributeValue))) {
            throw new \InvalidArgumentException($attributeValueArrayErrorMessage, __LINE__);
        }
        if (is_null($attributeValue) || (is_array($attributeValue) && empty($attributeValue))) {
            unset($this->AttributeValue);
        } else {
            $this->AttributeValue = $attributeValue;
        }
        return $this;
    }
    /**
     * Add item to AttributeValue value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\AttributeValue $item
     * @return \App\API\SOAP\StructType\Attribute
     */
    public function addToAttributeValue(\App\API\SOAP\StructType\AttributeValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\AttributeValue) {
            throw new \InvalidArgumentException(sprintf('The AttributeValue property can only contain items of type \App\API\SOAP\StructType\AttributeValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttributeValue[] = $item;
        return $this;
    }
}
