<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attendees StructType
 * @subpackage Structs
 */
class Attendees extends AbstractStructBase
{
    /**
     * The EventAttendee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\EventAttendee[]
     */
    public $EventAttendee;
    /**
     * Constructor method for Attendees
     * @uses Attendees::setEventAttendee()
     * @param \App\API\SOAP\StructType\EventAttendee[] $eventAttendee
     */
    public function __construct(array $eventAttendee = array())
    {
        $this
            ->setEventAttendee($eventAttendee);
    }
    /**
     * Get EventAttendee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\EventAttendee[]|null
     */
    public function getEventAttendee()
    {
        return isset($this->EventAttendee) ? $this->EventAttendee : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventAttendee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventAttendee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventAttendeeForArrayConstraintsFromSetEventAttendee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attendeesEventAttendeeItem) {
            // validation for constraint: itemType
            if (!$attendeesEventAttendeeItem instanceof \App\API\SOAP\StructType\EventAttendee) {
                $invalidValues[] = is_object($attendeesEventAttendeeItem) ? get_class($attendeesEventAttendeeItem) : sprintf('%s(%s)', gettype($attendeesEventAttendeeItem), var_export($attendeesEventAttendeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventAttendee property can only contain items of type \App\API\SOAP\StructType\EventAttendee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventAttendee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\EventAttendee[] $eventAttendee
     * @return \App\API\SOAP\StructType\Attendees
     */
    public function setEventAttendee(array $eventAttendee = array())
    {
        // validation for constraint: array
        if ('' !== ($eventAttendeeArrayErrorMessage = self::validateEventAttendeeForArrayConstraintsFromSetEventAttendee($eventAttendee))) {
            throw new \InvalidArgumentException($eventAttendeeArrayErrorMessage, __LINE__);
        }
        if (is_null($eventAttendee) || (is_array($eventAttendee) && empty($eventAttendee))) {
            unset($this->EventAttendee);
        } else {
            $this->EventAttendee = $eventAttendee;
        }
        return $this;
    }
    /**
     * Add item to EventAttendee value
     * @throws \InvalidArgumentException
     * @param \App\API\SOAP\StructType\EventAttendee $item
     * @return \App\API\SOAP\StructType\Attendees
     */
    public function addToEventAttendee(\App\API\SOAP\StructType\EventAttendee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\API\SOAP\StructType\EventAttendee) {
            throw new \InvalidArgumentException(sprintf('The EventAttendee property can only contain items of type \App\API\SOAP\StructType\EventAttendee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventAttendee[] = $item;
        return $this;
    }
}
