<?php

namespace App\API\SOAP\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Approval StructType
 * @subpackage Structs
 */
class Approval extends Entity
{
    /**
     * The ApprovedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ApprovedBy;
    /**
     * The ApprovedByName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ApprovedByName;
    /**
     * The Approver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Approver;
    /**
     * The ApproverName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $ApproverName;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Status;
    /**
     * The Workgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\API\SOAP\StructType\StringValue
     */
    public $Workgroup;
    /**
     * Constructor method for Approval
     * @uses Approval::setApprovedBy()
     * @uses Approval::setApprovedByName()
     * @uses Approval::setApprover()
     * @uses Approval::setApproverName()
     * @uses Approval::setDate()
     * @uses Approval::setStatus()
     * @uses Approval::setWorkgroup()
     * @param \App\API\SOAP\StructType\StringValue $approvedBy
     * @param \App\API\SOAP\StructType\StringValue $approvedByName
     * @param \App\API\SOAP\StructType\StringValue $approver
     * @param \App\API\SOAP\StructType\StringValue $approverName
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @param \App\API\SOAP\StructType\StringValue $status
     * @param \App\API\SOAP\StructType\StringValue $workgroup
     */
    public function __construct(\App\API\SOAP\StructType\StringValue $approvedBy = null, \App\API\SOAP\StructType\StringValue $approvedByName = null, \App\API\SOAP\StructType\StringValue $approver = null, \App\API\SOAP\StructType\StringValue $approverName = null, \App\API\SOAP\StructType\DateTimeValue $date = null, \App\API\SOAP\StructType\StringValue $status = null, \App\API\SOAP\StructType\StringValue $workgroup = null)
    {
        $this
            ->setApprovedBy($approvedBy)
            ->setApprovedByName($approvedByName)
            ->setApprover($approver)
            ->setApproverName($approverName)
            ->setDate($date)
            ->setStatus($status)
            ->setWorkgroup($workgroup);
    }
    /**
     * Get ApprovedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getApprovedBy()
    {
        return isset($this->ApprovedBy) ? $this->ApprovedBy : null;
    }
    /**
     * Set ApprovedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $approvedBy
     * @return \App\API\SOAP\StructType\Approval
     */
    public function setApprovedBy(\App\API\SOAP\StructType\StringValue $approvedBy = null)
    {
        if (is_null($approvedBy) || (is_array($approvedBy) && empty($approvedBy))) {
            unset($this->ApprovedBy);
        } else {
            $this->ApprovedBy = $approvedBy;
        }
        return $this;
    }
    /**
     * Get ApprovedByName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getApprovedByName()
    {
        return isset($this->ApprovedByName) ? $this->ApprovedByName : null;
    }
    /**
     * Set ApprovedByName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $approvedByName
     * @return \App\API\SOAP\StructType\Approval
     */
    public function setApprovedByName(\App\API\SOAP\StructType\StringValue $approvedByName = null)
    {
        if (is_null($approvedByName) || (is_array($approvedByName) && empty($approvedByName))) {
            unset($this->ApprovedByName);
        } else {
            $this->ApprovedByName = $approvedByName;
        }
        return $this;
    }
    /**
     * Get Approver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getApprover()
    {
        return isset($this->Approver) ? $this->Approver : null;
    }
    /**
     * Set Approver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $approver
     * @return \App\API\SOAP\StructType\Approval
     */
    public function setApprover(\App\API\SOAP\StructType\StringValue $approver = null)
    {
        if (is_null($approver) || (is_array($approver) && empty($approver))) {
            unset($this->Approver);
        } else {
            $this->Approver = $approver;
        }
        return $this;
    }
    /**
     * Get ApproverName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getApproverName()
    {
        return isset($this->ApproverName) ? $this->ApproverName : null;
    }
    /**
     * Set ApproverName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $approverName
     * @return \App\API\SOAP\StructType\Approval
     */
    public function setApproverName(\App\API\SOAP\StructType\StringValue $approverName = null)
    {
        if (is_null($approverName) || (is_array($approverName) && empty($approverName))) {
            unset($this->ApproverName);
        } else {
            $this->ApproverName = $approverName;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\DateTimeValue $date
     * @return \App\API\SOAP\StructType\Approval
     */
    public function setDate(\App\API\SOAP\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $status
     * @return \App\API\SOAP\StructType\Approval
     */
    public function setStatus(\App\API\SOAP\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Workgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\API\SOAP\StructType\StringValue|null
     */
    public function getWorkgroup()
    {
        return isset($this->Workgroup) ? $this->Workgroup : null;
    }
    /**
     * Set Workgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\API\SOAP\StructType\StringValue $workgroup
     * @return \App\API\SOAP\StructType\Approval
     */
    public function setWorkgroup(\App\API\SOAP\StructType\StringValue $workgroup = null)
    {
        if (is_null($workgroup) || (is_array($workgroup) && empty($workgroup))) {
            unset($this->Workgroup);
        } else {
            $this->Workgroup = $workgroup;
        }
        return $this;
    }
}
